/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Inference configuration for text-based AI Prompts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TextAIPromptInferenceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TextAIPromptInferenceConfiguration.Builder, TextAIPromptInferenceConfiguration> {
    private static final SdkField<Float> TEMPERATURE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("temperature").getter(getter(TextAIPromptInferenceConfiguration::temperature))
            .setter(setter(Builder::temperature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("temperature").build()).build();

    private static final SdkField<Float> TOPP_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("topP")
            .getter(getter(TextAIPromptInferenceConfiguration::topP)).setter(setter(Builder::topP))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topP").build()).build();

    private static final SdkField<Integer> TOPK_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("topK")
            .getter(getter(TextAIPromptInferenceConfiguration::topK)).setter(setter(Builder::topK))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topK").build()).build();

    private static final SdkField<Integer> MAX_TOKENS_TO_SAMPLE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxTokensToSample").getter(getter(TextAIPromptInferenceConfiguration::maxTokensToSample))
            .setter(setter(Builder::maxTokensToSample))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxTokensToSample").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPERATURE_FIELD, TOPP_FIELD,
            TOPK_FIELD, MAX_TOKENS_TO_SAMPLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Float temperature;

    private final Float topP;

    private final Integer topK;

    private final Integer maxTokensToSample;

    private TextAIPromptInferenceConfiguration(BuilderImpl builder) {
        this.temperature = builder.temperature;
        this.topP = builder.topP;
        this.topK = builder.topK;
        this.maxTokensToSample = builder.maxTokensToSample;
    }

    /**
     * <p>
     * The temperature setting for controlling randomness in the generated response.
     * </p>
     * 
     * @return The temperature setting for controlling randomness in the generated response.
     */
    public final Float temperature() {
        return temperature;
    }

    /**
     * <p>
     * The top-P sampling parameter for nucleus sampling.
     * </p>
     * 
     * @return The top-P sampling parameter for nucleus sampling.
     */
    public final Float topP() {
        return topP;
    }

    /**
     * <p>
     * The top-K sampling parameter for token selection.
     * </p>
     * 
     * @return The top-K sampling parameter for token selection.
     */
    public final Integer topK() {
        return topK;
    }

    /**
     * <p>
     * The maximum number of tokens to generate in the response.
     * </p>
     * 
     * @return The maximum number of tokens to generate in the response.
     */
    public final Integer maxTokensToSample() {
        return maxTokensToSample;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(temperature());
        hashCode = 31 * hashCode + Objects.hashCode(topP());
        hashCode = 31 * hashCode + Objects.hashCode(topK());
        hashCode = 31 * hashCode + Objects.hashCode(maxTokensToSample());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextAIPromptInferenceConfiguration)) {
            return false;
        }
        TextAIPromptInferenceConfiguration other = (TextAIPromptInferenceConfiguration) obj;
        return Objects.equals(temperature(), other.temperature()) && Objects.equals(topP(), other.topP())
                && Objects.equals(topK(), other.topK()) && Objects.equals(maxTokensToSample(), other.maxTokensToSample());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TextAIPromptInferenceConfiguration")
                .add("Temperature", temperature() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TopP", topP() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TopK", topK() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MaxTokensToSample", maxTokensToSample() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "temperature":
            return Optional.ofNullable(clazz.cast(temperature()));
        case "topP":
            return Optional.ofNullable(clazz.cast(topP()));
        case "topK":
            return Optional.ofNullable(clazz.cast(topK()));
        case "maxTokensToSample":
            return Optional.ofNullable(clazz.cast(maxTokensToSample()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("temperature", TEMPERATURE_FIELD);
        map.put("topP", TOPP_FIELD);
        map.put("topK", TOPK_FIELD);
        map.put("maxTokensToSample", MAX_TOKENS_TO_SAMPLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TextAIPromptInferenceConfiguration, T> g) {
        return obj -> g.apply((TextAIPromptInferenceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TextAIPromptInferenceConfiguration> {
        /**
         * <p>
         * The temperature setting for controlling randomness in the generated response.
         * </p>
         * 
         * @param temperature
         *        The temperature setting for controlling randomness in the generated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder temperature(Float temperature);

        /**
         * <p>
         * The top-P sampling parameter for nucleus sampling.
         * </p>
         * 
         * @param topP
         *        The top-P sampling parameter for nucleus sampling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topP(Float topP);

        /**
         * <p>
         * The top-K sampling parameter for token selection.
         * </p>
         * 
         * @param topK
         *        The top-K sampling parameter for token selection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topK(Integer topK);

        /**
         * <p>
         * The maximum number of tokens to generate in the response.
         * </p>
         * 
         * @param maxTokensToSample
         *        The maximum number of tokens to generate in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxTokensToSample(Integer maxTokensToSample);
    }

    static final class BuilderImpl implements Builder {
        private Float temperature;

        private Float topP;

        private Integer topK;

        private Integer maxTokensToSample;

        private BuilderImpl() {
        }

        private BuilderImpl(TextAIPromptInferenceConfiguration model) {
            temperature(model.temperature);
            topP(model.topP);
            topK(model.topK);
            maxTokensToSample(model.maxTokensToSample);
        }

        public final Float getTemperature() {
            return temperature;
        }

        public final void setTemperature(Float temperature) {
            this.temperature = temperature;
        }

        @Override
        public final Builder temperature(Float temperature) {
            this.temperature = temperature;
            return this;
        }

        public final Float getTopP() {
            return topP;
        }

        public final void setTopP(Float topP) {
            this.topP = topP;
        }

        @Override
        public final Builder topP(Float topP) {
            this.topP = topP;
            return this;
        }

        public final Integer getTopK() {
            return topK;
        }

        public final void setTopK(Integer topK) {
            this.topK = topK;
        }

        @Override
        public final Builder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public final Integer getMaxTokensToSample() {
            return maxTokensToSample;
        }

        public final void setMaxTokensToSample(Integer maxTokensToSample) {
            this.maxTokensToSample = maxTokensToSample;
        }

        @Override
        public final Builder maxTokensToSample(Integer maxTokensToSample) {
            this.maxTokensToSample = maxTokensToSample;
            return this;
        }

        @Override
        public TextAIPromptInferenceConfiguration build() {
            return new TextAIPromptInferenceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
