/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that can be used to specify Tag conditions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TagFilter implements SdkPojo, Serializable, ToCopyableBuilder<TagFilter.Builder, TagFilter> {
    private static final SdkField<TagCondition> TAG_CONDITION_FIELD = SdkField.<TagCondition> builder(MarshallingType.SDK_POJO)
            .memberName("tagCondition").getter(getter(TagFilter::tagCondition)).setter(setter(Builder::tagCondition))
            .constructor(TagCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagCondition").build()).build();

    private static final SdkField<List<TagCondition>> AND_CONDITIONS_FIELD = SdkField
            .<List<TagCondition>> builder(MarshallingType.LIST)
            .memberName("andConditions")
            .getter(getter(TagFilter::andConditions))
            .setter(setter(Builder::andConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("andConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<OrCondition>> OR_CONDITIONS_FIELD = SdkField
            .<List<OrCondition>> builder(MarshallingType.LIST)
            .memberName("orConditions")
            .getter(getter(TagFilter::orConditions))
            .setter(setter(Builder::orConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OrCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(OrCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_CONDITION_FIELD,
            AND_CONDITIONS_FIELD, OR_CONDITIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TagCondition tagCondition;

    private final List<TagCondition> andConditions;

    private final List<OrCondition> orConditions;

    private final Type type;

    private TagFilter(BuilderImpl builder) {
        this.tagCondition = builder.tagCondition;
        this.andConditions = builder.andConditions;
        this.orConditions = builder.orConditions;
        this.type = builder.type;
    }

    /**
     * <p>
     * A leaf node condition which can be used to specify a tag condition.
     * </p>
     * 
     * @return A leaf node condition which can be used to specify a tag condition.
     */
    public final TagCondition tagCondition() {
        return tagCondition;
    }

    /**
     * For responses, this returns true if the service returned a value for the AndConditions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAndConditions() {
        return andConditions != null && !(andConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of conditions which would be applied together with an <code>AND</code> condition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAndConditions} method.
     * </p>
     * 
     * @return A list of conditions which would be applied together with an <code>AND</code> condition.
     */
    public final List<TagCondition> andConditions() {
        return andConditions;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrConditions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOrConditions() {
        return orConditions != null && !(orConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of conditions which would be applied together with an <code>OR</code> condition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrConditions} method.
     * </p>
     * 
     * @return A list of conditions which would be applied together with an <code>OR</code> condition.
     */
    public final List<OrCondition> orConditions() {
        return orConditions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tagCondition());
        hashCode = 31 * hashCode + Objects.hashCode(hasAndConditions() ? andConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOrConditions() ? orConditions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagFilter)) {
            return false;
        }
        TagFilter other = (TagFilter) obj;
        return Objects.equals(tagCondition(), other.tagCondition()) && hasAndConditions() == other.hasAndConditions()
                && Objects.equals(andConditions(), other.andConditions()) && hasOrConditions() == other.hasOrConditions()
                && Objects.equals(orConditions(), other.orConditions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TagFilter").add("TagCondition", tagCondition())
                .add("AndConditions", hasAndConditions() ? andConditions() : null)
                .add("OrConditions", hasOrConditions() ? orConditions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tagCondition":
            return Optional.ofNullable(clazz.cast(tagCondition()));
        case "andConditions":
            return Optional.ofNullable(clazz.cast(andConditions()));
        case "orConditions":
            return Optional.ofNullable(clazz.cast(orConditions()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #tagCondition()} initialized to the given value.
     *
     * <p>
     * A leaf node condition which can be used to specify a tag condition.
     * </p>
     * 
     * @param tagCondition
     *        A leaf node condition which can be used to specify a tag condition.
     */
    public static TagFilter fromTagCondition(TagCondition tagCondition) {
        return builder().tagCondition(tagCondition).build();
    }

    /**
     * Create an instance of this class with {@link #tagCondition()} initialized to the given value.
     *
     * <p>
     * A leaf node condition which can be used to specify a tag condition.
     * </p>
     * 
     * @param tagCondition
     *        A leaf node condition which can be used to specify a tag condition.
     */
    public static TagFilter fromTagCondition(Consumer<TagCondition.Builder> tagCondition) {
        TagCondition.Builder builder = TagCondition.builder();
        tagCondition.accept(builder);
        return fromTagCondition(builder.build());
    }

    /**
     * Create an instance of this class with {@link #andConditions()} initialized to the given value.
     *
     * <p>
     * A list of conditions which would be applied together with an <code>AND</code> condition.
     * </p>
     * 
     * @param andConditions
     *        A list of conditions which would be applied together with an <code>AND</code> condition.
     */
    public static TagFilter fromAndConditions(List<TagCondition> andConditions) {
        return builder().andConditions(andConditions).build();
    }

    /**
     * Create an instance of this class with {@link #orConditions()} initialized to the given value.
     *
     * <p>
     * A list of conditions which would be applied together with an <code>OR</code> condition.
     * </p>
     * 
     * @param orConditions
     *        A list of conditions which would be applied together with an <code>OR</code> condition.
     */
    public static TagFilter fromOrConditions(List<OrCondition> orConditions) {
        return builder().orConditions(orConditions).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("tagCondition", TAG_CONDITION_FIELD);
        map.put("andConditions", AND_CONDITIONS_FIELD);
        map.put("orConditions", OR_CONDITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TagFilter, T> g) {
        return obj -> g.apply((TagFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TagFilter> {
        /**
         * <p>
         * A leaf node condition which can be used to specify a tag condition.
         * </p>
         * 
         * @param tagCondition
         *        A leaf node condition which can be used to specify a tag condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagCondition(TagCondition tagCondition);

        /**
         * <p>
         * A leaf node condition which can be used to specify a tag condition.
         * </p>
         * This is a convenience method that creates an instance of the {@link TagCondition.Builder} avoiding the need
         * to create one manually via {@link TagCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TagCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #tagCondition(TagCondition)}.
         * 
         * @param tagCondition
         *        a consumer that will call methods on {@link TagCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagCondition(TagCondition)
         */
        default Builder tagCondition(Consumer<TagCondition.Builder> tagCondition) {
            return tagCondition(TagCondition.builder().applyMutation(tagCondition).build());
        }

        /**
         * <p>
         * A list of conditions which would be applied together with an <code>AND</code> condition.
         * </p>
         * 
         * @param andConditions
         *        A list of conditions which would be applied together with an <code>AND</code> condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andConditions(Collection<TagCondition> andConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an <code>AND</code> condition.
         * </p>
         * 
         * @param andConditions
         *        A list of conditions which would be applied together with an <code>AND</code> condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andConditions(TagCondition... andConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an <code>AND</code> condition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.TagCondition.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qconnect.model.TagCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.TagCondition.Builder#build()} is called immediately and
         * its result is passed to {@link #andConditions(List<TagCondition>)}.
         * 
         * @param andConditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.TagCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #andConditions(java.util.Collection<TagCondition>)
         */
        Builder andConditions(Consumer<TagCondition.Builder>... andConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an <code>OR</code> condition.
         * </p>
         * 
         * @param orConditions
         *        A list of conditions which would be applied together with an <code>OR</code> condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orConditions(Collection<OrCondition> orConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an <code>OR</code> condition.
         * </p>
         * 
         * @param orConditions
         *        A list of conditions which would be applied together with an <code>OR</code> condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orConditions(OrCondition... orConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an <code>OR</code> condition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.OrCondition.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qconnect.model.OrCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.OrCondition.Builder#build()} is called immediately and
         * its result is passed to {@link #orConditions(List<OrCondition>)}.
         * 
         * @param orConditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.OrCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orConditions(java.util.Collection<OrCondition>)
         */
        Builder orConditions(Consumer<OrCondition.Builder>... orConditions);
    }

    static final class BuilderImpl implements Builder {
        private TagCondition tagCondition;

        private List<TagCondition> andConditions = DefaultSdkAutoConstructList.getInstance();

        private List<OrCondition> orConditions = DefaultSdkAutoConstructList.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(TagFilter model) {
            tagCondition(model.tagCondition);
            andConditions(model.andConditions);
            orConditions(model.orConditions);
        }

        public final TagCondition.Builder getTagCondition() {
            return tagCondition != null ? tagCondition.toBuilder() : null;
        }

        public final void setTagCondition(TagCondition.BuilderImpl tagCondition) {
            Object oldValue = this.tagCondition;
            this.tagCondition = tagCondition != null ? tagCondition.build() : null;
            handleUnionValueChange(Type.TAG_CONDITION, oldValue, this.tagCondition);
        }

        @Override
        public final Builder tagCondition(TagCondition tagCondition) {
            Object oldValue = this.tagCondition;
            this.tagCondition = tagCondition;
            handleUnionValueChange(Type.TAG_CONDITION, oldValue, this.tagCondition);
            return this;
        }

        public final List<TagCondition.Builder> getAndConditions() {
            List<TagCondition.Builder> result = AndConditionsCopier.copyToBuilder(this.andConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAndConditions(Collection<TagCondition.BuilderImpl> andConditions) {
            Object oldValue = this.andConditions;
            this.andConditions = AndConditionsCopier.copyFromBuilder(andConditions);
            handleUnionValueChange(Type.AND_CONDITIONS, oldValue, this.andConditions);
        }

        @Override
        public final Builder andConditions(Collection<TagCondition> andConditions) {
            Object oldValue = this.andConditions;
            this.andConditions = AndConditionsCopier.copy(andConditions);
            handleUnionValueChange(Type.AND_CONDITIONS, oldValue, this.andConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andConditions(TagCondition... andConditions) {
            andConditions(Arrays.asList(andConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andConditions(Consumer<TagCondition.Builder>... andConditions) {
            andConditions(Stream.of(andConditions).map(c -> TagCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<OrCondition.Builder> getOrConditions() {
            List<OrCondition.Builder> result = OrConditionsCopier.copyToBuilder(this.orConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrConditions(Collection<OrCondition.BuilderImpl> orConditions) {
            Object oldValue = this.orConditions;
            this.orConditions = OrConditionsCopier.copyFromBuilder(orConditions);
            handleUnionValueChange(Type.OR_CONDITIONS, oldValue, this.orConditions);
        }

        @Override
        public final Builder orConditions(Collection<OrCondition> orConditions) {
            Object oldValue = this.orConditions;
            this.orConditions = OrConditionsCopier.copy(orConditions);
            handleUnionValueChange(Type.OR_CONDITIONS, oldValue, this.orConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(OrCondition... orConditions) {
            orConditions(Arrays.asList(orConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(Consumer<OrCondition.Builder>... orConditions) {
            orConditions(Stream.of(orConditions).map(c -> OrCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public TagFilter build() {
            return new TagFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see TagFilter#type()
     */
    public enum Type {
        TAG_CONDITION,

        AND_CONDITIONS,

        OR_CONDITIONS,

        UNKNOWN_TO_SDK_VERSION
    }
}
