/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about suggested message data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SuggestedMessageDataDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<SuggestedMessageDataDetails.Builder, SuggestedMessageDataDetails> {
    private static final SdkField<String> MESSAGE_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("messageText").getter(getter(SuggestedMessageDataDetails::messageText))
            .setter(setter(Builder::messageText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageText").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_TEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String messageText;

    private SuggestedMessageDataDetails(BuilderImpl builder) {
        this.messageText = builder.messageText;
    }

    /**
     * <p>
     * The text content of the suggested message.
     * </p>
     * 
     * @return The text content of the suggested message.
     */
    public final String messageText() {
        return messageText;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(messageText());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuggestedMessageDataDetails)) {
            return false;
        }
        SuggestedMessageDataDetails other = (SuggestedMessageDataDetails) obj;
        return Objects.equals(messageText(), other.messageText());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SuggestedMessageDataDetails")
                .add("MessageText", messageText() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "messageText":
            return Optional.ofNullable(clazz.cast(messageText()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("messageText", MESSAGE_TEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SuggestedMessageDataDetails, T> g) {
        return obj -> g.apply((SuggestedMessageDataDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SuggestedMessageDataDetails> {
        /**
         * <p>
         * The text content of the suggested message.
         * </p>
         * 
         * @param messageText
         *        The text content of the suggested message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageText(String messageText);
    }

    static final class BuilderImpl implements Builder {
        private String messageText;

        private BuilderImpl() {
        }

        private BuilderImpl(SuggestedMessageDataDetails model) {
            messageText(model.messageText);
        }

        public final String getMessageText() {
            return messageText;
        }

        public final void setMessageText(String messageText) {
            this.messageText = messageText;
        }

        @Override
        public final Builder messageText(String messageText) {
            this.messageText = messageText;
            return this;
        }

        @Override
        public SuggestedMessageDataDetails build() {
            return new SuggestedMessageDataDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
