/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Tool result message content
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpanToolResultValue implements SdkPojo, Serializable,
        ToCopyableBuilder<SpanToolResultValue.Builder, SpanToolResultValue> {
    private static final SdkField<String> TOOL_USE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("toolUseId").getter(getter(SpanToolResultValue::toolUseId)).setter(setter(Builder::toolUseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolUseId").build()).build();

    private static final SdkField<List<SpanMessageValue>> VALUES_FIELD = SdkField
            .<List<SpanMessageValue>> builder(MarshallingType.LIST)
            .memberName("values")
            .getter(getter(SpanToolResultValue::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SpanMessageValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(SpanMessageValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("error")
            .getter(getter(SpanToolResultValue::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOOL_USE_ID_FIELD,
            VALUES_FIELD, ERROR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String toolUseId;

    private final List<SpanMessageValue> values;

    private final String error;

    private SpanToolResultValue(BuilderImpl builder) {
        this.toolUseId = builder.toolUseId;
        this.values = builder.values;
        this.error = builder.error;
    }

    /**
     * <p>
     * Relates this result back to the tool invocation
     * </p>
     * 
     * @return Relates this result back to the tool invocation
     */
    public final String toolUseId() {
        return toolUseId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tool results
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return The tool results
     */
    public final List<SpanMessageValue> values() {
        return values;
    }

    /**
     * <p>
     * The tool invocation error if failed
     * </p>
     * 
     * @return The tool invocation error if failed
     */
    public final String error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(toolUseId());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpanToolResultValue)) {
            return false;
        }
        SpanToolResultValue other = (SpanToolResultValue) obj;
        return Objects.equals(toolUseId(), other.toolUseId()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values()) && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpanToolResultValue").add("ToolUseId", toolUseId()).add("Values", hasValues() ? values() : null)
                .add("Error", error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "toolUseId":
            return Optional.ofNullable(clazz.cast(toolUseId()));
        case "values":
            return Optional.ofNullable(clazz.cast(values()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("toolUseId", TOOL_USE_ID_FIELD);
        map.put("values", VALUES_FIELD);
        map.put("error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SpanToolResultValue, T> g) {
        return obj -> g.apply((SpanToolResultValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpanToolResultValue> {
        /**
         * <p>
         * Relates this result back to the tool invocation
         * </p>
         * 
         * @param toolUseId
         *        Relates this result back to the tool invocation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toolUseId(String toolUseId);

        /**
         * <p>
         * The tool results
         * </p>
         * 
         * @param values
         *        The tool results
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<SpanMessageValue> values);

        /**
         * <p>
         * The tool results
         * </p>
         * 
         * @param values
         *        The tool results
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(SpanMessageValue... values);

        /**
         * <p>
         * The tool results
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.SpanMessageValue.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.qconnect.model.SpanMessageValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.SpanMessageValue.Builder#build()} is called immediately
         * and its result is passed to {@link #values(List<SpanMessageValue>)}.
         * 
         * @param values
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.SpanMessageValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #values(java.util.Collection<SpanMessageValue>)
         */
        Builder values(Consumer<SpanMessageValue.Builder>... values);

        /**
         * <p>
         * The tool invocation error if failed
         * </p>
         * 
         * @param error
         *        The tool invocation error if failed
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(String error);
    }

    static final class BuilderImpl implements Builder {
        private String toolUseId;

        private List<SpanMessageValue> values = DefaultSdkAutoConstructList.getInstance();

        private String error;

        private BuilderImpl() {
        }

        private BuilderImpl(SpanToolResultValue model) {
            toolUseId(model.toolUseId);
            values(model.values);
            error(model.error);
        }

        public final String getToolUseId() {
            return toolUseId;
        }

        public final void setToolUseId(String toolUseId) {
            this.toolUseId = toolUseId;
        }

        @Override
        public final Builder toolUseId(String toolUseId) {
            this.toolUseId = toolUseId;
            return this;
        }

        public final List<SpanMessageValue.Builder> getValues() {
            List<SpanMessageValue.Builder> result = SpanMessageValueListCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<SpanMessageValue.BuilderImpl> values) {
            this.values = SpanMessageValueListCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<SpanMessageValue> values) {
            this.values = SpanMessageValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(SpanMessageValue... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<SpanMessageValue.Builder>... values) {
            values(Stream.of(values).map(c -> SpanMessageValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getError() {
            return error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        @Override
        public SpanToolResultValue build() {
            return new SpanToolResultValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
