/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Text message content
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpanTextValue implements SdkPojo, Serializable, ToCopyableBuilder<SpanTextValue.Builder, SpanTextValue> {
    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("value")
            .getter(getter(SpanTextValue::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<List<SpanCitation>> CITATIONS_FIELD = SdkField
            .<List<SpanCitation>> builder(MarshallingType.LIST)
            .memberName("citations")
            .getter(getter(SpanTextValue::citations))
            .setter(setter(Builder::citations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("citations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SpanCitation> builder(MarshallingType.SDK_POJO)
                                            .constructor(SpanCitation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AIGuardrailAssessment> AI_GUARDRAIL_ASSESSMENT_FIELD = SdkField
            .<AIGuardrailAssessment> builder(MarshallingType.SDK_POJO).memberName("aiGuardrailAssessment")
            .getter(getter(SpanTextValue::aiGuardrailAssessment)).setter(setter(Builder::aiGuardrailAssessment))
            .constructor(AIGuardrailAssessment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiGuardrailAssessment").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, CITATIONS_FIELD,
            AI_GUARDRAIL_ASSESSMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String value;

    private final List<SpanCitation> citations;

    private final AIGuardrailAssessment aiGuardrailAssessment;

    private SpanTextValue(BuilderImpl builder) {
        this.value = builder.value;
        this.citations = builder.citations;
        this.aiGuardrailAssessment = builder.aiGuardrailAssessment;
    }

    /**
     * <p>
     * String content of the message text
     * </p>
     * 
     * @return String content of the message text
     */
    public final String value() {
        return value;
    }

    /**
     * For responses, this returns true if the service returned a value for the Citations property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCitations() {
        return citations != null && !(citations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The citations associated with the span text.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCitations} method.
     * </p>
     * 
     * @return The citations associated with the span text.
     */
    public final List<SpanCitation> citations() {
        return citations;
    }

    /**
     * <p>
     * The AI Guardrail assessment for the span text.
     * </p>
     * 
     * @return The AI Guardrail assessment for the span text.
     */
    public final AIGuardrailAssessment aiGuardrailAssessment() {
        return aiGuardrailAssessment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(hasCitations() ? citations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(aiGuardrailAssessment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpanTextValue)) {
            return false;
        }
        SpanTextValue other = (SpanTextValue) obj;
        return Objects.equals(value(), other.value()) && hasCitations() == other.hasCitations()
                && Objects.equals(citations(), other.citations())
                && Objects.equals(aiGuardrailAssessment(), other.aiGuardrailAssessment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpanTextValue").add("Value", value() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Citations", hasCitations() ? citations() : null).add("AiGuardrailAssessment", aiGuardrailAssessment())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "citations":
            return Optional.ofNullable(clazz.cast(citations()));
        case "aiGuardrailAssessment":
            return Optional.ofNullable(clazz.cast(aiGuardrailAssessment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("value", VALUE_FIELD);
        map.put("citations", CITATIONS_FIELD);
        map.put("aiGuardrailAssessment", AI_GUARDRAIL_ASSESSMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SpanTextValue, T> g) {
        return obj -> g.apply((SpanTextValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpanTextValue> {
        /**
         * <p>
         * String content of the message text
         * </p>
         * 
         * @param value
         *        String content of the message text
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The citations associated with the span text.
         * </p>
         * 
         * @param citations
         *        The citations associated with the span text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder citations(Collection<SpanCitation> citations);

        /**
         * <p>
         * The citations associated with the span text.
         * </p>
         * 
         * @param citations
         *        The citations associated with the span text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder citations(SpanCitation... citations);

        /**
         * <p>
         * The citations associated with the span text.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.SpanCitation.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qconnect.model.SpanCitation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.SpanCitation.Builder#build()} is called immediately and
         * its result is passed to {@link #citations(List<SpanCitation>)}.
         * 
         * @param citations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.SpanCitation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #citations(java.util.Collection<SpanCitation>)
         */
        Builder citations(Consumer<SpanCitation.Builder>... citations);

        /**
         * <p>
         * The AI Guardrail assessment for the span text.
         * </p>
         * 
         * @param aiGuardrailAssessment
         *        The AI Guardrail assessment for the span text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiGuardrailAssessment(AIGuardrailAssessment aiGuardrailAssessment);

        /**
         * <p>
         * The AI Guardrail assessment for the span text.
         * </p>
         * This is a convenience method that creates an instance of the {@link AIGuardrailAssessment.Builder} avoiding
         * the need to create one manually via {@link AIGuardrailAssessment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AIGuardrailAssessment.Builder#build()} is called immediately and
         * its result is passed to {@link #aiGuardrailAssessment(AIGuardrailAssessment)}.
         * 
         * @param aiGuardrailAssessment
         *        a consumer that will call methods on {@link AIGuardrailAssessment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aiGuardrailAssessment(AIGuardrailAssessment)
         */
        default Builder aiGuardrailAssessment(Consumer<AIGuardrailAssessment.Builder> aiGuardrailAssessment) {
            return aiGuardrailAssessment(AIGuardrailAssessment.builder().applyMutation(aiGuardrailAssessment).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String value;

        private List<SpanCitation> citations = DefaultSdkAutoConstructList.getInstance();

        private AIGuardrailAssessment aiGuardrailAssessment;

        private BuilderImpl() {
        }

        private BuilderImpl(SpanTextValue model) {
            value(model.value);
            citations(model.citations);
            aiGuardrailAssessment(model.aiGuardrailAssessment);
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final List<SpanCitation.Builder> getCitations() {
            List<SpanCitation.Builder> result = SpanCitationListCopier.copyToBuilder(this.citations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCitations(Collection<SpanCitation.BuilderImpl> citations) {
            this.citations = SpanCitationListCopier.copyFromBuilder(citations);
        }

        @Override
        public final Builder citations(Collection<SpanCitation> citations) {
            this.citations = SpanCitationListCopier.copy(citations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder citations(SpanCitation... citations) {
            citations(Arrays.asList(citations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder citations(Consumer<SpanCitation.Builder>... citations) {
            citations(Stream.of(citations).map(c -> SpanCitation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final AIGuardrailAssessment.Builder getAiGuardrailAssessment() {
            return aiGuardrailAssessment != null ? aiGuardrailAssessment.toBuilder() : null;
        }

        public final void setAiGuardrailAssessment(AIGuardrailAssessment.BuilderImpl aiGuardrailAssessment) {
            this.aiGuardrailAssessment = aiGuardrailAssessment != null ? aiGuardrailAssessment.build() : null;
        }

        @Override
        public final Builder aiGuardrailAssessment(AIGuardrailAssessment aiGuardrailAssessment) {
            this.aiGuardrailAssessment = aiGuardrailAssessment;
            return this;
        }

        @Override
        public SpanTextValue build() {
            return new SpanTextValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
