/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A message in the conversation history with participant role and content values
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpanMessage implements SdkPojo, Serializable, ToCopyableBuilder<SpanMessage.Builder, SpanMessage> {
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("messageId").getter(getter(SpanMessage::messageId)).setter(setter(Builder::messageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageId").build()).build();

    private static final SdkField<String> PARTICIPANT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("participant").getter(getter(SpanMessage::participantAsString)).setter(setter(Builder::participant))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participant").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("timestamp").getter(getter(SpanMessage::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()).build();

    private static final SdkField<List<SpanMessageValue>> VALUES_FIELD = SdkField
            .<List<SpanMessageValue>> builder(MarshallingType.LIST)
            .memberName("values")
            .getter(getter(SpanMessage::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SpanMessageValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(SpanMessageValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_ID_FIELD,
            PARTICIPANT_FIELD, TIMESTAMP_FIELD, VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String messageId;

    private final String participant;

    private final Instant timestamp;

    private final List<SpanMessageValue> values;

    private SpanMessage(BuilderImpl builder) {
        this.messageId = builder.messageId;
        this.participant = builder.participant;
        this.timestamp = builder.timestamp;
        this.values = builder.values;
    }

    /**
     * <p>
     * Unique message identifier
     * </p>
     * 
     * @return Unique message identifier
     */
    public final String messageId() {
        return messageId;
    }

    /**
     * <p>
     * Message source role
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participant} will
     * return {@link Participant#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #participantAsString}.
     * </p>
     * 
     * @return Message source role
     * @see Participant
     */
    public final Participant participant() {
        return Participant.fromValue(participant);
    }

    /**
     * <p>
     * Message source role
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participant} will
     * return {@link Participant#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #participantAsString}.
     * </p>
     * 
     * @return Message source role
     * @see Participant
     */
    public final String participantAsString() {
        return participant;
    }

    /**
     * <p>
     * Message timestamp
     * </p>
     * 
     * @return Message timestamp
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Message content values (text, tool use, tool result)
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return Message content values (text, tool use, tool result)
     */
    public final List<SpanMessageValue> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(messageId());
        hashCode = 31 * hashCode + Objects.hashCode(participantAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpanMessage)) {
            return false;
        }
        SpanMessage other = (SpanMessage) obj;
        return Objects.equals(messageId(), other.messageId())
                && Objects.equals(participantAsString(), other.participantAsString())
                && Objects.equals(timestamp(), other.timestamp()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpanMessage").add("MessageId", messageId()).add("Participant", participantAsString())
                .add("Timestamp", timestamp()).add("Values", hasValues() ? values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "messageId":
            return Optional.ofNullable(clazz.cast(messageId()));
        case "participant":
            return Optional.ofNullable(clazz.cast(participantAsString()));
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("messageId", MESSAGE_ID_FIELD);
        map.put("participant", PARTICIPANT_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        map.put("values", VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SpanMessage, T> g) {
        return obj -> g.apply((SpanMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpanMessage> {
        /**
         * <p>
         * Unique message identifier
         * </p>
         * 
         * @param messageId
         *        Unique message identifier
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);

        /**
         * <p>
         * Message source role
         * </p>
         * 
         * @param participant
         *        Message source role
         * @see Participant
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Participant
         */
        Builder participant(String participant);

        /**
         * <p>
         * Message source role
         * </p>
         * 
         * @param participant
         *        Message source role
         * @see Participant
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Participant
         */
        Builder participant(Participant participant);

        /**
         * <p>
         * Message timestamp
         * </p>
         * 
         * @param timestamp
         *        Message timestamp
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * Message content values (text, tool use, tool result)
         * </p>
         * 
         * @param values
         *        Message content values (text, tool use, tool result)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<SpanMessageValue> values);

        /**
         * <p>
         * Message content values (text, tool use, tool result)
         * </p>
         * 
         * @param values
         *        Message content values (text, tool use, tool result)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(SpanMessageValue... values);

        /**
         * <p>
         * Message content values (text, tool use, tool result)
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.SpanMessageValue.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.qconnect.model.SpanMessageValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.SpanMessageValue.Builder#build()} is called immediately
         * and its result is passed to {@link #values(List<SpanMessageValue>)}.
         * 
         * @param values
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.SpanMessageValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #values(java.util.Collection<SpanMessageValue>)
         */
        Builder values(Consumer<SpanMessageValue.Builder>... values);
    }

    static final class BuilderImpl implements Builder {
        private String messageId;

        private String participant;

        private Instant timestamp;

        private List<SpanMessageValue> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SpanMessage model) {
            messageId(model.messageId);
            participant(model.participant);
            timestamp(model.timestamp);
            values(model.values);
        }

        public final String getMessageId() {
            return messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final String getParticipant() {
            return participant;
        }

        public final void setParticipant(String participant) {
            this.participant = participant;
        }

        @Override
        public final Builder participant(String participant) {
            this.participant = participant;
            return this;
        }

        @Override
        public final Builder participant(Participant participant) {
            this.participant(participant == null ? null : participant.toString());
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final List<SpanMessageValue.Builder> getValues() {
            List<SpanMessageValue.Builder> result = SpanMessageValueListCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<SpanMessageValue.BuilderImpl> values) {
            this.values = SpanMessageValueListCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<SpanMessageValue> values) {
            this.values = SpanMessageValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(SpanMessageValue... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<SpanMessageValue.Builder>... values) {
            values(Stream.of(values).map(c -> SpanMessageValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SpanMessage build() {
            return new SpanMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
