/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A span represents a unit of work during AI agent execution, capturing timing, status, and contextual attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Span implements SdkPojo, Serializable, ToCopyableBuilder<Span.Builder, Span> {
    private static final SdkField<String> SPAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("spanId")
            .getter(getter(Span::spanId)).setter(setter(Builder::spanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spanId").build()).build();

    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantId").getter(getter(Span::assistantId)).setter(setter(Builder::assistantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantId").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(Span::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<String> PARENT_SPAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentSpanId").getter(getter(Span::parentSpanId)).setter(setter(Builder::parentSpanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentSpanId").build()).build();

    private static final SdkField<String> SPAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("spanName").getter(getter(Span::spanName)).setter(setter(Builder::spanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spanName").build()).build();

    private static final SdkField<String> SPAN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("spanType").getter(getter(Span::spanTypeAsString)).setter(setter(Builder::spanType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spanType").build()).build();

    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTimestamp").getter(getter(Span::startTimestamp)).setter(setter(Builder::startTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimestamp").build()).build();

    private static final SdkField<Instant> END_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTimestamp").getter(getter(Span::endTimestamp)).setter(setter(Builder::endTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTimestamp").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Span::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestId").getter(getter(Span::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()).build();

    private static final SdkField<SpanAttributes> ATTRIBUTES_FIELD = SdkField.<SpanAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("attributes").getter(getter(Span::attributes)).setter(setter(Builder::attributes))
            .constructor(SpanAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPAN_ID_FIELD,
            ASSISTANT_ID_FIELD, SESSION_ID_FIELD, PARENT_SPAN_ID_FIELD, SPAN_NAME_FIELD, SPAN_TYPE_FIELD, START_TIMESTAMP_FIELD,
            END_TIMESTAMP_FIELD, STATUS_FIELD, REQUEST_ID_FIELD, ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String spanId;

    private final String assistantId;

    private final String sessionId;

    private final String parentSpanId;

    private final String spanName;

    private final String spanType;

    private final Instant startTimestamp;

    private final Instant endTimestamp;

    private final String status;

    private final String requestIdValue;

    private final SpanAttributes attributes;

    private Span(BuilderImpl builder) {
        this.spanId = builder.spanId;
        this.assistantId = builder.assistantId;
        this.sessionId = builder.sessionId;
        this.parentSpanId = builder.parentSpanId;
        this.spanName = builder.spanName;
        this.spanType = builder.spanType;
        this.startTimestamp = builder.startTimestamp;
        this.endTimestamp = builder.endTimestamp;
        this.status = builder.status;
        this.requestIdValue = builder.requestIdValue;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * Unique span identifier
     * </p>
     * 
     * @return Unique span identifier
     */
    public final String spanId() {
        return spanId;
    }

    /**
     * <p>
     * UUID of the Connect AI Assistant resource
     * </p>
     * 
     * @return UUID of the Connect AI Assistant resource
     */
    public final String assistantId() {
        return assistantId;
    }

    /**
     * <p>
     * UUID of the Connect AI Session resource
     * </p>
     * 
     * @return UUID of the Connect AI Session resource
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * Parent span identifier for hierarchy. Null for root spans.
     * </p>
     * 
     * @return Parent span identifier for hierarchy. Null for root spans.
     */
    public final String parentSpanId() {
        return parentSpanId;
    }

    /**
     * <p>
     * Service-defined operation name
     * </p>
     * 
     * @return Service-defined operation name
     */
    public final String spanName() {
        return spanName;
    }

    /**
     * <p>
     * Operation relationship type
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #spanType} will
     * return {@link SpanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #spanTypeAsString}.
     * </p>
     * 
     * @return Operation relationship type
     * @see SpanType
     */
    public final SpanType spanType() {
        return SpanType.fromValue(spanType);
    }

    /**
     * <p>
     * Operation relationship type
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #spanType} will
     * return {@link SpanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #spanTypeAsString}.
     * </p>
     * 
     * @return Operation relationship type
     * @see SpanType
     */
    public final String spanTypeAsString() {
        return spanType;
    }

    /**
     * <p>
     * Operation start time in milliseconds since epoch
     * </p>
     * 
     * @return Operation start time in milliseconds since epoch
     */
    public final Instant startTimestamp() {
        return startTimestamp;
    }

    /**
     * <p>
     * Operation end time in milliseconds since epoch
     * </p>
     * 
     * @return Operation end time in milliseconds since epoch
     */
    public final Instant endTimestamp() {
        return endTimestamp;
    }

    /**
     * <p>
     * Span completion status
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SpanStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Span completion status
     * @see SpanStatus
     */
    public final SpanStatus status() {
        return SpanStatus.fromValue(status);
    }

    /**
     * <p>
     * Span completion status
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SpanStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Span completion status
     * @see SpanStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The service request ID that initiated the operation
     * </p>
     * 
     * @return The service request ID that initiated the operation
     */
    public final String requestId() {
        return requestIdValue;
    }

    /**
     * <p>
     * Span-specific contextual attributes
     * </p>
     * 
     * @return Span-specific contextual attributes
     */
    public final SpanAttributes attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(spanId());
        hashCode = 31 * hashCode + Objects.hashCode(assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(parentSpanId());
        hashCode = 31 * hashCode + Objects.hashCode(spanName());
        hashCode = 31 * hashCode + Objects.hashCode(spanTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(endTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Span)) {
            return false;
        }
        Span other = (Span) obj;
        return Objects.equals(spanId(), other.spanId()) && Objects.equals(assistantId(), other.assistantId())
                && Objects.equals(sessionId(), other.sessionId()) && Objects.equals(parentSpanId(), other.parentSpanId())
                && Objects.equals(spanName(), other.spanName()) && Objects.equals(spanTypeAsString(), other.spanTypeAsString())
                && Objects.equals(startTimestamp(), other.startTimestamp())
                && Objects.equals(endTimestamp(), other.endTimestamp())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Span").add("SpanId", spanId()).add("AssistantId", assistantId()).add("SessionId", sessionId())
                .add("ParentSpanId", parentSpanId()).add("SpanName", spanName()).add("SpanType", spanTypeAsString())
                .add("StartTimestamp", startTimestamp()).add("EndTimestamp", endTimestamp()).add("Status", statusAsString())
                .add("RequestId", requestId()).add("Attributes", attributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "spanId":
            return Optional.ofNullable(clazz.cast(spanId()));
        case "assistantId":
            return Optional.ofNullable(clazz.cast(assistantId()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "parentSpanId":
            return Optional.ofNullable(clazz.cast(parentSpanId()));
        case "spanName":
            return Optional.ofNullable(clazz.cast(spanName()));
        case "spanType":
            return Optional.ofNullable(clazz.cast(spanTypeAsString()));
        case "startTimestamp":
            return Optional.ofNullable(clazz.cast(startTimestamp()));
        case "endTimestamp":
            return Optional.ofNullable(clazz.cast(endTimestamp()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "requestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("spanId", SPAN_ID_FIELD);
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("parentSpanId", PARENT_SPAN_ID_FIELD);
        map.put("spanName", SPAN_NAME_FIELD);
        map.put("spanType", SPAN_TYPE_FIELD);
        map.put("startTimestamp", START_TIMESTAMP_FIELD);
        map.put("endTimestamp", END_TIMESTAMP_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("requestId", REQUEST_ID_FIELD);
        map.put("attributes", ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Span, T> g) {
        return obj -> g.apply((Span) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Span> {
        /**
         * <p>
         * Unique span identifier
         * </p>
         * 
         * @param spanId
         *        Unique span identifier
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spanId(String spanId);

        /**
         * <p>
         * UUID of the Connect AI Assistant resource
         * </p>
         * 
         * @param assistantId
         *        UUID of the Connect AI Assistant resource
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantId(String assistantId);

        /**
         * <p>
         * UUID of the Connect AI Session resource
         * </p>
         * 
         * @param sessionId
         *        UUID of the Connect AI Session resource
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * Parent span identifier for hierarchy. Null for root spans.
         * </p>
         * 
         * @param parentSpanId
         *        Parent span identifier for hierarchy. Null for root spans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentSpanId(String parentSpanId);

        /**
         * <p>
         * Service-defined operation name
         * </p>
         * 
         * @param spanName
         *        Service-defined operation name
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spanName(String spanName);

        /**
         * <p>
         * Operation relationship type
         * </p>
         * 
         * @param spanType
         *        Operation relationship type
         * @see SpanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpanType
         */
        Builder spanType(String spanType);

        /**
         * <p>
         * Operation relationship type
         * </p>
         * 
         * @param spanType
         *        Operation relationship type
         * @see SpanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpanType
         */
        Builder spanType(SpanType spanType);

        /**
         * <p>
         * Operation start time in milliseconds since epoch
         * </p>
         * 
         * @param startTimestamp
         *        Operation start time in milliseconds since epoch
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimestamp(Instant startTimestamp);

        /**
         * <p>
         * Operation end time in milliseconds since epoch
         * </p>
         * 
         * @param endTimestamp
         *        Operation end time in milliseconds since epoch
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimestamp(Instant endTimestamp);

        /**
         * <p>
         * Span completion status
         * </p>
         * 
         * @param status
         *        Span completion status
         * @see SpanStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpanStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Span completion status
         * </p>
         * 
         * @param status
         *        Span completion status
         * @see SpanStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpanStatus
         */
        Builder status(SpanStatus status);

        /**
         * <p>
         * The service request ID that initiated the operation
         * </p>
         * 
         * @param requestIdValue
         *        The service request ID that initiated the operation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestIdValue);

        /**
         * <p>
         * Span-specific contextual attributes
         * </p>
         * 
         * @param attributes
         *        Span-specific contextual attributes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(SpanAttributes attributes);

        /**
         * <p>
         * Span-specific contextual attributes
         * </p>
         * This is a convenience method that creates an instance of the {@link SpanAttributes.Builder} avoiding the need
         * to create one manually via {@link SpanAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpanAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #attributes(SpanAttributes)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link SpanAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(SpanAttributes)
         */
        default Builder attributes(Consumer<SpanAttributes.Builder> attributes) {
            return attributes(SpanAttributes.builder().applyMutation(attributes).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String spanId;

        private String assistantId;

        private String sessionId;

        private String parentSpanId;

        private String spanName;

        private String spanType;

        private Instant startTimestamp;

        private Instant endTimestamp;

        private String status;

        private String requestIdValue;

        private SpanAttributes attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(Span model) {
            spanId(model.spanId);
            assistantId(model.assistantId);
            sessionId(model.sessionId);
            parentSpanId(model.parentSpanId);
            spanName(model.spanName);
            spanType(model.spanType);
            startTimestamp(model.startTimestamp);
            endTimestamp(model.endTimestamp);
            status(model.status);
            requestId(model.requestIdValue);
            attributes(model.attributes);
        }

        public final String getSpanId() {
            return spanId;
        }

        public final void setSpanId(String spanId) {
            this.spanId = spanId;
        }

        @Override
        public final Builder spanId(String spanId) {
            this.spanId = spanId;
            return this;
        }

        public final String getAssistantId() {
            return assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getParentSpanId() {
            return parentSpanId;
        }

        public final void setParentSpanId(String parentSpanId) {
            this.parentSpanId = parentSpanId;
        }

        @Override
        public final Builder parentSpanId(String parentSpanId) {
            this.parentSpanId = parentSpanId;
            return this;
        }

        public final String getSpanName() {
            return spanName;
        }

        public final void setSpanName(String spanName) {
            this.spanName = spanName;
        }

        @Override
        public final Builder spanName(String spanName) {
            this.spanName = spanName;
            return this;
        }

        public final String getSpanType() {
            return spanType;
        }

        public final void setSpanType(String spanType) {
            this.spanType = spanType;
        }

        @Override
        public final Builder spanType(String spanType) {
            this.spanType = spanType;
            return this;
        }

        @Override
        public final Builder spanType(SpanType spanType) {
            this.spanType(spanType == null ? null : spanType.toString());
            return this;
        }

        public final Instant getStartTimestamp() {
            return startTimestamp;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final Instant getEndTimestamp() {
            return endTimestamp;
        }

        public final void setEndTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
        }

        @Override
        public final Builder endTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SpanStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getRequestId() {
            return requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final SpanAttributes.Builder getAttributes() {
            return attributes != null ? attributes.toBuilder() : null;
        }

        public final void setAttributes(SpanAttributes.BuilderImpl attributes) {
            this.attributes = attributes != null ? attributes.build() : null;
        }

        @Override
        public final Builder attributes(SpanAttributes attributes) {
            this.attributes = attributes;
            return this;
        }

        @Override
        public Span build() {
            return new Span(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
