/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetrieveRequest extends QConnectRequest implements ToCopyableBuilder<RetrieveRequest.Builder, RetrieveRequest> {
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantId").getter(getter(RetrieveRequest::assistantId)).setter(setter(Builder::assistantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()).build();

    private static final SdkField<RetrievalConfiguration> RETRIEVAL_CONFIGURATION_FIELD = SdkField
            .<RetrievalConfiguration> builder(MarshallingType.SDK_POJO).memberName("retrievalConfiguration")
            .getter(getter(RetrieveRequest::retrievalConfiguration)).setter(setter(Builder::retrievalConfiguration))
            .constructor(RetrievalConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrievalConfiguration").build())
            .build();

    private static final SdkField<String> RETRIEVAL_QUERY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("retrievalQuery").getter(getter(RetrieveRequest::retrievalQuery)).setter(setter(Builder::retrievalQuery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrievalQuery").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_ID_FIELD,
            RETRIEVAL_CONFIGURATION_FIELD, RETRIEVAL_QUERY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String assistantId;

    private final RetrievalConfiguration retrievalConfiguration;

    private final String retrievalQuery;

    private RetrieveRequest(BuilderImpl builder) {
        super(builder);
        this.assistantId = builder.assistantId;
        this.retrievalConfiguration = builder.retrievalConfiguration;
        this.retrievalQuery = builder.retrievalQuery;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect assistant for content retrieval.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect assistant for content retrieval.
     */
    public final String assistantId() {
        return assistantId;
    }

    /**
     * <p>
     * The configuration for the content retrieval operation.
     * </p>
     * 
     * @return The configuration for the content retrieval operation.
     */
    public final RetrievalConfiguration retrievalConfiguration() {
        return retrievalConfiguration;
    }

    /**
     * <p>
     * The query for content retrieval.
     * </p>
     * 
     * @return The query for content retrieval.
     */
    public final String retrievalQuery() {
        return retrievalQuery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(retrievalConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(retrievalQuery());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieveRequest)) {
            return false;
        }
        RetrieveRequest other = (RetrieveRequest) obj;
        return Objects.equals(assistantId(), other.assistantId())
                && Objects.equals(retrievalConfiguration(), other.retrievalConfiguration())
                && Objects.equals(retrievalQuery(), other.retrievalQuery());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetrieveRequest").add("AssistantId", assistantId())
                .add("RetrievalConfiguration", retrievalConfiguration())
                .add("RetrievalQuery", retrievalQuery() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assistantId":
            return Optional.ofNullable(clazz.cast(assistantId()));
        case "retrievalConfiguration":
            return Optional.ofNullable(clazz.cast(retrievalConfiguration()));
        case "retrievalQuery":
            return Optional.ofNullable(clazz.cast(retrievalQuery()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("retrievalConfiguration", RETRIEVAL_CONFIGURATION_FIELD);
        map.put("retrievalQuery", RETRIEVAL_QUERY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetrieveRequest, T> g) {
        return obj -> g.apply((RetrieveRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, RetrieveRequest> {
        /**
         * <p>
         * The identifier of the Amazon Q in Connect assistant for content retrieval.
         * </p>
         * 
         * @param assistantId
         *        The identifier of the Amazon Q in Connect assistant for content retrieval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantId(String assistantId);

        /**
         * <p>
         * The configuration for the content retrieval operation.
         * </p>
         * 
         * @param retrievalConfiguration
         *        The configuration for the content retrieval operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrievalConfiguration(RetrievalConfiguration retrievalConfiguration);

        /**
         * <p>
         * The configuration for the content retrieval operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetrievalConfiguration.Builder} avoiding
         * the need to create one manually via {@link RetrievalConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetrievalConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #retrievalConfiguration(RetrievalConfiguration)}.
         * 
         * @param retrievalConfiguration
         *        a consumer that will call methods on {@link RetrievalConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retrievalConfiguration(RetrievalConfiguration)
         */
        default Builder retrievalConfiguration(Consumer<RetrievalConfiguration.Builder> retrievalConfiguration) {
            return retrievalConfiguration(RetrievalConfiguration.builder().applyMutation(retrievalConfiguration).build());
        }

        /**
         * <p>
         * The query for content retrieval.
         * </p>
         * 
         * @param retrievalQuery
         *        The query for content retrieval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrievalQuery(String retrievalQuery);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QConnectRequest.BuilderImpl implements Builder {
        private String assistantId;

        private RetrievalConfiguration retrievalConfiguration;

        private String retrievalQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieveRequest model) {
            super(model);
            assistantId(model.assistantId);
            retrievalConfiguration(model.retrievalConfiguration);
            retrievalQuery(model.retrievalQuery);
        }

        public final String getAssistantId() {
            return assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final RetrievalConfiguration.Builder getRetrievalConfiguration() {
            return retrievalConfiguration != null ? retrievalConfiguration.toBuilder() : null;
        }

        public final void setRetrievalConfiguration(RetrievalConfiguration.BuilderImpl retrievalConfiguration) {
            this.retrievalConfiguration = retrievalConfiguration != null ? retrievalConfiguration.build() : null;
        }

        @Override
        public final Builder retrievalConfiguration(RetrievalConfiguration retrievalConfiguration) {
            this.retrievalConfiguration = retrievalConfiguration;
            return this;
        }

        public final String getRetrievalQuery() {
            return retrievalQuery;
        }

        public final void setRetrievalQuery(String retrievalQuery) {
            this.retrievalQuery = retrievalQuery;
        }

        @Override
        public final Builder retrievalQuery(String retrievalQuery) {
            this.retrievalQuery = retrievalQuery;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RetrieveRequest build() {
            return new RetrieveRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
