/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemoveAssistantAiAgentRequest extends QConnectRequest implements
        ToCopyableBuilder<RemoveAssistantAiAgentRequest.Builder, RemoveAssistantAiAgentRequest> {
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantId").getter(getter(RemoveAssistantAiAgentRequest::assistantId))
            .setter(setter(Builder::assistantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()).build();

    private static final SdkField<String> AI_AGENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aiAgentType").getter(getter(RemoveAssistantAiAgentRequest::aiAgentTypeAsString))
            .setter(setter(Builder::aiAgentType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("aiAgentType").build()).build();

    private static final SdkField<String> ORCHESTRATOR_USE_CASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("orchestratorUseCase").getter(getter(RemoveAssistantAiAgentRequest::orchestratorUseCase))
            .setter(setter(Builder::orchestratorUseCase))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("orchestratorUseCase").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_ID_FIELD,
            AI_AGENT_TYPE_FIELD, ORCHESTRATOR_USE_CASE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String assistantId;

    private final String aiAgentType;

    private final String orchestratorUseCase;

    private RemoveAssistantAiAgentRequest(BuilderImpl builder) {
        super(builder);
        this.assistantId = builder.assistantId;
        this.aiAgentType = builder.aiAgentType;
        this.orchestratorUseCase = builder.orchestratorUseCase;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
     * ARN.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain
     *         the ARN.
     */
    public final String assistantId() {
        return assistantId;
    }

    /**
     * <p>
     * The type of the AI Agent being removed for use by default from the Amazon Q in Connect Assistant.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aiAgentType} will
     * return {@link AIAgentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aiAgentTypeAsString}.
     * </p>
     * 
     * @return The type of the AI Agent being removed for use by default from the Amazon Q in Connect Assistant.
     * @see AIAgentType
     */
    public final AIAgentType aiAgentType() {
        return AIAgentType.fromValue(aiAgentType);
    }

    /**
     * <p>
     * The type of the AI Agent being removed for use by default from the Amazon Q in Connect Assistant.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aiAgentType} will
     * return {@link AIAgentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aiAgentTypeAsString}.
     * </p>
     * 
     * @return The type of the AI Agent being removed for use by default from the Amazon Q in Connect Assistant.
     * @see AIAgentType
     */
    public final String aiAgentTypeAsString() {
        return aiAgentType;
    }

    /**
     * <p>
     * The orchestrator use case for the AI Agent being removed.
     * </p>
     * 
     * @return The orchestrator use case for the AI Agent being removed.
     */
    public final String orchestratorUseCase() {
        return orchestratorUseCase;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(aiAgentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(orchestratorUseCase());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveAssistantAiAgentRequest)) {
            return false;
        }
        RemoveAssistantAiAgentRequest other = (RemoveAssistantAiAgentRequest) obj;
        return Objects.equals(assistantId(), other.assistantId())
                && Objects.equals(aiAgentTypeAsString(), other.aiAgentTypeAsString())
                && Objects.equals(orchestratorUseCase(), other.orchestratorUseCase());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RemoveAssistantAiAgentRequest").add("AssistantId", assistantId())
                .add("AiAgentType", aiAgentTypeAsString()).add("OrchestratorUseCase", orchestratorUseCase()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assistantId":
            return Optional.ofNullable(clazz.cast(assistantId()));
        case "aiAgentType":
            return Optional.ofNullable(clazz.cast(aiAgentTypeAsString()));
        case "orchestratorUseCase":
            return Optional.ofNullable(clazz.cast(orchestratorUseCase()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("aiAgentType", AI_AGENT_TYPE_FIELD);
        map.put("orchestratorUseCase", ORCHESTRATOR_USE_CASE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RemoveAssistantAiAgentRequest, T> g) {
        return obj -> g.apply((RemoveAssistantAiAgentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, RemoveAssistantAiAgentRequest> {
        /**
         * <p>
         * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
         * ARN.
         * </p>
         * 
         * @param assistantId
         *        The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot
         *        contain the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantId(String assistantId);

        /**
         * <p>
         * The type of the AI Agent being removed for use by default from the Amazon Q in Connect Assistant.
         * </p>
         * 
         * @param aiAgentType
         *        The type of the AI Agent being removed for use by default from the Amazon Q in Connect Assistant.
         * @see AIAgentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIAgentType
         */
        Builder aiAgentType(String aiAgentType);

        /**
         * <p>
         * The type of the AI Agent being removed for use by default from the Amazon Q in Connect Assistant.
         * </p>
         * 
         * @param aiAgentType
         *        The type of the AI Agent being removed for use by default from the Amazon Q in Connect Assistant.
         * @see AIAgentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIAgentType
         */
        Builder aiAgentType(AIAgentType aiAgentType);

        /**
         * <p>
         * The orchestrator use case for the AI Agent being removed.
         * </p>
         * 
         * @param orchestratorUseCase
         *        The orchestrator use case for the AI Agent being removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orchestratorUseCase(String orchestratorUseCase);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QConnectRequest.BuilderImpl implements Builder {
        private String assistantId;

        private String aiAgentType;

        private String orchestratorUseCase;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveAssistantAiAgentRequest model) {
            super(model);
            assistantId(model.assistantId);
            aiAgentType(model.aiAgentType);
            orchestratorUseCase(model.orchestratorUseCase);
        }

        public final String getAssistantId() {
            return assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getAiAgentType() {
            return aiAgentType;
        }

        public final void setAiAgentType(String aiAgentType) {
            this.aiAgentType = aiAgentType;
        }

        @Override
        public final Builder aiAgentType(String aiAgentType) {
            this.aiAgentType = aiAgentType;
            return this;
        }

        @Override
        public final Builder aiAgentType(AIAgentType aiAgentType) {
            this.aiAgentType(aiAgentType == null ? null : aiAgentType.toString());
            return this;
        }

        public final String getOrchestratorUseCase() {
            return orchestratorUseCase;
        }

        public final void setOrchestratorUseCase(String orchestratorUseCase) {
            this.orchestratorUseCase = orchestratorUseCase;
        }

        @Override
        public final Builder orchestratorUseCase(String orchestratorUseCase) {
            this.orchestratorUseCase = orchestratorUseCase;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveAssistantAiAgentRequest build() {
            return new RemoveAssistantAiAgentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
