/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The content of the message template that applies to the push channel subtype.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PushMessageTemplateContent implements SdkPojo, Serializable,
        ToCopyableBuilder<PushMessageTemplateContent.Builder, PushMessageTemplateContent> {
    private static final SdkField<PushADMMessageTemplateContent> ADM_FIELD = SdkField
            .<PushADMMessageTemplateContent> builder(MarshallingType.SDK_POJO).memberName("adm")
            .getter(getter(PushMessageTemplateContent::adm)).setter(setter(Builder::adm))
            .constructor(PushADMMessageTemplateContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adm").build()).build();

    private static final SdkField<PushAPNSMessageTemplateContent> APNS_FIELD = SdkField
            .<PushAPNSMessageTemplateContent> builder(MarshallingType.SDK_POJO).memberName("apns")
            .getter(getter(PushMessageTemplateContent::apns)).setter(setter(Builder::apns))
            .constructor(PushAPNSMessageTemplateContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apns").build()).build();

    private static final SdkField<PushFCMMessageTemplateContent> FCM_FIELD = SdkField
            .<PushFCMMessageTemplateContent> builder(MarshallingType.SDK_POJO).memberName("fcm")
            .getter(getter(PushMessageTemplateContent::fcm)).setter(setter(Builder::fcm))
            .constructor(PushFCMMessageTemplateContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fcm").build()).build();

    private static final SdkField<PushBaiduMessageTemplateContent> BAIDU_FIELD = SdkField
            .<PushBaiduMessageTemplateContent> builder(MarshallingType.SDK_POJO).memberName("baidu")
            .getter(getter(PushMessageTemplateContent::baidu)).setter(setter(Builder::baidu))
            .constructor(PushBaiduMessageTemplateContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baidu").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADM_FIELD, APNS_FIELD,
            FCM_FIELD, BAIDU_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final PushADMMessageTemplateContent adm;

    private final PushAPNSMessageTemplateContent apns;

    private final PushFCMMessageTemplateContent fcm;

    private final PushBaiduMessageTemplateContent baidu;

    private PushMessageTemplateContent(BuilderImpl builder) {
        this.adm = builder.adm;
        this.apns = builder.apns;
        this.fcm = builder.fcm;
        this.baidu = builder.baidu;
    }

    /**
     * <p>
     * The content of the message template that applies to ADM (Amazon Device Messaging) notification service.
     * </p>
     * 
     * @return The content of the message template that applies to ADM (Amazon Device Messaging) notification service.
     */
    public final PushADMMessageTemplateContent adm() {
        return adm;
    }

    /**
     * <p>
     * The content of the message template that applies to APNS(Apple Push Notification service) notification service.
     * </p>
     * 
     * @return The content of the message template that applies to APNS(Apple Push Notification service) notification
     *         service.
     */
    public final PushAPNSMessageTemplateContent apns() {
        return apns;
    }

    /**
     * <p>
     * The content of the message template that applies to FCM (Firebase Cloud Messaging) notification service.
     * </p>
     * 
     * @return The content of the message template that applies to FCM (Firebase Cloud Messaging) notification service.
     */
    public final PushFCMMessageTemplateContent fcm() {
        return fcm;
    }

    /**
     * <p>
     * The content of the message template that applies to Baidu notification service.
     * </p>
     * 
     * @return The content of the message template that applies to Baidu notification service.
     */
    public final PushBaiduMessageTemplateContent baidu() {
        return baidu;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adm());
        hashCode = 31 * hashCode + Objects.hashCode(apns());
        hashCode = 31 * hashCode + Objects.hashCode(fcm());
        hashCode = 31 * hashCode + Objects.hashCode(baidu());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PushMessageTemplateContent)) {
            return false;
        }
        PushMessageTemplateContent other = (PushMessageTemplateContent) obj;
        return Objects.equals(adm(), other.adm()) && Objects.equals(apns(), other.apns()) && Objects.equals(fcm(), other.fcm())
                && Objects.equals(baidu(), other.baidu());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PushMessageTemplateContent").add("Adm", adm()).add("Apns", apns()).add("Fcm", fcm())
                .add("Baidu", baidu()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "adm":
            return Optional.ofNullable(clazz.cast(adm()));
        case "apns":
            return Optional.ofNullable(clazz.cast(apns()));
        case "fcm":
            return Optional.ofNullable(clazz.cast(fcm()));
        case "baidu":
            return Optional.ofNullable(clazz.cast(baidu()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("adm", ADM_FIELD);
        map.put("apns", APNS_FIELD);
        map.put("fcm", FCM_FIELD);
        map.put("baidu", BAIDU_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PushMessageTemplateContent, T> g) {
        return obj -> g.apply((PushMessageTemplateContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PushMessageTemplateContent> {
        /**
         * <p>
         * The content of the message template that applies to ADM (Amazon Device Messaging) notification service.
         * </p>
         * 
         * @param adm
         *        The content of the message template that applies to ADM (Amazon Device Messaging) notification
         *        service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adm(PushADMMessageTemplateContent adm);

        /**
         * <p>
         * The content of the message template that applies to ADM (Amazon Device Messaging) notification service.
         * </p>
         * This is a convenience method that creates an instance of the {@link PushADMMessageTemplateContent.Builder}
         * avoiding the need to create one manually via {@link PushADMMessageTemplateContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PushADMMessageTemplateContent.Builder#build()} is called
         * immediately and its result is passed to {@link #adm(PushADMMessageTemplateContent)}.
         * 
         * @param adm
         *        a consumer that will call methods on {@link PushADMMessageTemplateContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #adm(PushADMMessageTemplateContent)
         */
        default Builder adm(Consumer<PushADMMessageTemplateContent.Builder> adm) {
            return adm(PushADMMessageTemplateContent.builder().applyMutation(adm).build());
        }

        /**
         * <p>
         * The content of the message template that applies to APNS(Apple Push Notification service) notification
         * service.
         * </p>
         * 
         * @param apns
         *        The content of the message template that applies to APNS(Apple Push Notification service) notification
         *        service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apns(PushAPNSMessageTemplateContent apns);

        /**
         * <p>
         * The content of the message template that applies to APNS(Apple Push Notification service) notification
         * service.
         * </p>
         * This is a convenience method that creates an instance of the {@link PushAPNSMessageTemplateContent.Builder}
         * avoiding the need to create one manually via {@link PushAPNSMessageTemplateContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PushAPNSMessageTemplateContent.Builder#build()} is called
         * immediately and its result is passed to {@link #apns(PushAPNSMessageTemplateContent)}.
         * 
         * @param apns
         *        a consumer that will call methods on {@link PushAPNSMessageTemplateContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apns(PushAPNSMessageTemplateContent)
         */
        default Builder apns(Consumer<PushAPNSMessageTemplateContent.Builder> apns) {
            return apns(PushAPNSMessageTemplateContent.builder().applyMutation(apns).build());
        }

        /**
         * <p>
         * The content of the message template that applies to FCM (Firebase Cloud Messaging) notification service.
         * </p>
         * 
         * @param fcm
         *        The content of the message template that applies to FCM (Firebase Cloud Messaging) notification
         *        service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fcm(PushFCMMessageTemplateContent fcm);

        /**
         * <p>
         * The content of the message template that applies to FCM (Firebase Cloud Messaging) notification service.
         * </p>
         * This is a convenience method that creates an instance of the {@link PushFCMMessageTemplateContent.Builder}
         * avoiding the need to create one manually via {@link PushFCMMessageTemplateContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PushFCMMessageTemplateContent.Builder#build()} is called
         * immediately and its result is passed to {@link #fcm(PushFCMMessageTemplateContent)}.
         * 
         * @param fcm
         *        a consumer that will call methods on {@link PushFCMMessageTemplateContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fcm(PushFCMMessageTemplateContent)
         */
        default Builder fcm(Consumer<PushFCMMessageTemplateContent.Builder> fcm) {
            return fcm(PushFCMMessageTemplateContent.builder().applyMutation(fcm).build());
        }

        /**
         * <p>
         * The content of the message template that applies to Baidu notification service.
         * </p>
         * 
         * @param baidu
         *        The content of the message template that applies to Baidu notification service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baidu(PushBaiduMessageTemplateContent baidu);

        /**
         * <p>
         * The content of the message template that applies to Baidu notification service.
         * </p>
         * This is a convenience method that creates an instance of the {@link PushBaiduMessageTemplateContent.Builder}
         * avoiding the need to create one manually via {@link PushBaiduMessageTemplateContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PushBaiduMessageTemplateContent.Builder#build()} is called
         * immediately and its result is passed to {@link #baidu(PushBaiduMessageTemplateContent)}.
         * 
         * @param baidu
         *        a consumer that will call methods on {@link PushBaiduMessageTemplateContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #baidu(PushBaiduMessageTemplateContent)
         */
        default Builder baidu(Consumer<PushBaiduMessageTemplateContent.Builder> baidu) {
            return baidu(PushBaiduMessageTemplateContent.builder().applyMutation(baidu).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PushADMMessageTemplateContent adm;

        private PushAPNSMessageTemplateContent apns;

        private PushFCMMessageTemplateContent fcm;

        private PushBaiduMessageTemplateContent baidu;

        private BuilderImpl() {
        }

        private BuilderImpl(PushMessageTemplateContent model) {
            adm(model.adm);
            apns(model.apns);
            fcm(model.fcm);
            baidu(model.baidu);
        }

        public final PushADMMessageTemplateContent.Builder getAdm() {
            return adm != null ? adm.toBuilder() : null;
        }

        public final void setAdm(PushADMMessageTemplateContent.BuilderImpl adm) {
            this.adm = adm != null ? adm.build() : null;
        }

        @Override
        public final Builder adm(PushADMMessageTemplateContent adm) {
            this.adm = adm;
            return this;
        }

        public final PushAPNSMessageTemplateContent.Builder getApns() {
            return apns != null ? apns.toBuilder() : null;
        }

        public final void setApns(PushAPNSMessageTemplateContent.BuilderImpl apns) {
            this.apns = apns != null ? apns.build() : null;
        }

        @Override
        public final Builder apns(PushAPNSMessageTemplateContent apns) {
            this.apns = apns;
            return this;
        }

        public final PushFCMMessageTemplateContent.Builder getFcm() {
            return fcm != null ? fcm.toBuilder() : null;
        }

        public final void setFcm(PushFCMMessageTemplateContent.BuilderImpl fcm) {
            this.fcm = fcm != null ? fcm.build() : null;
        }

        @Override
        public final Builder fcm(PushFCMMessageTemplateContent fcm) {
            this.fcm = fcm;
            return this;
        }

        public final PushBaiduMessageTemplateContent.Builder getBaidu() {
            return baidu != null ? baidu.toBuilder() : null;
        }

        public final void setBaidu(PushBaiduMessageTemplateContent.BuilderImpl baidu) {
            this.baidu = baidu != null ? baidu.build() : null;
        }

        @Override
        public final Builder baidu(PushBaiduMessageTemplateContent baidu) {
            this.baidu = baidu;
            return this;
        }

        @Override
        public PushMessageTemplateContent build() {
            return new PushMessageTemplateContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
