/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The content of the push message template that applies to APNS (Apple Push Notification service) notification service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PushAPNSMessageTemplateContent implements SdkPojo, Serializable,
        ToCopyableBuilder<PushAPNSMessageTemplateContent.Builder, PushAPNSMessageTemplateContent> {
    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(PushAPNSMessageTemplateContent::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<MessageTemplateBodyContentProvider> BODY_FIELD = SdkField
            .<MessageTemplateBodyContentProvider> builder(MarshallingType.SDK_POJO).memberName("body")
            .getter(getter(PushAPNSMessageTemplateContent::body)).setter(setter(Builder::body))
            .constructor(MessageTemplateBodyContentProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(PushAPNSMessageTemplateContent::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<String> SOUND_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sound")
            .getter(getter(PushAPNSMessageTemplateContent::sound)).setter(setter(Builder::sound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sound").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("url")
            .getter(getter(PushAPNSMessageTemplateContent::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final SdkField<String> MEDIA_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mediaUrl").getter(getter(PushAPNSMessageTemplateContent::mediaUrl)).setter(setter(Builder::mediaUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaUrl").build()).build();

    private static final SdkField<MessageTemplateBodyContentProvider> RAW_CONTENT_FIELD = SdkField
            .<MessageTemplateBodyContentProvider> builder(MarshallingType.SDK_POJO).memberName("rawContent")
            .getter(getter(PushAPNSMessageTemplateContent::rawContent)).setter(setter(Builder::rawContent))
            .constructor(MessageTemplateBodyContentProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rawContent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, BODY_FIELD,
            ACTION_FIELD, SOUND_FIELD, URL_FIELD, MEDIA_URL_FIELD, RAW_CONTENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String title;

    private final MessageTemplateBodyContentProvider body;

    private final String action;

    private final String sound;

    private final String url;

    private final String mediaUrl;

    private final MessageTemplateBodyContentProvider rawContent;

    private PushAPNSMessageTemplateContent(BuilderImpl builder) {
        this.title = builder.title;
        this.body = builder.body;
        this.action = builder.action;
        this.sound = builder.sound;
        this.url = builder.url;
        this.mediaUrl = builder.mediaUrl;
        this.rawContent = builder.rawContent;
    }

    /**
     * <p>
     * The title to use in a push notification that's based on the message template. This title appears above the
     * notification message on a recipient's device.
     * </p>
     * 
     * @return The title to use in a push notification that's based on the message template. This title appears above
     *         the notification message on a recipient's device.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The message body to use in a push notification that is based on the message template.
     * </p>
     * 
     * @return The message body to use in a push notification that is based on the message template.
     */
    public final MessageTemplateBodyContentProvider body() {
        return body;
    }

    /**
     * <p>
     * The action to occur if a recipient taps a push notification that is based on the message template. Valid values
     * are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>OPEN_APP</code> - Your app opens or it becomes the foreground app if it was sent to the background. This is
     * the default action.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DEEP_LINK</code> - Your app opens and displays a designated user interface in the app. This action uses the
     * deep-linking features of the iOS platform.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>URL</code> - The default mobile browser on the recipient's device opens and loads the web page at a URL
     * that you specify.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link PushMessageAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action to occur if a recipient taps a push notification that is based on the message template. Valid
     *         values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>OPEN_APP</code> - Your app opens or it becomes the foreground app if it was sent to the background.
     *         This is the default action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DEEP_LINK</code> - Your app opens and displays a designated user interface in the app. This action
     *         uses the deep-linking features of the iOS platform.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>URL</code> - The default mobile browser on the recipient's device opens and loads the web page at a
     *         URL that you specify.
     *         </p>
     *         </li>
     * @see PushMessageAction
     */
    public final PushMessageAction action() {
        return PushMessageAction.fromValue(action);
    }

    /**
     * <p>
     * The action to occur if a recipient taps a push notification that is based on the message template. Valid values
     * are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>OPEN_APP</code> - Your app opens or it becomes the foreground app if it was sent to the background. This is
     * the default action.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DEEP_LINK</code> - Your app opens and displays a designated user interface in the app. This action uses the
     * deep-linking features of the iOS platform.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>URL</code> - The default mobile browser on the recipient's device opens and loads the web page at a URL
     * that you specify.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link PushMessageAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action to occur if a recipient taps a push notification that is based on the message template. Valid
     *         values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>OPEN_APP</code> - Your app opens or it becomes the foreground app if it was sent to the background.
     *         This is the default action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DEEP_LINK</code> - Your app opens and displays a designated user interface in the app. This action
     *         uses the deep-linking features of the iOS platform.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>URL</code> - The default mobile browser on the recipient's device opens and loads the web page at a
     *         URL that you specify.
     *         </p>
     *         </li>
     * @see PushMessageAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The key for the sound to play when the recipient receives a push notification that's based on the message
     * template. The value for this key is the name of a sound file in your app's main bundle or the
     * <code>Library/Sounds</code> folder in your app's data container. If the sound file can't be found or you specify
     * <code>default</code> for the value, the system plays the default alert sound.
     * </p>
     * 
     * @return The key for the sound to play when the recipient receives a push notification that's based on the message
     *         template. The value for this key is the name of a sound file in your app's main bundle or the
     *         <code>Library/Sounds</code> folder in your app's data container. If the sound file can't be found or you
     *         specify <code>default</code> for the value, the system plays the default alert sound.
     */
    public final String sound() {
        return sound;
    }

    /**
     * <p>
     * The URL to open in a recipient's default mobile browser, if a recipient taps a push notification that's based on
     * the message template and the value of the <code>action</code> property is <code>URL</code>.
     * </p>
     * 
     * @return The URL to open in a recipient's default mobile browser, if a recipient taps a push notification that's
     *         based on the message template and the value of the <code>action</code> property is <code>URL</code>.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * The URL of an image or video to display in push notifications that are based on the message template.
     * </p>
     * 
     * @return The URL of an image or video to display in push notifications that are based on the message template.
     */
    public final String mediaUrl() {
        return mediaUrl;
    }

    /**
     * <p>
     * The raw, JSON-formatted string to use as the payload for a push notification that's based on the message
     * template. If specified, this value overrides all other content for the message template.
     * </p>
     * 
     * @return The raw, JSON-formatted string to use as the payload for a push notification that's based on the message
     *         template. If specified, this value overrides all other content for the message template.
     */
    public final MessageTemplateBodyContentProvider rawContent() {
        return rawContent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sound());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(mediaUrl());
        hashCode = 31 * hashCode + Objects.hashCode(rawContent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PushAPNSMessageTemplateContent)) {
            return false;
        }
        PushAPNSMessageTemplateContent other = (PushAPNSMessageTemplateContent) obj;
        return Objects.equals(title(), other.title()) && Objects.equals(body(), other.body())
                && Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(sound(), other.sound())
                && Objects.equals(url(), other.url()) && Objects.equals(mediaUrl(), other.mediaUrl())
                && Objects.equals(rawContent(), other.rawContent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PushAPNSMessageTemplateContent")
                .add("Title", title() == null ? null : "*** Sensitive Data Redacted ***").add("Body", body())
                .add("Action", actionAsString()).add("Sound", sound() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Url", url() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MediaUrl", mediaUrl() == null ? null : "*** Sensitive Data Redacted ***").add("RawContent", rawContent())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "body":
            return Optional.ofNullable(clazz.cast(body()));
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "sound":
            return Optional.ofNullable(clazz.cast(sound()));
        case "url":
            return Optional.ofNullable(clazz.cast(url()));
        case "mediaUrl":
            return Optional.ofNullable(clazz.cast(mediaUrl()));
        case "rawContent":
            return Optional.ofNullable(clazz.cast(rawContent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("title", TITLE_FIELD);
        map.put("body", BODY_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("sound", SOUND_FIELD);
        map.put("url", URL_FIELD);
        map.put("mediaUrl", MEDIA_URL_FIELD);
        map.put("rawContent", RAW_CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PushAPNSMessageTemplateContent, T> g) {
        return obj -> g.apply((PushAPNSMessageTemplateContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PushAPNSMessageTemplateContent> {
        /**
         * <p>
         * The title to use in a push notification that's based on the message template. This title appears above the
         * notification message on a recipient's device.
         * </p>
         * 
         * @param title
         *        The title to use in a push notification that's based on the message template. This title appears above
         *        the notification message on a recipient's device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The message body to use in a push notification that is based on the message template.
         * </p>
         * 
         * @param body
         *        The message body to use in a push notification that is based on the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(MessageTemplateBodyContentProvider body);

        /**
         * <p>
         * The message body to use in a push notification that is based on the message template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MessageTemplateBodyContentProvider.Builder} avoiding the need to create one manually via
         * {@link MessageTemplateBodyContentProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageTemplateBodyContentProvider.Builder#build()} is called
         * immediately and its result is passed to {@link #body(MessageTemplateBodyContentProvider)}.
         * 
         * @param body
         *        a consumer that will call methods on {@link MessageTemplateBodyContentProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #body(MessageTemplateBodyContentProvider)
         */
        default Builder body(Consumer<MessageTemplateBodyContentProvider.Builder> body) {
            return body(MessageTemplateBodyContentProvider.builder().applyMutation(body).build());
        }

        /**
         * <p>
         * The action to occur if a recipient taps a push notification that is based on the message template. Valid
         * values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>OPEN_APP</code> - Your app opens or it becomes the foreground app if it was sent to the background.
         * This is the default action.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DEEP_LINK</code> - Your app opens and displays a designated user interface in the app. This action uses
         * the deep-linking features of the iOS platform.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>URL</code> - The default mobile browser on the recipient's device opens and loads the web page at a URL
         * that you specify.
         * </p>
         * </li>
         * </ul>
         * 
         * @param action
         *        The action to occur if a recipient taps a push notification that is based on the message template.
         *        Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>OPEN_APP</code> - Your app opens or it becomes the foreground app if it was sent to the
         *        background. This is the default action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DEEP_LINK</code> - Your app opens and displays a designated user interface in the app. This
         *        action uses the deep-linking features of the iOS platform.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>URL</code> - The default mobile browser on the recipient's device opens and loads the web page
         *        at a URL that you specify.
         *        </p>
         *        </li>
         * @see PushMessageAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PushMessageAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action to occur if a recipient taps a push notification that is based on the message template. Valid
         * values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>OPEN_APP</code> - Your app opens or it becomes the foreground app if it was sent to the background.
         * This is the default action.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DEEP_LINK</code> - Your app opens and displays a designated user interface in the app. This action uses
         * the deep-linking features of the iOS platform.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>URL</code> - The default mobile browser on the recipient's device opens and loads the web page at a URL
         * that you specify.
         * </p>
         * </li>
         * </ul>
         * 
         * @param action
         *        The action to occur if a recipient taps a push notification that is based on the message template.
         *        Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>OPEN_APP</code> - Your app opens or it becomes the foreground app if it was sent to the
         *        background. This is the default action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DEEP_LINK</code> - Your app opens and displays a designated user interface in the app. This
         *        action uses the deep-linking features of the iOS platform.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>URL</code> - The default mobile browser on the recipient's device opens and loads the web page
         *        at a URL that you specify.
         *        </p>
         *        </li>
         * @see PushMessageAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PushMessageAction
         */
        Builder action(PushMessageAction action);

        /**
         * <p>
         * The key for the sound to play when the recipient receives a push notification that's based on the message
         * template. The value for this key is the name of a sound file in your app's main bundle or the
         * <code>Library/Sounds</code> folder in your app's data container. If the sound file can't be found or you
         * specify <code>default</code> for the value, the system plays the default alert sound.
         * </p>
         * 
         * @param sound
         *        The key for the sound to play when the recipient receives a push notification that's based on the
         *        message template. The value for this key is the name of a sound file in your app's main bundle or the
         *        <code>Library/Sounds</code> folder in your app's data container. If the sound file can't be found or
         *        you specify <code>default</code> for the value, the system plays the default alert sound.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sound(String sound);

        /**
         * <p>
         * The URL to open in a recipient's default mobile browser, if a recipient taps a push notification that's based
         * on the message template and the value of the <code>action</code> property is <code>URL</code>.
         * </p>
         * 
         * @param url
         *        The URL to open in a recipient's default mobile browser, if a recipient taps a push notification
         *        that's based on the message template and the value of the <code>action</code> property is
         *        <code>URL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The URL of an image or video to display in push notifications that are based on the message template.
         * </p>
         * 
         * @param mediaUrl
         *        The URL of an image or video to display in push notifications that are based on the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaUrl(String mediaUrl);

        /**
         * <p>
         * The raw, JSON-formatted string to use as the payload for a push notification that's based on the message
         * template. If specified, this value overrides all other content for the message template.
         * </p>
         * 
         * @param rawContent
         *        The raw, JSON-formatted string to use as the payload for a push notification that's based on the
         *        message template. If specified, this value overrides all other content for the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawContent(MessageTemplateBodyContentProvider rawContent);

        /**
         * <p>
         * The raw, JSON-formatted string to use as the payload for a push notification that's based on the message
         * template. If specified, this value overrides all other content for the message template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MessageTemplateBodyContentProvider.Builder} avoiding the need to create one manually via
         * {@link MessageTemplateBodyContentProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageTemplateBodyContentProvider.Builder#build()} is called
         * immediately and its result is passed to {@link #rawContent(MessageTemplateBodyContentProvider)}.
         * 
         * @param rawContent
         *        a consumer that will call methods on {@link MessageTemplateBodyContentProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rawContent(MessageTemplateBodyContentProvider)
         */
        default Builder rawContent(Consumer<MessageTemplateBodyContentProvider.Builder> rawContent) {
            return rawContent(MessageTemplateBodyContentProvider.builder().applyMutation(rawContent).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String title;

        private MessageTemplateBodyContentProvider body;

        private String action;

        private String sound;

        private String url;

        private String mediaUrl;

        private MessageTemplateBodyContentProvider rawContent;

        private BuilderImpl() {
        }

        private BuilderImpl(PushAPNSMessageTemplateContent model) {
            title(model.title);
            body(model.body);
            action(model.action);
            sound(model.sound);
            url(model.url);
            mediaUrl(model.mediaUrl);
            rawContent(model.rawContent);
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final MessageTemplateBodyContentProvider.Builder getBody() {
            return body != null ? body.toBuilder() : null;
        }

        public final void setBody(MessageTemplateBodyContentProvider.BuilderImpl body) {
            this.body = body != null ? body.build() : null;
        }

        @Override
        public final Builder body(MessageTemplateBodyContentProvider body) {
            this.body = body;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(PushMessageAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getSound() {
            return sound;
        }

        public final void setSound(String sound) {
            this.sound = sound;
        }

        @Override
        public final Builder sound(String sound) {
            this.sound = sound;
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getMediaUrl() {
            return mediaUrl;
        }

        public final void setMediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
        }

        @Override
        public final Builder mediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
            return this;
        }

        public final MessageTemplateBodyContentProvider.Builder getRawContent() {
            return rawContent != null ? rawContent.toBuilder() : null;
        }

        public final void setRawContent(MessageTemplateBodyContentProvider.BuilderImpl rawContent) {
            this.rawContent = rawContent != null ? rawContent.build() : null;
        }

        @Override
        public final Builder rawContent(MessageTemplateBodyContentProvider rawContent) {
            this.rawContent = rawContent;
            return this;
        }

        @Override
        public PushAPNSMessageTemplateContent build() {
            return new PushAPNSMessageTemplateContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
