/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An entry in the orchestrator configuration list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrchestratorConfigurationEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<OrchestratorConfigurationEntry.Builder, OrchestratorConfigurationEntry> {
    private static final SdkField<String> AI_AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aiAgentId").getter(getter(OrchestratorConfigurationEntry::aiAgentId)).setter(setter(Builder::aiAgentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentId").build()).build();

    private static final SdkField<String> ORCHESTRATOR_USE_CASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("orchestratorUseCase").getter(getter(OrchestratorConfigurationEntry::orchestratorUseCase))
            .setter(setter(Builder::orchestratorUseCase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orchestratorUseCase").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AI_AGENT_ID_FIELD,
            ORCHESTRATOR_USE_CASE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String aiAgentId;

    private final String orchestratorUseCase;

    private OrchestratorConfigurationEntry(BuilderImpl builder) {
        this.aiAgentId = builder.aiAgentId;
        this.orchestratorUseCase = builder.orchestratorUseCase;
    }

    /**
     * <p>
     * The identifier of the AI Agent in the orchestrator configuration.
     * </p>
     * 
     * @return The identifier of the AI Agent in the orchestrator configuration.
     */
    public final String aiAgentId() {
        return aiAgentId;
    }

    /**
     * <p>
     * The use case for the orchestrator configuration. (for example Connect.SelfService, Connect.AgentAssistance)
     * </p>
     * 
     * @return The use case for the orchestrator configuration. (for example Connect.SelfService,
     *         Connect.AgentAssistance)
     */
    public final String orchestratorUseCase() {
        return orchestratorUseCase;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aiAgentId());
        hashCode = 31 * hashCode + Objects.hashCode(orchestratorUseCase());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrchestratorConfigurationEntry)) {
            return false;
        }
        OrchestratorConfigurationEntry other = (OrchestratorConfigurationEntry) obj;
        return Objects.equals(aiAgentId(), other.aiAgentId())
                && Objects.equals(orchestratorUseCase(), other.orchestratorUseCase());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrchestratorConfigurationEntry").add("AiAgentId", aiAgentId())
                .add("OrchestratorUseCase", orchestratorUseCase()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "aiAgentId":
            return Optional.ofNullable(clazz.cast(aiAgentId()));
        case "orchestratorUseCase":
            return Optional.ofNullable(clazz.cast(orchestratorUseCase()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("aiAgentId", AI_AGENT_ID_FIELD);
        map.put("orchestratorUseCase", ORCHESTRATOR_USE_CASE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrchestratorConfigurationEntry, T> g) {
        return obj -> g.apply((OrchestratorConfigurationEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrchestratorConfigurationEntry> {
        /**
         * <p>
         * The identifier of the AI Agent in the orchestrator configuration.
         * </p>
         * 
         * @param aiAgentId
         *        The identifier of the AI Agent in the orchestrator configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiAgentId(String aiAgentId);

        /**
         * <p>
         * The use case for the orchestrator configuration. (for example Connect.SelfService, Connect.AgentAssistance)
         * </p>
         * 
         * @param orchestratorUseCase
         *        The use case for the orchestrator configuration. (for example Connect.SelfService,
         *        Connect.AgentAssistance)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orchestratorUseCase(String orchestratorUseCase);
    }

    static final class BuilderImpl implements Builder {
        private String aiAgentId;

        private String orchestratorUseCase;

        private BuilderImpl() {
        }

        private BuilderImpl(OrchestratorConfigurationEntry model) {
            aiAgentId(model.aiAgentId);
            orchestratorUseCase(model.orchestratorUseCase);
        }

        public final String getAiAgentId() {
            return aiAgentId;
        }

        public final void setAiAgentId(String aiAgentId) {
            this.aiAgentId = aiAgentId;
        }

        @Override
        public final Builder aiAgentId(String aiAgentId) {
            this.aiAgentId = aiAgentId;
            return this;
        }

        public final String getOrchestratorUseCase() {
            return orchestratorUseCase;
        }

        public final void setOrchestratorUseCase(String orchestratorUseCase) {
            this.orchestratorUseCase = orchestratorUseCase;
        }

        @Override
        public final Builder orchestratorUseCase(String orchestratorUseCase) {
            this.orchestratorUseCase = orchestratorUseCase;
            return this;
        }

        @Override
        public OrchestratorConfigurationEntry build() {
            return new OrchestratorConfigurationEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
