/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for AI Agents of type <code>NOTE_TAKING</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NoteTakingAIAgentConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<NoteTakingAIAgentConfiguration.Builder, NoteTakingAIAgentConfiguration> {
    private static final SdkField<String> NOTE_TAKING_AI_PROMPT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("noteTakingAIPromptId").getter(getter(NoteTakingAIAgentConfiguration::noteTakingAIPromptId))
            .setter(setter(Builder::noteTakingAIPromptId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noteTakingAIPromptId").build())
            .build();

    private static final SdkField<String> NOTE_TAKING_AI_GUARDRAIL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("noteTakingAIGuardrailId").getter(getter(NoteTakingAIAgentConfiguration::noteTakingAIGuardrailId))
            .setter(setter(Builder::noteTakingAIGuardrailId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noteTakingAIGuardrailId").build())
            .build();

    private static final SdkField<String> LOCALE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("locale")
            .getter(getter(NoteTakingAIAgentConfiguration::locale)).setter(setter(Builder::locale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locale").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NOTE_TAKING_AI_PROMPT_ID_FIELD, NOTE_TAKING_AI_GUARDRAIL_ID_FIELD, LOCALE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String noteTakingAIPromptId;

    private final String noteTakingAIGuardrailId;

    private final String locale;

    private NoteTakingAIAgentConfiguration(BuilderImpl builder) {
        this.noteTakingAIPromptId = builder.noteTakingAIPromptId;
        this.noteTakingAIGuardrailId = builder.noteTakingAIGuardrailId;
        this.locale = builder.locale;
    }

    /**
     * <p>
     * The AI Prompt identifier used by the Note Taking AI Agent.
     * </p>
     * 
     * @return The AI Prompt identifier used by the Note Taking AI Agent.
     */
    public final String noteTakingAIPromptId() {
        return noteTakingAIPromptId;
    }

    /**
     * <p>
     * The AI Guardrail identifier used by the Note Taking AI Agent.
     * </p>
     * 
     * @return The AI Guardrail identifier used by the Note Taking AI Agent.
     */
    public final String noteTakingAIGuardrailId() {
        return noteTakingAIGuardrailId;
    }

    /**
     * <p>
     * The locale setting for language-specific case summarization generation (for example, en_US, es_ES).
     * </p>
     * 
     * @return The locale setting for language-specific case summarization generation (for example, en_US, es_ES).
     */
    public final String locale() {
        return locale;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(noteTakingAIPromptId());
        hashCode = 31 * hashCode + Objects.hashCode(noteTakingAIGuardrailId());
        hashCode = 31 * hashCode + Objects.hashCode(locale());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NoteTakingAIAgentConfiguration)) {
            return false;
        }
        NoteTakingAIAgentConfiguration other = (NoteTakingAIAgentConfiguration) obj;
        return Objects.equals(noteTakingAIPromptId(), other.noteTakingAIPromptId())
                && Objects.equals(noteTakingAIGuardrailId(), other.noteTakingAIGuardrailId())
                && Objects.equals(locale(), other.locale());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NoteTakingAIAgentConfiguration").add("NoteTakingAIPromptId", noteTakingAIPromptId())
                .add("NoteTakingAIGuardrailId", noteTakingAIGuardrailId()).add("Locale", locale()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "noteTakingAIPromptId":
            return Optional.ofNullable(clazz.cast(noteTakingAIPromptId()));
        case "noteTakingAIGuardrailId":
            return Optional.ofNullable(clazz.cast(noteTakingAIGuardrailId()));
        case "locale":
            return Optional.ofNullable(clazz.cast(locale()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("noteTakingAIPromptId", NOTE_TAKING_AI_PROMPT_ID_FIELD);
        map.put("noteTakingAIGuardrailId", NOTE_TAKING_AI_GUARDRAIL_ID_FIELD);
        map.put("locale", LOCALE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NoteTakingAIAgentConfiguration, T> g) {
        return obj -> g.apply((NoteTakingAIAgentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NoteTakingAIAgentConfiguration> {
        /**
         * <p>
         * The AI Prompt identifier used by the Note Taking AI Agent.
         * </p>
         * 
         * @param noteTakingAIPromptId
         *        The AI Prompt identifier used by the Note Taking AI Agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noteTakingAIPromptId(String noteTakingAIPromptId);

        /**
         * <p>
         * The AI Guardrail identifier used by the Note Taking AI Agent.
         * </p>
         * 
         * @param noteTakingAIGuardrailId
         *        The AI Guardrail identifier used by the Note Taking AI Agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noteTakingAIGuardrailId(String noteTakingAIGuardrailId);

        /**
         * <p>
         * The locale setting for language-specific case summarization generation (for example, en_US, es_ES).
         * </p>
         * 
         * @param locale
         *        The locale setting for language-specific case summarization generation (for example, en_US, es_ES).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locale(String locale);
    }

    static final class BuilderImpl implements Builder {
        private String noteTakingAIPromptId;

        private String noteTakingAIGuardrailId;

        private String locale;

        private BuilderImpl() {
        }

        private BuilderImpl(NoteTakingAIAgentConfiguration model) {
            noteTakingAIPromptId(model.noteTakingAIPromptId);
            noteTakingAIGuardrailId(model.noteTakingAIGuardrailId);
            locale(model.locale);
        }

        public final String getNoteTakingAIPromptId() {
            return noteTakingAIPromptId;
        }

        public final void setNoteTakingAIPromptId(String noteTakingAIPromptId) {
            this.noteTakingAIPromptId = noteTakingAIPromptId;
        }

        @Override
        public final Builder noteTakingAIPromptId(String noteTakingAIPromptId) {
            this.noteTakingAIPromptId = noteTakingAIPromptId;
            return this;
        }

        public final String getNoteTakingAIGuardrailId() {
            return noteTakingAIGuardrailId;
        }

        public final void setNoteTakingAIGuardrailId(String noteTakingAIGuardrailId) {
            this.noteTakingAIGuardrailId = noteTakingAIGuardrailId;
        }

        @Override
        public final Builder noteTakingAIGuardrailId(String noteTakingAIGuardrailId) {
            this.noteTakingAIGuardrailId = noteTakingAIGuardrailId;
            return this;
        }

        public final String getLocale() {
            return locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public NoteTakingAIAgentConfiguration build() {
            return new NoteTakingAIAgentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
