/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the message template version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MessageTemplateVersionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<MessageTemplateVersionSummary.Builder, MessageTemplateVersionSummary> {
    private static final SdkField<String> MESSAGE_TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("messageTemplateArn").getter(getter(MessageTemplateVersionSummary::messageTemplateArn))
            .setter(setter(Builder::messageTemplateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageTemplateArn").build())
            .build();

    private static final SdkField<String> MESSAGE_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("messageTemplateId").getter(getter(MessageTemplateVersionSummary::messageTemplateId))
            .setter(setter(Builder::messageTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageTemplateId").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseArn").getter(getter(MessageTemplateVersionSummary::knowledgeBaseArn))
            .setter(setter(Builder::knowledgeBaseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseArn").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(MessageTemplateVersionSummary::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(MessageTemplateVersionSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> CHANNEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("channel")
            .getter(getter(MessageTemplateVersionSummary::channel)).setter(setter(Builder::channel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channel").build()).build();

    private static final SdkField<String> CHANNEL_SUBTYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("channelSubtype").getter(getter(MessageTemplateVersionSummary::channelSubtypeAsString))
            .setter(setter(Builder::channelSubtype))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelSubtype").build()).build();

    private static final SdkField<Boolean> IS_ACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isActive").getter(getter(MessageTemplateVersionSummary::isActive)).setter(setter(Builder::isActive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isActive").build()).build();

    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("versionNumber").getter(getter(MessageTemplateVersionSummary::versionNumber))
            .setter(setter(Builder::versionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_TEMPLATE_ARN_FIELD,
            MESSAGE_TEMPLATE_ID_FIELD, KNOWLEDGE_BASE_ARN_FIELD, KNOWLEDGE_BASE_ID_FIELD, NAME_FIELD, CHANNEL_FIELD,
            CHANNEL_SUBTYPE_FIELD, IS_ACTIVE_FIELD, VERSION_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String messageTemplateArn;

    private final String messageTemplateId;

    private final String knowledgeBaseArn;

    private final String knowledgeBaseId;

    private final String name;

    private final String channel;

    private final String channelSubtype;

    private final Boolean isActive;

    private final Long versionNumber;

    private MessageTemplateVersionSummary(BuilderImpl builder) {
        this.messageTemplateArn = builder.messageTemplateArn;
        this.messageTemplateId = builder.messageTemplateId;
        this.knowledgeBaseArn = builder.knowledgeBaseArn;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.name = builder.name;
        this.channel = builder.channel;
        this.channelSubtype = builder.channelSubtype;
        this.isActive = builder.isActive;
        this.versionNumber = builder.versionNumber;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the message template.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the message template.
     */
    public final String messageTemplateArn() {
        return messageTemplateArn;
    }

    /**
     * <p>
     * The identifier of the message template.
     * </p>
     * 
     * @return The identifier of the message template.
     */
    public final String messageTemplateId() {
        return messageTemplateId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the knowledge base.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the knowledge base.
     */
    public final String knowledgeBaseArn() {
        return knowledgeBaseArn;
    }

    /**
     * <p>
     * The identifier of the knowledge base.
     * </p>
     * 
     * @return The identifier of the knowledge base.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * <p>
     * The name of the message template.
     * </p>
     * 
     * @return The name of the message template.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The channel of the message template.
     * </p>
     * 
     * @return The channel of the message template.
     */
    public final String channel() {
        return channel;
    }

    /**
     * <p>
     * The channel subtype this message template applies to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelSubtype}
     * will return {@link ChannelSubtype#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #channelSubtypeAsString}.
     * </p>
     * 
     * @return The channel subtype this message template applies to.
     * @see ChannelSubtype
     */
    public final ChannelSubtype channelSubtype() {
        return ChannelSubtype.fromValue(channelSubtype);
    }

    /**
     * <p>
     * The channel subtype this message template applies to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelSubtype}
     * will return {@link ChannelSubtype#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #channelSubtypeAsString}.
     * </p>
     * 
     * @return The channel subtype this message template applies to.
     * @see ChannelSubtype
     */
    public final String channelSubtypeAsString() {
        return channelSubtype;
    }

    /**
     * <p>
     * Whether the version of the message template is activated.
     * </p>
     * 
     * @return Whether the version of the message template is activated.
     */
    public final Boolean isActive() {
        return isActive;
    }

    /**
     * <p>
     * The version number of the message template version.
     * </p>
     * 
     * @return The version number of the message template version.
     */
    public final Long versionNumber() {
        return versionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(messageTemplateArn());
        hashCode = 31 * hashCode + Objects.hashCode(messageTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(channel());
        hashCode = 31 * hashCode + Objects.hashCode(channelSubtypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(isActive());
        hashCode = 31 * hashCode + Objects.hashCode(versionNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageTemplateVersionSummary)) {
            return false;
        }
        MessageTemplateVersionSummary other = (MessageTemplateVersionSummary) obj;
        return Objects.equals(messageTemplateArn(), other.messageTemplateArn())
                && Objects.equals(messageTemplateId(), other.messageTemplateId())
                && Objects.equals(knowledgeBaseArn(), other.knowledgeBaseArn())
                && Objects.equals(knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(name(), other.name())
                && Objects.equals(channel(), other.channel())
                && Objects.equals(channelSubtypeAsString(), other.channelSubtypeAsString())
                && Objects.equals(isActive(), other.isActive()) && Objects.equals(versionNumber(), other.versionNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MessageTemplateVersionSummary").add("MessageTemplateArn", messageTemplateArn())
                .add("MessageTemplateId", messageTemplateId()).add("KnowledgeBaseArn", knowledgeBaseArn())
                .add("KnowledgeBaseId", knowledgeBaseId()).add("Name", name())
                .add("Channel", channel() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ChannelSubtype", channelSubtypeAsString()).add("IsActive", isActive())
                .add("VersionNumber", versionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "messageTemplateArn":
            return Optional.ofNullable(clazz.cast(messageTemplateArn()));
        case "messageTemplateId":
            return Optional.ofNullable(clazz.cast(messageTemplateId()));
        case "knowledgeBaseArn":
            return Optional.ofNullable(clazz.cast(knowledgeBaseArn()));
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "channel":
            return Optional.ofNullable(clazz.cast(channel()));
        case "channelSubtype":
            return Optional.ofNullable(clazz.cast(channelSubtypeAsString()));
        case "isActive":
            return Optional.ofNullable(clazz.cast(isActive()));
        case "versionNumber":
            return Optional.ofNullable(clazz.cast(versionNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("messageTemplateArn", MESSAGE_TEMPLATE_ARN_FIELD);
        map.put("messageTemplateId", MESSAGE_TEMPLATE_ID_FIELD);
        map.put("knowledgeBaseArn", KNOWLEDGE_BASE_ARN_FIELD);
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("channel", CHANNEL_FIELD);
        map.put("channelSubtype", CHANNEL_SUBTYPE_FIELD);
        map.put("isActive", IS_ACTIVE_FIELD);
        map.put("versionNumber", VERSION_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MessageTemplateVersionSummary, T> g) {
        return obj -> g.apply((MessageTemplateVersionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MessageTemplateVersionSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the message template.
         * </p>
         * 
         * @param messageTemplateArn
         *        The Amazon Resource Name (ARN) of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageTemplateArn(String messageTemplateArn);

        /**
         * <p>
         * The identifier of the message template.
         * </p>
         * 
         * @param messageTemplateId
         *        The identifier of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageTemplateId(String messageTemplateId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the knowledge base.
         * </p>
         * 
         * @param knowledgeBaseArn
         *        The Amazon Resource Name (ARN) of the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseArn(String knowledgeBaseArn);

        /**
         * <p>
         * The identifier of the knowledge base.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The identifier of the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * The name of the message template.
         * </p>
         * 
         * @param name
         *        The name of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The channel of the message template.
         * </p>
         * 
         * @param channel
         *        The channel of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channel(String channel);

        /**
         * <p>
         * The channel subtype this message template applies to.
         * </p>
         * 
         * @param channelSubtype
         *        The channel subtype this message template applies to.
         * @see ChannelSubtype
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelSubtype
         */
        Builder channelSubtype(String channelSubtype);

        /**
         * <p>
         * The channel subtype this message template applies to.
         * </p>
         * 
         * @param channelSubtype
         *        The channel subtype this message template applies to.
         * @see ChannelSubtype
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelSubtype
         */
        Builder channelSubtype(ChannelSubtype channelSubtype);

        /**
         * <p>
         * Whether the version of the message template is activated.
         * </p>
         * 
         * @param isActive
         *        Whether the version of the message template is activated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isActive(Boolean isActive);

        /**
         * <p>
         * The version number of the message template version.
         * </p>
         * 
         * @param versionNumber
         *        The version number of the message template version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNumber(Long versionNumber);
    }

    static final class BuilderImpl implements Builder {
        private String messageTemplateArn;

        private String messageTemplateId;

        private String knowledgeBaseArn;

        private String knowledgeBaseId;

        private String name;

        private String channel;

        private String channelSubtype;

        private Boolean isActive;

        private Long versionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageTemplateVersionSummary model) {
            messageTemplateArn(model.messageTemplateArn);
            messageTemplateId(model.messageTemplateId);
            knowledgeBaseArn(model.knowledgeBaseArn);
            knowledgeBaseId(model.knowledgeBaseId);
            name(model.name);
            channel(model.channel);
            channelSubtype(model.channelSubtype);
            isActive(model.isActive);
            versionNumber(model.versionNumber);
        }

        public final String getMessageTemplateArn() {
            return messageTemplateArn;
        }

        public final void setMessageTemplateArn(String messageTemplateArn) {
            this.messageTemplateArn = messageTemplateArn;
        }

        @Override
        public final Builder messageTemplateArn(String messageTemplateArn) {
            this.messageTemplateArn = messageTemplateArn;
            return this;
        }

        public final String getMessageTemplateId() {
            return messageTemplateId;
        }

        public final void setMessageTemplateId(String messageTemplateId) {
            this.messageTemplateId = messageTemplateId;
        }

        @Override
        public final Builder messageTemplateId(String messageTemplateId) {
            this.messageTemplateId = messageTemplateId;
            return this;
        }

        public final String getKnowledgeBaseArn() {
            return knowledgeBaseArn;
        }

        public final void setKnowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
        }

        @Override
        public final Builder knowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getChannel() {
            return channel;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        public final String getChannelSubtype() {
            return channelSubtype;
        }

        public final void setChannelSubtype(String channelSubtype) {
            this.channelSubtype = channelSubtype;
        }

        @Override
        public final Builder channelSubtype(String channelSubtype) {
            this.channelSubtype = channelSubtype;
            return this;
        }

        @Override
        public final Builder channelSubtype(ChannelSubtype channelSubtype) {
            this.channelSubtype(channelSubtype == null ? null : channelSubtype.toString());
            return this;
        }

        public final Boolean getIsActive() {
            return isActive;
        }

        public final void setIsActive(Boolean isActive) {
            this.isActive = isActive;
        }

        @Override
        public final Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public final Long getVersionNumber() {
            return versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        @Override
        public MessageTemplateVersionSummary build() {
            return new MessageTemplateVersionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
