/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The search expression of the message template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MessageTemplateSearchExpression implements SdkPojo, Serializable,
        ToCopyableBuilder<MessageTemplateSearchExpression.Builder, MessageTemplateSearchExpression> {
    private static final SdkField<List<MessageTemplateQueryField>> QUERIES_FIELD = SdkField
            .<List<MessageTemplateQueryField>> builder(MarshallingType.LIST)
            .memberName("queries")
            .getter(getter(MessageTemplateSearchExpression::queries))
            .setter(setter(Builder::queries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MessageTemplateQueryField> builder(MarshallingType.SDK_POJO)
                                            .constructor(MessageTemplateQueryField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MessageTemplateFilterField>> FILTERS_FIELD = SdkField
            .<List<MessageTemplateFilterField>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(MessageTemplateSearchExpression::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MessageTemplateFilterField> builder(MarshallingType.SDK_POJO)
                                            .constructor(MessageTemplateFilterField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MessageTemplateOrderField> ORDER_ON_FIELD_FIELD = SdkField
            .<MessageTemplateOrderField> builder(MarshallingType.SDK_POJO).memberName("orderOnField")
            .getter(getter(MessageTemplateSearchExpression::orderOnField)).setter(setter(Builder::orderOnField))
            .constructor(MessageTemplateOrderField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderOnField").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERIES_FIELD, FILTERS_FIELD,
            ORDER_ON_FIELD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<MessageTemplateQueryField> queries;

    private final List<MessageTemplateFilterField> filters;

    private final MessageTemplateOrderField orderOnField;

    private MessageTemplateSearchExpression(BuilderImpl builder) {
        this.queries = builder.queries;
        this.filters = builder.filters;
        this.orderOnField = builder.orderOnField;
    }

    /**
     * For responses, this returns true if the service returned a value for the Queries property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasQueries() {
        return queries != null && !(queries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The message template query expressions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueries} method.
     * </p>
     * 
     * @return The message template query expressions.
     */
    public final List<MessageTemplateQueryField> queries() {
        return queries;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration of filtering rules applied to message template query results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The configuration of filtering rules applied to message template query results.
     */
    public final List<MessageTemplateFilterField> filters() {
        return filters;
    }

    /**
     * <p>
     * The message template attribute fields on which the query results are ordered.
     * </p>
     * 
     * @return The message template attribute fields on which the query results are ordered.
     */
    public final MessageTemplateOrderField orderOnField() {
        return orderOnField;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasQueries() ? queries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(orderOnField());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageTemplateSearchExpression)) {
            return false;
        }
        MessageTemplateSearchExpression other = (MessageTemplateSearchExpression) obj;
        return hasQueries() == other.hasQueries() && Objects.equals(queries(), other.queries())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(orderOnField(), other.orderOnField());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MessageTemplateSearchExpression").add("Queries", hasQueries() ? queries() : null)
                .add("Filters", hasFilters() ? filters() : null).add("OrderOnField", orderOnField()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "queries":
            return Optional.ofNullable(clazz.cast(queries()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "orderOnField":
            return Optional.ofNullable(clazz.cast(orderOnField()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("queries", QUERIES_FIELD);
        map.put("filters", FILTERS_FIELD);
        map.put("orderOnField", ORDER_ON_FIELD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MessageTemplateSearchExpression, T> g) {
        return obj -> g.apply((MessageTemplateSearchExpression) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MessageTemplateSearchExpression> {
        /**
         * <p>
         * The message template query expressions.
         * </p>
         * 
         * @param queries
         *        The message template query expressions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queries(Collection<MessageTemplateQueryField> queries);

        /**
         * <p>
         * The message template query expressions.
         * </p>
         * 
         * @param queries
         *        The message template query expressions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queries(MessageTemplateQueryField... queries);

        /**
         * <p>
         * The message template query expressions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.MessageTemplateQueryField.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.qconnect.model.MessageTemplateQueryField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.MessageTemplateQueryField.Builder#build()} is called
         * immediately and its result is passed to {@link #queries(List<MessageTemplateQueryField>)}.
         * 
         * @param queries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.MessageTemplateQueryField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queries(java.util.Collection<MessageTemplateQueryField>)
         */
        Builder queries(Consumer<MessageTemplateQueryField.Builder>... queries);

        /**
         * <p>
         * The configuration of filtering rules applied to message template query results.
         * </p>
         * 
         * @param filters
         *        The configuration of filtering rules applied to message template query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<MessageTemplateFilterField> filters);

        /**
         * <p>
         * The configuration of filtering rules applied to message template query results.
         * </p>
         * 
         * @param filters
         *        The configuration of filtering rules applied to message template query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(MessageTemplateFilterField... filters);

        /**
         * <p>
         * The configuration of filtering rules applied to message template query results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.MessageTemplateFilterField.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.qconnect.model.MessageTemplateFilterField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.MessageTemplateFilterField.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<MessageTemplateFilterField>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.MessageTemplateFilterField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<MessageTemplateFilterField>)
         */
        Builder filters(Consumer<MessageTemplateFilterField.Builder>... filters);

        /**
         * <p>
         * The message template attribute fields on which the query results are ordered.
         * </p>
         * 
         * @param orderOnField
         *        The message template attribute fields on which the query results are ordered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderOnField(MessageTemplateOrderField orderOnField);

        /**
         * <p>
         * The message template attribute fields on which the query results are ordered.
         * </p>
         * This is a convenience method that creates an instance of the {@link MessageTemplateOrderField.Builder}
         * avoiding the need to create one manually via {@link MessageTemplateOrderField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageTemplateOrderField.Builder#build()} is called immediately
         * and its result is passed to {@link #orderOnField(MessageTemplateOrderField)}.
         * 
         * @param orderOnField
         *        a consumer that will call methods on {@link MessageTemplateOrderField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orderOnField(MessageTemplateOrderField)
         */
        default Builder orderOnField(Consumer<MessageTemplateOrderField.Builder> orderOnField) {
            return orderOnField(MessageTemplateOrderField.builder().applyMutation(orderOnField).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<MessageTemplateQueryField> queries = DefaultSdkAutoConstructList.getInstance();

        private List<MessageTemplateFilterField> filters = DefaultSdkAutoConstructList.getInstance();

        private MessageTemplateOrderField orderOnField;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageTemplateSearchExpression model) {
            queries(model.queries);
            filters(model.filters);
            orderOnField(model.orderOnField);
        }

        public final List<MessageTemplateQueryField.Builder> getQueries() {
            List<MessageTemplateQueryField.Builder> result = MessageTemplateQueryFieldListCopier.copyToBuilder(this.queries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueries(Collection<MessageTemplateQueryField.BuilderImpl> queries) {
            this.queries = MessageTemplateQueryFieldListCopier.copyFromBuilder(queries);
        }

        @Override
        public final Builder queries(Collection<MessageTemplateQueryField> queries) {
            this.queries = MessageTemplateQueryFieldListCopier.copy(queries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queries(MessageTemplateQueryField... queries) {
            queries(Arrays.asList(queries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queries(Consumer<MessageTemplateQueryField.Builder>... queries) {
            queries(Stream.of(queries).map(c -> MessageTemplateQueryField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<MessageTemplateFilterField.Builder> getFilters() {
            List<MessageTemplateFilterField.Builder> result = MessageTemplateFilterFieldListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<MessageTemplateFilterField.BuilderImpl> filters) {
            this.filters = MessageTemplateFilterFieldListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<MessageTemplateFilterField> filters) {
            this.filters = MessageTemplateFilterFieldListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(MessageTemplateFilterField... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<MessageTemplateFilterField.Builder>... filters) {
            filters(Stream.of(filters).map(c -> MessageTemplateFilterField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final MessageTemplateOrderField.Builder getOrderOnField() {
            return orderOnField != null ? orderOnField.toBuilder() : null;
        }

        public final void setOrderOnField(MessageTemplateOrderField.BuilderImpl orderOnField) {
            this.orderOnField = orderOnField != null ? orderOnField.build() : null;
        }

        @Override
        public final Builder orderOnField(MessageTemplateOrderField orderOnField) {
            this.orderOnField = orderOnField;
            return this;
        }

        @Override
        public MessageTemplateSearchExpression build() {
            return new MessageTemplateSearchExpression(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
