/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAiPromptsResponse extends QConnectResponse implements
        ToCopyableBuilder<ListAiPromptsResponse.Builder, ListAiPromptsResponse> {
    private static final SdkField<List<AIPromptSummary>> AI_PROMPT_SUMMARIES_FIELD = SdkField
            .<List<AIPromptSummary>> builder(MarshallingType.LIST)
            .memberName("aiPromptSummaries")
            .getter(getter(ListAiPromptsResponse::aiPromptSummaries))
            .setter(setter(Builder::aiPromptSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiPromptSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AIPromptSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AIPromptSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAiPromptsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AI_PROMPT_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AIPromptSummary> aiPromptSummaries;

    private final String nextToken;

    private ListAiPromptsResponse(BuilderImpl builder) {
        super(builder);
        this.aiPromptSummaries = builder.aiPromptSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AiPromptSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAiPromptSummaries() {
        return aiPromptSummaries != null && !(aiPromptSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The summaries of the AI Prompts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAiPromptSummaries} method.
     * </p>
     * 
     * @return The summaries of the AI Prompts.
     */
    public final List<AIPromptSummary> aiPromptSummaries() {
        return aiPromptSummaries;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAiPromptSummaries() ? aiPromptSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAiPromptsResponse)) {
            return false;
        }
        ListAiPromptsResponse other = (ListAiPromptsResponse) obj;
        return hasAiPromptSummaries() == other.hasAiPromptSummaries()
                && Objects.equals(aiPromptSummaries(), other.aiPromptSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAiPromptsResponse")
                .add("AiPromptSummaries", hasAiPromptSummaries() ? aiPromptSummaries() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "aiPromptSummaries":
            return Optional.ofNullable(clazz.cast(aiPromptSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("aiPromptSummaries", AI_PROMPT_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAiPromptsResponse, T> g) {
        return obj -> g.apply((ListAiPromptsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAiPromptsResponse> {
        /**
         * <p>
         * The summaries of the AI Prompts.
         * </p>
         * 
         * @param aiPromptSummaries
         *        The summaries of the AI Prompts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiPromptSummaries(Collection<AIPromptSummary> aiPromptSummaries);

        /**
         * <p>
         * The summaries of the AI Prompts.
         * </p>
         * 
         * @param aiPromptSummaries
         *        The summaries of the AI Prompts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiPromptSummaries(AIPromptSummary... aiPromptSummaries);

        /**
         * <p>
         * The summaries of the AI Prompts.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.AIPromptSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.qconnect.model.AIPromptSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.AIPromptSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #aiPromptSummaries(List<AIPromptSummary>)}.
         * 
         * @param aiPromptSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.AIPromptSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aiPromptSummaries(java.util.Collection<AIPromptSummary>)
         */
        Builder aiPromptSummaries(Consumer<AIPromptSummary.Builder>... aiPromptSummaries);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends QConnectResponse.BuilderImpl implements Builder {
        private List<AIPromptSummary> aiPromptSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAiPromptsResponse model) {
            super(model);
            aiPromptSummaries(model.aiPromptSummaries);
            nextToken(model.nextToken);
        }

        public final List<AIPromptSummary.Builder> getAiPromptSummaries() {
            List<AIPromptSummary.Builder> result = AIPromptSummaryListCopier.copyToBuilder(this.aiPromptSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAiPromptSummaries(Collection<AIPromptSummary.BuilderImpl> aiPromptSummaries) {
            this.aiPromptSummaries = AIPromptSummaryListCopier.copyFromBuilder(aiPromptSummaries);
        }

        @Override
        public final Builder aiPromptSummaries(Collection<AIPromptSummary> aiPromptSummaries) {
            this.aiPromptSummaries = AIPromptSummaryListCopier.copy(aiPromptSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aiPromptSummaries(AIPromptSummary... aiPromptSummaries) {
            aiPromptSummaries(Arrays.asList(aiPromptSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aiPromptSummaries(Consumer<AIPromptSummary.Builder>... aiPromptSummaries) {
            aiPromptSummaries(Stream.of(aiPromptSummaries).map(c -> AIPromptSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAiPromptsResponse build() {
            return new ListAiPromptsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
