/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for an external Bedrock knowledge base.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExternalBedrockKnowledgeBaseConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ExternalBedrockKnowledgeBaseConfig.Builder, ExternalBedrockKnowledgeBaseConfig> {
    private static final SdkField<String> BEDROCK_KNOWLEDGE_BASE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bedrockKnowledgeBaseArn").getter(getter(ExternalBedrockKnowledgeBaseConfig::bedrockKnowledgeBaseArn))
            .setter(setter(Builder::bedrockKnowledgeBaseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bedrockKnowledgeBaseArn").build())
            .build();

    private static final SdkField<String> ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessRoleArn").getter(getter(ExternalBedrockKnowledgeBaseConfig::accessRoleArn))
            .setter(setter(Builder::accessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BEDROCK_KNOWLEDGE_BASE_ARN_FIELD, ACCESS_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String bedrockKnowledgeBaseArn;

    private final String accessRoleArn;

    private ExternalBedrockKnowledgeBaseConfig(BuilderImpl builder) {
        this.bedrockKnowledgeBaseArn = builder.bedrockKnowledgeBaseArn;
        this.accessRoleArn = builder.accessRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the external Bedrock knowledge base.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the external Bedrock knowledge base.
     */
    public final String bedrockKnowledgeBaseArn() {
        return bedrockKnowledgeBaseArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role used to access the external Bedrock knowledge base.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role used to access the external Bedrock knowledge base.
     */
    public final String accessRoleArn() {
        return accessRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bedrockKnowledgeBaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(accessRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalBedrockKnowledgeBaseConfig)) {
            return false;
        }
        ExternalBedrockKnowledgeBaseConfig other = (ExternalBedrockKnowledgeBaseConfig) obj;
        return Objects.equals(bedrockKnowledgeBaseArn(), other.bedrockKnowledgeBaseArn())
                && Objects.equals(accessRoleArn(), other.accessRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExternalBedrockKnowledgeBaseConfig").add("BedrockKnowledgeBaseArn", bedrockKnowledgeBaseArn())
                .add("AccessRoleArn", accessRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bedrockKnowledgeBaseArn":
            return Optional.ofNullable(clazz.cast(bedrockKnowledgeBaseArn()));
        case "accessRoleArn":
            return Optional.ofNullable(clazz.cast(accessRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("bedrockKnowledgeBaseArn", BEDROCK_KNOWLEDGE_BASE_ARN_FIELD);
        map.put("accessRoleArn", ACCESS_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExternalBedrockKnowledgeBaseConfig, T> g) {
        return obj -> g.apply((ExternalBedrockKnowledgeBaseConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExternalBedrockKnowledgeBaseConfig> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the external Bedrock knowledge base.
         * </p>
         * 
         * @param bedrockKnowledgeBaseArn
         *        The Amazon Resource Name (ARN) of the external Bedrock knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bedrockKnowledgeBaseArn(String bedrockKnowledgeBaseArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role used to access the external Bedrock knowledge base.
         * </p>
         * 
         * @param accessRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role used to access the external Bedrock knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessRoleArn(String accessRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String bedrockKnowledgeBaseArn;

        private String accessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalBedrockKnowledgeBaseConfig model) {
            bedrockKnowledgeBaseArn(model.bedrockKnowledgeBaseArn);
            accessRoleArn(model.accessRoleArn);
        }

        public final String getBedrockKnowledgeBaseArn() {
            return bedrockKnowledgeBaseArn;
        }

        public final void setBedrockKnowledgeBaseArn(String bedrockKnowledgeBaseArn) {
            this.bedrockKnowledgeBaseArn = bedrockKnowledgeBaseArn;
        }

        @Override
        public final Builder bedrockKnowledgeBaseArn(String bedrockKnowledgeBaseArn) {
            this.bedrockKnowledgeBaseArn = bedrockKnowledgeBaseArn;
            return this;
        }

        public final String getAccessRoleArn() {
            return accessRoleArn;
        }

        public final void setAccessRoleArn(String accessRoleArn) {
            this.accessRoleArn = accessRoleArn;
        }

        @Override
        public final Builder accessRoleArn(String accessRoleArn) {
            this.accessRoleArn = accessRoleArn;
            return this;
        }

        @Override
        public ExternalBedrockKnowledgeBaseConfig build() {
            return new ExternalBedrockKnowledgeBaseConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
