/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The body to use in email messages.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmailMessageTemplateContentBody implements SdkPojo, Serializable,
        ToCopyableBuilder<EmailMessageTemplateContentBody.Builder, EmailMessageTemplateContentBody> {
    private static final SdkField<MessageTemplateBodyContentProvider> PLAIN_TEXT_FIELD = SdkField
            .<MessageTemplateBodyContentProvider> builder(MarshallingType.SDK_POJO).memberName("plainText")
            .getter(getter(EmailMessageTemplateContentBody::plainText)).setter(setter(Builder::plainText))
            .constructor(MessageTemplateBodyContentProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("plainText").build()).build();

    private static final SdkField<MessageTemplateBodyContentProvider> HTML_FIELD = SdkField
            .<MessageTemplateBodyContentProvider> builder(MarshallingType.SDK_POJO).memberName("html")
            .getter(getter(EmailMessageTemplateContentBody::html)).setter(setter(Builder::html))
            .constructor(MessageTemplateBodyContentProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("html").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAIN_TEXT_FIELD, HTML_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MessageTemplateBodyContentProvider plainText;

    private final MessageTemplateBodyContentProvider html;

    private EmailMessageTemplateContentBody(BuilderImpl builder) {
        this.plainText = builder.plainText;
        this.html = builder.html;
    }

    /**
     * <p>
     * The message body, in plain text format, to use in email messages that are based on the message template. We
     * recommend using plain text format for email clients that don't render HTML content and clients that are connected
     * to high-latency networks, such as mobile devices.
     * </p>
     * 
     * @return The message body, in plain text format, to use in email messages that are based on the message template.
     *         We recommend using plain text format for email clients that don't render HTML content and clients that
     *         are connected to high-latency networks, such as mobile devices.
     */
    public final MessageTemplateBodyContentProvider plainText() {
        return plainText;
    }

    /**
     * <p>
     * The message body, in HTML format, to use in email messages that are based on the message template. We recommend
     * using HTML format for email clients that render HTML content. You can include links, formatted text, and more in
     * an HTML message.
     * </p>
     * 
     * @return The message body, in HTML format, to use in email messages that are based on the message template. We
     *         recommend using HTML format for email clients that render HTML content. You can include links, formatted
     *         text, and more in an HTML message.
     */
    public final MessageTemplateBodyContentProvider html() {
        return html;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(plainText());
        hashCode = 31 * hashCode + Objects.hashCode(html());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailMessageTemplateContentBody)) {
            return false;
        }
        EmailMessageTemplateContentBody other = (EmailMessageTemplateContentBody) obj;
        return Objects.equals(plainText(), other.plainText()) && Objects.equals(html(), other.html());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmailMessageTemplateContentBody").add("PlainText", plainText()).add("Html", html()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "plainText":
            return Optional.ofNullable(clazz.cast(plainText()));
        case "html":
            return Optional.ofNullable(clazz.cast(html()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("plainText", PLAIN_TEXT_FIELD);
        map.put("html", HTML_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EmailMessageTemplateContentBody, T> g) {
        return obj -> g.apply((EmailMessageTemplateContentBody) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmailMessageTemplateContentBody> {
        /**
         * <p>
         * The message body, in plain text format, to use in email messages that are based on the message template. We
         * recommend using plain text format for email clients that don't render HTML content and clients that are
         * connected to high-latency networks, such as mobile devices.
         * </p>
         * 
         * @param plainText
         *        The message body, in plain text format, to use in email messages that are based on the message
         *        template. We recommend using plain text format for email clients that don't render HTML content and
         *        clients that are connected to high-latency networks, such as mobile devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder plainText(MessageTemplateBodyContentProvider plainText);

        /**
         * <p>
         * The message body, in plain text format, to use in email messages that are based on the message template. We
         * recommend using plain text format for email clients that don't render HTML content and clients that are
         * connected to high-latency networks, such as mobile devices.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MessageTemplateBodyContentProvider.Builder} avoiding the need to create one manually via
         * {@link MessageTemplateBodyContentProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageTemplateBodyContentProvider.Builder#build()} is called
         * immediately and its result is passed to {@link #plainText(MessageTemplateBodyContentProvider)}.
         * 
         * @param plainText
         *        a consumer that will call methods on {@link MessageTemplateBodyContentProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #plainText(MessageTemplateBodyContentProvider)
         */
        default Builder plainText(Consumer<MessageTemplateBodyContentProvider.Builder> plainText) {
            return plainText(MessageTemplateBodyContentProvider.builder().applyMutation(plainText).build());
        }

        /**
         * <p>
         * The message body, in HTML format, to use in email messages that are based on the message template. We
         * recommend using HTML format for email clients that render HTML content. You can include links, formatted
         * text, and more in an HTML message.
         * </p>
         * 
         * @param html
         *        The message body, in HTML format, to use in email messages that are based on the message template. We
         *        recommend using HTML format for email clients that render HTML content. You can include links,
         *        formatted text, and more in an HTML message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder html(MessageTemplateBodyContentProvider html);

        /**
         * <p>
         * The message body, in HTML format, to use in email messages that are based on the message template. We
         * recommend using HTML format for email clients that render HTML content. You can include links, formatted
         * text, and more in an HTML message.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MessageTemplateBodyContentProvider.Builder} avoiding the need to create one manually via
         * {@link MessageTemplateBodyContentProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageTemplateBodyContentProvider.Builder#build()} is called
         * immediately and its result is passed to {@link #html(MessageTemplateBodyContentProvider)}.
         * 
         * @param html
         *        a consumer that will call methods on {@link MessageTemplateBodyContentProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #html(MessageTemplateBodyContentProvider)
         */
        default Builder html(Consumer<MessageTemplateBodyContentProvider.Builder> html) {
            return html(MessageTemplateBodyContentProvider.builder().applyMutation(html).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MessageTemplateBodyContentProvider plainText;

        private MessageTemplateBodyContentProvider html;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailMessageTemplateContentBody model) {
            plainText(model.plainText);
            html(model.html);
        }

        public final MessageTemplateBodyContentProvider.Builder getPlainText() {
            return plainText != null ? plainText.toBuilder() : null;
        }

        public final void setPlainText(MessageTemplateBodyContentProvider.BuilderImpl plainText) {
            this.plainText = plainText != null ? plainText.build() : null;
        }

        @Override
        public final Builder plainText(MessageTemplateBodyContentProvider plainText) {
            this.plainText = plainText;
            return this;
        }

        public final MessageTemplateBodyContentProvider.Builder getHtml() {
            return html != null ? html.toBuilder() : null;
        }

        public final void setHtml(MessageTemplateBodyContentProvider.BuilderImpl html) {
            this.html = html != null ? html.build() : null;
        }

        @Override
        public final Builder html(MessageTemplateBodyContentProvider html) {
            this.html = html;
            return this;
        }

        @Override
        public EmailMessageTemplateContentBody build() {
            return new EmailMessageTemplateContentBody(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
