/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about case summarization chunk data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CaseSummarizationChunkDataDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<CaseSummarizationChunkDataDetails.Builder, CaseSummarizationChunkDataDetails> {
    private static final SdkField<String> COMPLETION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("completion").getter(getter(CaseSummarizationChunkDataDetails::completion))
            .setter(setter(Builder::completion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completion").build()).build();

    private static final SdkField<String> NEXT_CHUNK_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextChunkToken").getter(getter(CaseSummarizationChunkDataDetails::nextChunkToken))
            .setter(setter(Builder::nextChunkToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextChunkToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETION_FIELD,
            NEXT_CHUNK_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String completion;

    private final String nextChunkToken;

    private CaseSummarizationChunkDataDetails(BuilderImpl builder) {
        this.completion = builder.completion;
        this.nextChunkToken = builder.nextChunkToken;
    }

    /**
     * <p>
     * A chunk of the case summarization completion.
     * </p>
     * 
     * @return A chunk of the case summarization completion.
     */
    public final String completion() {
        return completion;
    }

    /**
     * <p>
     * Token for retrieving the next chunk of streaming summarization data, if available.
     * </p>
     * 
     * @return Token for retrieving the next chunk of streaming summarization data, if available.
     */
    public final String nextChunkToken() {
        return nextChunkToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(completion());
        hashCode = 31 * hashCode + Objects.hashCode(nextChunkToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaseSummarizationChunkDataDetails)) {
            return false;
        }
        CaseSummarizationChunkDataDetails other = (CaseSummarizationChunkDataDetails) obj;
        return Objects.equals(completion(), other.completion()) && Objects.equals(nextChunkToken(), other.nextChunkToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CaseSummarizationChunkDataDetails").add("Completion", completion())
                .add("NextChunkToken", nextChunkToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "completion":
            return Optional.ofNullable(clazz.cast(completion()));
        case "nextChunkToken":
            return Optional.ofNullable(clazz.cast(nextChunkToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("completion", COMPLETION_FIELD);
        map.put("nextChunkToken", NEXT_CHUNK_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CaseSummarizationChunkDataDetails, T> g) {
        return obj -> g.apply((CaseSummarizationChunkDataDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CaseSummarizationChunkDataDetails> {
        /**
         * <p>
         * A chunk of the case summarization completion.
         * </p>
         * 
         * @param completion
         *        A chunk of the case summarization completion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completion(String completion);

        /**
         * <p>
         * Token for retrieving the next chunk of streaming summarization data, if available.
         * </p>
         * 
         * @param nextChunkToken
         *        Token for retrieving the next chunk of streaming summarization data, if available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextChunkToken(String nextChunkToken);
    }

    static final class BuilderImpl implements Builder {
        private String completion;

        private String nextChunkToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CaseSummarizationChunkDataDetails model) {
            completion(model.completion);
            nextChunkToken(model.nextChunkToken);
        }

        public final String getCompletion() {
            return completion;
        }

        public final void setCompletion(String completion) {
            this.completion = completion;
        }

        @Override
        public final Builder completion(String completion) {
            this.completion = completion;
            return this;
        }

        public final String getNextChunkToken() {
            return nextChunkToken;
        }

        public final void setNextChunkToken(String nextChunkToken) {
            this.nextChunkToken = nextChunkToken;
        }

        @Override
        public final Builder nextChunkToken(String nextChunkToken) {
            this.nextChunkToken = nextChunkToken;
            return this;
        }

        @Override
        public CaseSummarizationChunkDataDetails build() {
            return new CaseSummarizationChunkDataDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
