/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for AI Agents of type <code>CASE_SUMMARIZATION</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CaseSummarizationAIAgentConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CaseSummarizationAIAgentConfiguration.Builder, CaseSummarizationAIAgentConfiguration> {
    private static final SdkField<String> CASE_SUMMARIZATION_AI_PROMPT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("caseSummarizationAIPromptId")
            .getter(getter(CaseSummarizationAIAgentConfiguration::caseSummarizationAIPromptId))
            .setter(setter(Builder::caseSummarizationAIPromptId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseSummarizationAIPromptId")
                    .build()).build();

    private static final SdkField<String> CASE_SUMMARIZATION_AI_GUARDRAIL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("caseSummarizationAIGuardrailId")
            .getter(getter(CaseSummarizationAIAgentConfiguration::caseSummarizationAIGuardrailId))
            .setter(setter(Builder::caseSummarizationAIGuardrailId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseSummarizationAIGuardrailId")
                    .build()).build();

    private static final SdkField<String> LOCALE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("locale")
            .getter(getter(CaseSummarizationAIAgentConfiguration::locale)).setter(setter(Builder::locale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locale").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CASE_SUMMARIZATION_AI_PROMPT_ID_FIELD, CASE_SUMMARIZATION_AI_GUARDRAIL_ID_FIELD, LOCALE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String caseSummarizationAIPromptId;

    private final String caseSummarizationAIGuardrailId;

    private final String locale;

    private CaseSummarizationAIAgentConfiguration(BuilderImpl builder) {
        this.caseSummarizationAIPromptId = builder.caseSummarizationAIPromptId;
        this.caseSummarizationAIGuardrailId = builder.caseSummarizationAIGuardrailId;
        this.locale = builder.locale;
    }

    /**
     * <p>
     * The AI Prompt identifier used by the Case Summarization AI Agent.
     * </p>
     * 
     * @return The AI Prompt identifier used by the Case Summarization AI Agent.
     */
    public final String caseSummarizationAIPromptId() {
        return caseSummarizationAIPromptId;
    }

    /**
     * <p>
     * The AI Guardrail identifier used by the Case Summarization AI Agent.
     * </p>
     * 
     * @return The AI Guardrail identifier used by the Case Summarization AI Agent.
     */
    public final String caseSummarizationAIGuardrailId() {
        return caseSummarizationAIGuardrailId;
    }

    /**
     * <p>
     * The locale setting for the Case Summarization AI Agent.
     * </p>
     * 
     * @return The locale setting for the Case Summarization AI Agent.
     */
    public final String locale() {
        return locale;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(caseSummarizationAIPromptId());
        hashCode = 31 * hashCode + Objects.hashCode(caseSummarizationAIGuardrailId());
        hashCode = 31 * hashCode + Objects.hashCode(locale());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaseSummarizationAIAgentConfiguration)) {
            return false;
        }
        CaseSummarizationAIAgentConfiguration other = (CaseSummarizationAIAgentConfiguration) obj;
        return Objects.equals(caseSummarizationAIPromptId(), other.caseSummarizationAIPromptId())
                && Objects.equals(caseSummarizationAIGuardrailId(), other.caseSummarizationAIGuardrailId())
                && Objects.equals(locale(), other.locale());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CaseSummarizationAIAgentConfiguration")
                .add("CaseSummarizationAIPromptId", caseSummarizationAIPromptId())
                .add("CaseSummarizationAIGuardrailId", caseSummarizationAIGuardrailId()).add("Locale", locale()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "caseSummarizationAIPromptId":
            return Optional.ofNullable(clazz.cast(caseSummarizationAIPromptId()));
        case "caseSummarizationAIGuardrailId":
            return Optional.ofNullable(clazz.cast(caseSummarizationAIGuardrailId()));
        case "locale":
            return Optional.ofNullable(clazz.cast(locale()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("caseSummarizationAIPromptId", CASE_SUMMARIZATION_AI_PROMPT_ID_FIELD);
        map.put("caseSummarizationAIGuardrailId", CASE_SUMMARIZATION_AI_GUARDRAIL_ID_FIELD);
        map.put("locale", LOCALE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CaseSummarizationAIAgentConfiguration, T> g) {
        return obj -> g.apply((CaseSummarizationAIAgentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CaseSummarizationAIAgentConfiguration> {
        /**
         * <p>
         * The AI Prompt identifier used by the Case Summarization AI Agent.
         * </p>
         * 
         * @param caseSummarizationAIPromptId
         *        The AI Prompt identifier used by the Case Summarization AI Agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseSummarizationAIPromptId(String caseSummarizationAIPromptId);

        /**
         * <p>
         * The AI Guardrail identifier used by the Case Summarization AI Agent.
         * </p>
         * 
         * @param caseSummarizationAIGuardrailId
         *        The AI Guardrail identifier used by the Case Summarization AI Agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseSummarizationAIGuardrailId(String caseSummarizationAIGuardrailId);

        /**
         * <p>
         * The locale setting for the Case Summarization AI Agent.
         * </p>
         * 
         * @param locale
         *        The locale setting for the Case Summarization AI Agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locale(String locale);
    }

    static final class BuilderImpl implements Builder {
        private String caseSummarizationAIPromptId;

        private String caseSummarizationAIGuardrailId;

        private String locale;

        private BuilderImpl() {
        }

        private BuilderImpl(CaseSummarizationAIAgentConfiguration model) {
            caseSummarizationAIPromptId(model.caseSummarizationAIPromptId);
            caseSummarizationAIGuardrailId(model.caseSummarizationAIGuardrailId);
            locale(model.locale);
        }

        public final String getCaseSummarizationAIPromptId() {
            return caseSummarizationAIPromptId;
        }

        public final void setCaseSummarizationAIPromptId(String caseSummarizationAIPromptId) {
            this.caseSummarizationAIPromptId = caseSummarizationAIPromptId;
        }

        @Override
        public final Builder caseSummarizationAIPromptId(String caseSummarizationAIPromptId) {
            this.caseSummarizationAIPromptId = caseSummarizationAIPromptId;
            return this;
        }

        public final String getCaseSummarizationAIGuardrailId() {
            return caseSummarizationAIGuardrailId;
        }

        public final void setCaseSummarizationAIGuardrailId(String caseSummarizationAIGuardrailId) {
            this.caseSummarizationAIGuardrailId = caseSummarizationAIGuardrailId;
        }

        @Override
        public final Builder caseSummarizationAIGuardrailId(String caseSummarizationAIGuardrailId) {
            this.caseSummarizationAIGuardrailId = caseSummarizationAIGuardrailId;
            return this;
        }

        public final String getLocale() {
            return locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public CaseSummarizationAIAgentConfiguration build() {
            return new CaseSummarizationAIAgentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
