/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings for a foundation model used to parse documents for a data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BedrockFoundationModelConfigurationForParsing implements SdkPojo, Serializable,
        ToCopyableBuilder<BedrockFoundationModelConfigurationForParsing.Builder, BedrockFoundationModelConfigurationForParsing> {
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelArn").getter(getter(BedrockFoundationModelConfigurationForParsing::modelArn))
            .setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()).build();

    private static final SdkField<ParsingPrompt> PARSING_PROMPT_FIELD = SdkField
            .<ParsingPrompt> builder(MarshallingType.SDK_POJO).memberName("parsingPrompt")
            .getter(getter(BedrockFoundationModelConfigurationForParsing::parsingPrompt)).setter(setter(Builder::parsingPrompt))
            .constructor(ParsingPrompt::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parsingPrompt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ARN_FIELD,
            PARSING_PROMPT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String modelArn;

    private final ParsingPrompt parsingPrompt;

    private BedrockFoundationModelConfigurationForParsing(BuilderImpl builder) {
        this.modelArn = builder.modelArn;
        this.parsingPrompt = builder.parsingPrompt;
    }

    /**
     * <p>
     * The ARN of the foundation model.
     * </p>
     * 
     * @return The ARN of the foundation model.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * Instructions for interpreting the contents of a document.
     * </p>
     * 
     * @return Instructions for interpreting the contents of a document.
     */
    public final ParsingPrompt parsingPrompt() {
        return parsingPrompt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(parsingPrompt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BedrockFoundationModelConfigurationForParsing)) {
            return false;
        }
        BedrockFoundationModelConfigurationForParsing other = (BedrockFoundationModelConfigurationForParsing) obj;
        return Objects.equals(modelArn(), other.modelArn()) && Objects.equals(parsingPrompt(), other.parsingPrompt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BedrockFoundationModelConfigurationForParsing").add("ModelArn", modelArn())
                .add("ParsingPrompt", parsingPrompt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "parsingPrompt":
            return Optional.ofNullable(clazz.cast(parsingPrompt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("modelArn", MODEL_ARN_FIELD);
        map.put("parsingPrompt", PARSING_PROMPT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BedrockFoundationModelConfigurationForParsing, T> g) {
        return obj -> g.apply((BedrockFoundationModelConfigurationForParsing) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BedrockFoundationModelConfigurationForParsing> {
        /**
         * <p>
         * The ARN of the foundation model.
         * </p>
         * 
         * @param modelArn
         *        The ARN of the foundation model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * Instructions for interpreting the contents of a document.
         * </p>
         * 
         * @param parsingPrompt
         *        Instructions for interpreting the contents of a document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parsingPrompt(ParsingPrompt parsingPrompt);

        /**
         * <p>
         * Instructions for interpreting the contents of a document.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParsingPrompt.Builder} avoiding the need
         * to create one manually via {@link ParsingPrompt#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParsingPrompt.Builder#build()} is called immediately and its
         * result is passed to {@link #parsingPrompt(ParsingPrompt)}.
         * 
         * @param parsingPrompt
         *        a consumer that will call methods on {@link ParsingPrompt.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parsingPrompt(ParsingPrompt)
         */
        default Builder parsingPrompt(Consumer<ParsingPrompt.Builder> parsingPrompt) {
            return parsingPrompt(ParsingPrompt.builder().applyMutation(parsingPrompt).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String modelArn;

        private ParsingPrompt parsingPrompt;

        private BuilderImpl() {
        }

        private BuilderImpl(BedrockFoundationModelConfigurationForParsing model) {
            modelArn(model.modelArn);
            parsingPrompt(model.parsingPrompt);
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final ParsingPrompt.Builder getParsingPrompt() {
            return parsingPrompt != null ? parsingPrompt.toBuilder() : null;
        }

        public final void setParsingPrompt(ParsingPrompt.BuilderImpl parsingPrompt) {
            this.parsingPrompt = parsingPrompt != null ? parsingPrompt.build() : null;
        }

        @Override
        public final Builder parsingPrompt(ParsingPrompt parsingPrompt) {
            this.parsingPrompt = parsingPrompt;
            return this;
        }

        @Override
        public BedrockFoundationModelConfigurationForParsing build() {
            return new BedrockFoundationModelConfigurationForParsing(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
