/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data that is output as a result of the assistant association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssistantAssociationOutputData implements SdkPojo, Serializable,
        ToCopyableBuilder<AssistantAssociationOutputData.Builder, AssistantAssociationOutputData> {
    private static final SdkField<KnowledgeBaseAssociationData> KNOWLEDGE_BASE_ASSOCIATION_FIELD = SdkField
            .<KnowledgeBaseAssociationData> builder(MarshallingType.SDK_POJO).memberName("knowledgeBaseAssociation")
            .getter(getter(AssistantAssociationOutputData::knowledgeBaseAssociation))
            .setter(setter(Builder::knowledgeBaseAssociation)).constructor(KnowledgeBaseAssociationData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseAssociation").build())
            .build();

    private static final SdkField<ExternalBedrockKnowledgeBaseConfig> EXTERNAL_BEDROCK_KNOWLEDGE_BASE_CONFIG_FIELD = SdkField
            .<ExternalBedrockKnowledgeBaseConfig> builder(MarshallingType.SDK_POJO)
            .memberName("externalBedrockKnowledgeBaseConfig")
            .getter(getter(AssistantAssociationOutputData::externalBedrockKnowledgeBaseConfig))
            .setter(setter(Builder::externalBedrockKnowledgeBaseConfig))
            .constructor(ExternalBedrockKnowledgeBaseConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalBedrockKnowledgeBaseConfig")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            KNOWLEDGE_BASE_ASSOCIATION_FIELD, EXTERNAL_BEDROCK_KNOWLEDGE_BASE_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final KnowledgeBaseAssociationData knowledgeBaseAssociation;

    private final ExternalBedrockKnowledgeBaseConfig externalBedrockKnowledgeBaseConfig;

    private final Type type;

    private AssistantAssociationOutputData(BuilderImpl builder) {
        this.knowledgeBaseAssociation = builder.knowledgeBaseAssociation;
        this.externalBedrockKnowledgeBaseConfig = builder.externalBedrockKnowledgeBaseConfig;
        this.type = builder.type;
    }

    /**
     * <p>
     * The knowledge base where output data is sent.
     * </p>
     * 
     * @return The knowledge base where output data is sent.
     */
    public final KnowledgeBaseAssociationData knowledgeBaseAssociation() {
        return knowledgeBaseAssociation;
    }

    /**
     * <p>
     * The configuration for an external Bedrock knowledge base association in the output data.
     * </p>
     * 
     * @return The configuration for an external Bedrock knowledge base association in the output data.
     */
    public final ExternalBedrockKnowledgeBaseConfig externalBedrockKnowledgeBaseConfig() {
        return externalBedrockKnowledgeBaseConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseAssociation());
        hashCode = 31 * hashCode + Objects.hashCode(externalBedrockKnowledgeBaseConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssistantAssociationOutputData)) {
            return false;
        }
        AssistantAssociationOutputData other = (AssistantAssociationOutputData) obj;
        return Objects.equals(knowledgeBaseAssociation(), other.knowledgeBaseAssociation())
                && Objects.equals(externalBedrockKnowledgeBaseConfig(), other.externalBedrockKnowledgeBaseConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssistantAssociationOutputData").add("KnowledgeBaseAssociation", knowledgeBaseAssociation())
                .add("ExternalBedrockKnowledgeBaseConfig", externalBedrockKnowledgeBaseConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "knowledgeBaseAssociation":
            return Optional.ofNullable(clazz.cast(knowledgeBaseAssociation()));
        case "externalBedrockKnowledgeBaseConfig":
            return Optional.ofNullable(clazz.cast(externalBedrockKnowledgeBaseConfig()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #knowledgeBaseAssociation()} initialized to the given value.
     *
     * <p>
     * The knowledge base where output data is sent.
     * </p>
     * 
     * @param knowledgeBaseAssociation
     *        The knowledge base where output data is sent.
     */
    public static AssistantAssociationOutputData fromKnowledgeBaseAssociation(
            KnowledgeBaseAssociationData knowledgeBaseAssociation) {
        return builder().knowledgeBaseAssociation(knowledgeBaseAssociation).build();
    }

    /**
     * Create an instance of this class with {@link #knowledgeBaseAssociation()} initialized to the given value.
     *
     * <p>
     * The knowledge base where output data is sent.
     * </p>
     * 
     * @param knowledgeBaseAssociation
     *        The knowledge base where output data is sent.
     */
    public static AssistantAssociationOutputData fromKnowledgeBaseAssociation(
            Consumer<KnowledgeBaseAssociationData.Builder> knowledgeBaseAssociation) {
        KnowledgeBaseAssociationData.Builder builder = KnowledgeBaseAssociationData.builder();
        knowledgeBaseAssociation.accept(builder);
        return fromKnowledgeBaseAssociation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #externalBedrockKnowledgeBaseConfig()} initialized to the given
     * value.
     *
     * <p>
     * The configuration for an external Bedrock knowledge base association in the output data.
     * </p>
     * 
     * @param externalBedrockKnowledgeBaseConfig
     *        The configuration for an external Bedrock knowledge base association in the output data.
     */
    public static AssistantAssociationOutputData fromExternalBedrockKnowledgeBaseConfig(
            ExternalBedrockKnowledgeBaseConfig externalBedrockKnowledgeBaseConfig) {
        return builder().externalBedrockKnowledgeBaseConfig(externalBedrockKnowledgeBaseConfig).build();
    }

    /**
     * Create an instance of this class with {@link #externalBedrockKnowledgeBaseConfig()} initialized to the given
     * value.
     *
     * <p>
     * The configuration for an external Bedrock knowledge base association in the output data.
     * </p>
     * 
     * @param externalBedrockKnowledgeBaseConfig
     *        The configuration for an external Bedrock knowledge base association in the output data.
     */
    public static AssistantAssociationOutputData fromExternalBedrockKnowledgeBaseConfig(
            Consumer<ExternalBedrockKnowledgeBaseConfig.Builder> externalBedrockKnowledgeBaseConfig) {
        ExternalBedrockKnowledgeBaseConfig.Builder builder = ExternalBedrockKnowledgeBaseConfig.builder();
        externalBedrockKnowledgeBaseConfig.accept(builder);
        return fromExternalBedrockKnowledgeBaseConfig(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("knowledgeBaseAssociation", KNOWLEDGE_BASE_ASSOCIATION_FIELD);
        map.put("externalBedrockKnowledgeBaseConfig", EXTERNAL_BEDROCK_KNOWLEDGE_BASE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssistantAssociationOutputData, T> g) {
        return obj -> g.apply((AssistantAssociationOutputData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssistantAssociationOutputData> {
        /**
         * <p>
         * The knowledge base where output data is sent.
         * </p>
         * 
         * @param knowledgeBaseAssociation
         *        The knowledge base where output data is sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseAssociation(KnowledgeBaseAssociationData knowledgeBaseAssociation);

        /**
         * <p>
         * The knowledge base where output data is sent.
         * </p>
         * This is a convenience method that creates an instance of the {@link KnowledgeBaseAssociationData.Builder}
         * avoiding the need to create one manually via {@link KnowledgeBaseAssociationData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KnowledgeBaseAssociationData.Builder#build()} is called
         * immediately and its result is passed to {@link #knowledgeBaseAssociation(KnowledgeBaseAssociationData)}.
         * 
         * @param knowledgeBaseAssociation
         *        a consumer that will call methods on {@link KnowledgeBaseAssociationData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #knowledgeBaseAssociation(KnowledgeBaseAssociationData)
         */
        default Builder knowledgeBaseAssociation(Consumer<KnowledgeBaseAssociationData.Builder> knowledgeBaseAssociation) {
            return knowledgeBaseAssociation(KnowledgeBaseAssociationData.builder().applyMutation(knowledgeBaseAssociation)
                    .build());
        }

        /**
         * <p>
         * The configuration for an external Bedrock knowledge base association in the output data.
         * </p>
         * 
         * @param externalBedrockKnowledgeBaseConfig
         *        The configuration for an external Bedrock knowledge base association in the output data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalBedrockKnowledgeBaseConfig(ExternalBedrockKnowledgeBaseConfig externalBedrockKnowledgeBaseConfig);

        /**
         * <p>
         * The configuration for an external Bedrock knowledge base association in the output data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ExternalBedrockKnowledgeBaseConfig.Builder} avoiding the need to create one manually via
         * {@link ExternalBedrockKnowledgeBaseConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExternalBedrockKnowledgeBaseConfig.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #externalBedrockKnowledgeBaseConfig(ExternalBedrockKnowledgeBaseConfig)}.
         * 
         * @param externalBedrockKnowledgeBaseConfig
         *        a consumer that will call methods on {@link ExternalBedrockKnowledgeBaseConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #externalBedrockKnowledgeBaseConfig(ExternalBedrockKnowledgeBaseConfig)
         */
        default Builder externalBedrockKnowledgeBaseConfig(
                Consumer<ExternalBedrockKnowledgeBaseConfig.Builder> externalBedrockKnowledgeBaseConfig) {
            return externalBedrockKnowledgeBaseConfig(ExternalBedrockKnowledgeBaseConfig.builder()
                    .applyMutation(externalBedrockKnowledgeBaseConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private KnowledgeBaseAssociationData knowledgeBaseAssociation;

        private ExternalBedrockKnowledgeBaseConfig externalBedrockKnowledgeBaseConfig;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AssistantAssociationOutputData model) {
            knowledgeBaseAssociation(model.knowledgeBaseAssociation);
            externalBedrockKnowledgeBaseConfig(model.externalBedrockKnowledgeBaseConfig);
        }

        public final KnowledgeBaseAssociationData.Builder getKnowledgeBaseAssociation() {
            return knowledgeBaseAssociation != null ? knowledgeBaseAssociation.toBuilder() : null;
        }

        public final void setKnowledgeBaseAssociation(KnowledgeBaseAssociationData.BuilderImpl knowledgeBaseAssociation) {
            Object oldValue = this.knowledgeBaseAssociation;
            this.knowledgeBaseAssociation = knowledgeBaseAssociation != null ? knowledgeBaseAssociation.build() : null;
            handleUnionValueChange(Type.KNOWLEDGE_BASE_ASSOCIATION, oldValue, this.knowledgeBaseAssociation);
        }

        @Override
        public final Builder knowledgeBaseAssociation(KnowledgeBaseAssociationData knowledgeBaseAssociation) {
            Object oldValue = this.knowledgeBaseAssociation;
            this.knowledgeBaseAssociation = knowledgeBaseAssociation;
            handleUnionValueChange(Type.KNOWLEDGE_BASE_ASSOCIATION, oldValue, this.knowledgeBaseAssociation);
            return this;
        }

        public final ExternalBedrockKnowledgeBaseConfig.Builder getExternalBedrockKnowledgeBaseConfig() {
            return externalBedrockKnowledgeBaseConfig != null ? externalBedrockKnowledgeBaseConfig.toBuilder() : null;
        }

        public final void setExternalBedrockKnowledgeBaseConfig(
                ExternalBedrockKnowledgeBaseConfig.BuilderImpl externalBedrockKnowledgeBaseConfig) {
            Object oldValue = this.externalBedrockKnowledgeBaseConfig;
            this.externalBedrockKnowledgeBaseConfig = externalBedrockKnowledgeBaseConfig != null ? externalBedrockKnowledgeBaseConfig
                    .build() : null;
            handleUnionValueChange(Type.EXTERNAL_BEDROCK_KNOWLEDGE_BASE_CONFIG, oldValue, this.externalBedrockKnowledgeBaseConfig);
        }

        @Override
        public final Builder externalBedrockKnowledgeBaseConfig(
                ExternalBedrockKnowledgeBaseConfig externalBedrockKnowledgeBaseConfig) {
            Object oldValue = this.externalBedrockKnowledgeBaseConfig;
            this.externalBedrockKnowledgeBaseConfig = externalBedrockKnowledgeBaseConfig;
            handleUnionValueChange(Type.EXTERNAL_BEDROCK_KNOWLEDGE_BASE_CONFIG, oldValue, this.externalBedrockKnowledgeBaseConfig);
            return this;
        }

        @Override
        public AssistantAssociationOutputData build() {
            return new AssistantAssociationOutputData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AssistantAssociationOutputData#type()
     */
    public enum Type {
        KNOWLEDGE_BASE_ASSOCIATION,

        EXTERNAL_BEDROCK_KNOWLEDGE_BASE_CONFIG,

        UNKNOWN_TO_SDK_VERSION
    }
}
