/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum AIPromptType {
    ANSWER_GENERATION("ANSWER_GENERATION"),

    INTENT_LABELING_GENERATION("INTENT_LABELING_GENERATION"),

    QUERY_REFORMULATION("QUERY_REFORMULATION"),

    SELF_SERVICE_PRE_PROCESSING("SELF_SERVICE_PRE_PROCESSING"),

    SELF_SERVICE_ANSWER_GENERATION("SELF_SERVICE_ANSWER_GENERATION"),

    EMAIL_RESPONSE("EMAIL_RESPONSE"),

    EMAIL_OVERVIEW("EMAIL_OVERVIEW"),

    EMAIL_GENERATIVE_ANSWER("EMAIL_GENERATIVE_ANSWER"),

    EMAIL_QUERY_REFORMULATION("EMAIL_QUERY_REFORMULATION"),

    ORCHESTRATION("ORCHESTRATION"),

    NOTE_TAKING("NOTE_TAKING"),

    CASE_SUMMARIZATION("CASE_SUMMARIZATION"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AIPromptType> VALUE_MAP = EnumUtils.uniqueIndex(AIPromptType.class, AIPromptType::toString);

    private final String value;

    private AIPromptType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return AIPromptType corresponding to the value
     */
    public static AIPromptType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link AIPromptType}s
     */
    public static Set<AIPromptType> knownValues() {
        Set<AIPromptType> knownValues = EnumSet.allOf(AIPromptType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
