/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qconnect.model.ChannelSubtype;
import software.amazon.awssdk.services.qconnect.model.GroupingConfiguration;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateAttributeType;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateAttributeTypeListCopier;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateAttributes;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateContentProvider;
import software.amazon.awssdk.services.qconnect.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MessageTemplateData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MessageTemplateData> {
    private static final SdkField<String> MESSAGE_TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("messageTemplateArn").getter(MessageTemplateData.getter(MessageTemplateData::messageTemplateArn)).setter(MessageTemplateData.setter(Builder::messageTemplateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageTemplateArn").build()}).build();
    private static final SdkField<String> MESSAGE_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("messageTemplateId").getter(MessageTemplateData.getter(MessageTemplateData::messageTemplateId)).setter(MessageTemplateData.setter(Builder::messageTemplateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageTemplateId").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseArn").getter(MessageTemplateData.getter(MessageTemplateData::knowledgeBaseArn)).setter(MessageTemplateData.setter(Builder::knowledgeBaseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseArn").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(MessageTemplateData.getter(MessageTemplateData::knowledgeBaseId)).setter(MessageTemplateData.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(MessageTemplateData.getter(MessageTemplateData::name)).setter(MessageTemplateData.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> CHANNEL_SUBTYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("channelSubtype").getter(MessageTemplateData.getter(MessageTemplateData::channelSubtypeAsString)).setter(MessageTemplateData.setter(Builder::channelSubtype)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelSubtype").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTime").getter(MessageTemplateData.getter(MessageTemplateData::createdTime)).setter(MessageTemplateData.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTime").getter(MessageTemplateData.getter(MessageTemplateData::lastModifiedTime)).setter(MessageTemplateData.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastModifiedBy").getter(MessageTemplateData.getter(MessageTemplateData::lastModifiedBy)).setter(MessageTemplateData.setter(Builder::lastModifiedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedBy").build()}).build();
    private static final SdkField<MessageTemplateContentProvider> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("content").getter(MessageTemplateData.getter(MessageTemplateData::content)).setter(MessageTemplateData.setter(Builder::content)).constructor(MessageTemplateContentProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(MessageTemplateData.getter(MessageTemplateData::description)).setter(MessageTemplateData.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("language").getter(MessageTemplateData.getter(MessageTemplateData::language)).setter(MessageTemplateData.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()}).build();
    private static final SdkField<GroupingConfiguration> GROUPING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("groupingConfiguration").getter(MessageTemplateData.getter(MessageTemplateData::groupingConfiguration)).setter(MessageTemplateData.setter(Builder::groupingConfiguration)).constructor(GroupingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupingConfiguration").build()}).build();
    private static final SdkField<MessageTemplateAttributes> DEFAULT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("defaultAttributes").getter(MessageTemplateData.getter(MessageTemplateData::defaultAttributes)).setter(MessageTemplateData.setter(Builder::defaultAttributes)).constructor(MessageTemplateAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultAttributes").build()}).build();
    private static final SdkField<List<String>> ATTRIBUTE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attributeTypes").getter(MessageTemplateData.getter(MessageTemplateData::attributeTypesAsStrings)).setter(MessageTemplateData.setter(Builder::attributeTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MESSAGE_TEMPLATE_CONTENT_SHA256_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("messageTemplateContentSha256").getter(MessageTemplateData.getter(MessageTemplateData::messageTemplateContentSha256)).setter(MessageTemplateData.setter(Builder::messageTemplateContentSha256)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageTemplateContentSha256").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(MessageTemplateData.getter(MessageTemplateData::tags)).setter(MessageTemplateData.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_TEMPLATE_ARN_FIELD, MESSAGE_TEMPLATE_ID_FIELD, KNOWLEDGE_BASE_ARN_FIELD, KNOWLEDGE_BASE_ID_FIELD, NAME_FIELD, CHANNEL_SUBTYPE_FIELD, CREATED_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_BY_FIELD, CONTENT_FIELD, DESCRIPTION_FIELD, LANGUAGE_FIELD, GROUPING_CONFIGURATION_FIELD, DEFAULT_ATTRIBUTES_FIELD, ATTRIBUTE_TYPES_FIELD, MESSAGE_TEMPLATE_CONTENT_SHA256_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MessageTemplateData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String messageTemplateArn;
    private final String messageTemplateId;
    private final String knowledgeBaseArn;
    private final String knowledgeBaseId;
    private final String name;
    private final String channelSubtype;
    private final Instant createdTime;
    private final Instant lastModifiedTime;
    private final String lastModifiedBy;
    private final MessageTemplateContentProvider content;
    private final String description;
    private final String language;
    private final GroupingConfiguration groupingConfiguration;
    private final MessageTemplateAttributes defaultAttributes;
    private final List<String> attributeTypes;
    private final String messageTemplateContentSha256;
    private final Map<String, String> tags;

    private MessageTemplateData(BuilderImpl builder) {
        this.messageTemplateArn = builder.messageTemplateArn;
        this.messageTemplateId = builder.messageTemplateId;
        this.knowledgeBaseArn = builder.knowledgeBaseArn;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.name = builder.name;
        this.channelSubtype = builder.channelSubtype;
        this.createdTime = builder.createdTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.content = builder.content;
        this.description = builder.description;
        this.language = builder.language;
        this.groupingConfiguration = builder.groupingConfiguration;
        this.defaultAttributes = builder.defaultAttributes;
        this.attributeTypes = builder.attributeTypes;
        this.messageTemplateContentSha256 = builder.messageTemplateContentSha256;
        this.tags = builder.tags;
    }

    public final String messageTemplateArn() {
        return this.messageTemplateArn;
    }

    public final String messageTemplateId() {
        return this.messageTemplateId;
    }

    public final String knowledgeBaseArn() {
        return this.knowledgeBaseArn;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final String name() {
        return this.name;
    }

    public final ChannelSubtype channelSubtype() {
        return ChannelSubtype.fromValue(this.channelSubtype);
    }

    public final String channelSubtypeAsString() {
        return this.channelSubtype;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public final MessageTemplateContentProvider content() {
        return this.content;
    }

    public final String description() {
        return this.description;
    }

    public final String language() {
        return this.language;
    }

    public final GroupingConfiguration groupingConfiguration() {
        return this.groupingConfiguration;
    }

    public final MessageTemplateAttributes defaultAttributes() {
        return this.defaultAttributes;
    }

    public final List<MessageTemplateAttributeType> attributeTypes() {
        return MessageTemplateAttributeTypeListCopier.copyStringToEnum(this.attributeTypes);
    }

    public final boolean hasAttributeTypes() {
        return this.attributeTypes != null && !(this.attributeTypes instanceof SdkAutoConstructList);
    }

    public final List<String> attributeTypesAsStrings() {
        return this.attributeTypes;
    }

    public final String messageTemplateContentSha256() {
        return this.messageTemplateContentSha256;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.messageTemplateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelSubtypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.language());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeTypes() ? this.attributeTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.messageTemplateContentSha256());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageTemplateData)) {
            return false;
        }
        MessageTemplateData other = (MessageTemplateData)obj;
        return Objects.equals(this.messageTemplateArn(), other.messageTemplateArn()) && Objects.equals(this.messageTemplateId(), other.messageTemplateId()) && Objects.equals(this.knowledgeBaseArn(), other.knowledgeBaseArn()) && Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.channelSubtypeAsString(), other.channelSubtypeAsString()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.language(), other.language()) && Objects.equals(this.groupingConfiguration(), other.groupingConfiguration()) && Objects.equals(this.defaultAttributes(), other.defaultAttributes()) && this.hasAttributeTypes() == other.hasAttributeTypes() && Objects.equals(this.attributeTypesAsStrings(), other.attributeTypesAsStrings()) && Objects.equals(this.messageTemplateContentSha256(), other.messageTemplateContentSha256()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"MessageTemplateData").add("MessageTemplateArn", (Object)this.messageTemplateArn()).add("MessageTemplateId", (Object)this.messageTemplateId()).add("KnowledgeBaseArn", (Object)this.knowledgeBaseArn()).add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("Name", (Object)this.name()).add("ChannelSubtype", (Object)this.channelSubtypeAsString()).add("CreatedTime", (Object)this.createdTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastModifiedBy", (Object)this.lastModifiedBy()).add("Content", (Object)this.content()).add("Description", (Object)this.description()).add("Language", (Object)this.language()).add("GroupingConfiguration", (Object)this.groupingConfiguration()).add("DefaultAttributes", (Object)this.defaultAttributes()).add("AttributeTypes", this.hasAttributeTypes() ? this.attributeTypesAsStrings() : null).add("MessageTemplateContentSha256", (Object)this.messageTemplateContentSha256()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "messageTemplateArn": {
                return Optional.ofNullable(clazz.cast(this.messageTemplateArn()));
            }
            case "messageTemplateId": {
                return Optional.ofNullable(clazz.cast(this.messageTemplateId()));
            }
            case "knowledgeBaseArn": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseArn()));
            }
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "channelSubtype": {
                return Optional.ofNullable(clazz.cast(this.channelSubtypeAsString()));
            }
            case "createdTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "lastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "language": {
                return Optional.ofNullable(clazz.cast(this.language()));
            }
            case "groupingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.groupingConfiguration()));
            }
            case "defaultAttributes": {
                return Optional.ofNullable(clazz.cast(this.defaultAttributes()));
            }
            case "attributeTypes": {
                return Optional.ofNullable(clazz.cast(this.attributeTypesAsStrings()));
            }
            case "messageTemplateContentSha256": {
                return Optional.ofNullable(clazz.cast(this.messageTemplateContentSha256()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("messageTemplateArn", MESSAGE_TEMPLATE_ARN_FIELD);
        map.put("messageTemplateId", MESSAGE_TEMPLATE_ID_FIELD);
        map.put("knowledgeBaseArn", KNOWLEDGE_BASE_ARN_FIELD);
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("channelSubtype", CHANNEL_SUBTYPE_FIELD);
        map.put("createdTime", CREATED_TIME_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("lastModifiedBy", LAST_MODIFIED_BY_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("language", LANGUAGE_FIELD);
        map.put("groupingConfiguration", GROUPING_CONFIGURATION_FIELD);
        map.put("defaultAttributes", DEFAULT_ATTRIBUTES_FIELD);
        map.put("attributeTypes", ATTRIBUTE_TYPES_FIELD);
        map.put("messageTemplateContentSha256", MESSAGE_TEMPLATE_CONTENT_SHA256_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MessageTemplateData, T> g) {
        return obj -> g.apply((MessageTemplateData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String messageTemplateArn;
        private String messageTemplateId;
        private String knowledgeBaseArn;
        private String knowledgeBaseId;
        private String name;
        private String channelSubtype;
        private Instant createdTime;
        private Instant lastModifiedTime;
        private String lastModifiedBy;
        private MessageTemplateContentProvider content;
        private String description;
        private String language;
        private GroupingConfiguration groupingConfiguration;
        private MessageTemplateAttributes defaultAttributes;
        private List<String> attributeTypes = DefaultSdkAutoConstructList.getInstance();
        private String messageTemplateContentSha256;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MessageTemplateData model) {
            this.messageTemplateArn(model.messageTemplateArn);
            this.messageTemplateId(model.messageTemplateId);
            this.knowledgeBaseArn(model.knowledgeBaseArn);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.name(model.name);
            this.channelSubtype(model.channelSubtype);
            this.createdTime(model.createdTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastModifiedBy(model.lastModifiedBy);
            this.content(model.content);
            this.description(model.description);
            this.language(model.language);
            this.groupingConfiguration(model.groupingConfiguration);
            this.defaultAttributes(model.defaultAttributes);
            this.attributeTypesWithStrings(model.attributeTypes);
            this.messageTemplateContentSha256(model.messageTemplateContentSha256);
            this.tags(model.tags);
        }

        public final String getMessageTemplateArn() {
            return this.messageTemplateArn;
        }

        public final void setMessageTemplateArn(String messageTemplateArn) {
            this.messageTemplateArn = messageTemplateArn;
        }

        @Override
        public final Builder messageTemplateArn(String messageTemplateArn) {
            this.messageTemplateArn = messageTemplateArn;
            return this;
        }

        public final String getMessageTemplateId() {
            return this.messageTemplateId;
        }

        public final void setMessageTemplateId(String messageTemplateId) {
            this.messageTemplateId = messageTemplateId;
        }

        @Override
        public final Builder messageTemplateId(String messageTemplateId) {
            this.messageTemplateId = messageTemplateId;
            return this;
        }

        public final String getKnowledgeBaseArn() {
            return this.knowledgeBaseArn;
        }

        public final void setKnowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
        }

        @Override
        public final Builder knowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getChannelSubtype() {
            return this.channelSubtype;
        }

        public final void setChannelSubtype(String channelSubtype) {
            this.channelSubtype = channelSubtype;
        }

        @Override
        public final Builder channelSubtype(String channelSubtype) {
            this.channelSubtype = channelSubtype;
            return this;
        }

        @Override
        public final Builder channelSubtype(ChannelSubtype channelSubtype) {
            this.channelSubtype(channelSubtype == null ? null : channelSubtype.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final MessageTemplateContentProvider.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        public final void setContent(MessageTemplateContentProvider.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(MessageTemplateContentProvider content) {
            this.content = content;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final GroupingConfiguration.Builder getGroupingConfiguration() {
            return this.groupingConfiguration != null ? this.groupingConfiguration.toBuilder() : null;
        }

        public final void setGroupingConfiguration(GroupingConfiguration.BuilderImpl groupingConfiguration) {
            this.groupingConfiguration = groupingConfiguration != null ? groupingConfiguration.build() : null;
        }

        @Override
        public final Builder groupingConfiguration(GroupingConfiguration groupingConfiguration) {
            this.groupingConfiguration = groupingConfiguration;
            return this;
        }

        public final MessageTemplateAttributes.Builder getDefaultAttributes() {
            return this.defaultAttributes != null ? this.defaultAttributes.toBuilder() : null;
        }

        public final void setDefaultAttributes(MessageTemplateAttributes.BuilderImpl defaultAttributes) {
            this.defaultAttributes = defaultAttributes != null ? defaultAttributes.build() : null;
        }

        @Override
        public final Builder defaultAttributes(MessageTemplateAttributes defaultAttributes) {
            this.defaultAttributes = defaultAttributes;
            return this;
        }

        public final Collection<String> getAttributeTypes() {
            if (this.attributeTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributeTypes;
        }

        public final void setAttributeTypes(Collection<String> attributeTypes) {
            this.attributeTypes = MessageTemplateAttributeTypeListCopier.copy(attributeTypes);
        }

        @Override
        public final Builder attributeTypesWithStrings(Collection<String> attributeTypes) {
            this.attributeTypes = MessageTemplateAttributeTypeListCopier.copy(attributeTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeTypesWithStrings(String ... attributeTypes) {
            this.attributeTypesWithStrings(Arrays.asList(attributeTypes));
            return this;
        }

        @Override
        public final Builder attributeTypes(Collection<MessageTemplateAttributeType> attributeTypes) {
            this.attributeTypes = MessageTemplateAttributeTypeListCopier.copyEnumToString(attributeTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeTypes(MessageTemplateAttributeType ... attributeTypes) {
            this.attributeTypes(Arrays.asList(attributeTypes));
            return this;
        }

        public final String getMessageTemplateContentSha256() {
            return this.messageTemplateContentSha256;
        }

        public final void setMessageTemplateContentSha256(String messageTemplateContentSha256) {
            this.messageTemplateContentSha256 = messageTemplateContentSha256;
        }

        @Override
        public final Builder messageTemplateContentSha256(String messageTemplateContentSha256) {
            this.messageTemplateContentSha256 = messageTemplateContentSha256;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public MessageTemplateData build() {
            return new MessageTemplateData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MessageTemplateData> {
        public Builder messageTemplateArn(String var1);

        public Builder messageTemplateId(String var1);

        public Builder knowledgeBaseArn(String var1);

        public Builder knowledgeBaseId(String var1);

        public Builder name(String var1);

        public Builder channelSubtype(String var1);

        public Builder channelSubtype(ChannelSubtype var1);

        public Builder createdTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder lastModifiedBy(String var1);

        public Builder content(MessageTemplateContentProvider var1);

        default public Builder content(Consumer<MessageTemplateContentProvider.Builder> content) {
            return this.content((MessageTemplateContentProvider)((MessageTemplateContentProvider.Builder)MessageTemplateContentProvider.builder().applyMutation(content)).build());
        }

        public Builder description(String var1);

        public Builder language(String var1);

        public Builder groupingConfiguration(GroupingConfiguration var1);

        default public Builder groupingConfiguration(Consumer<GroupingConfiguration.Builder> groupingConfiguration) {
            return this.groupingConfiguration((GroupingConfiguration)((GroupingConfiguration.Builder)GroupingConfiguration.builder().applyMutation(groupingConfiguration)).build());
        }

        public Builder defaultAttributes(MessageTemplateAttributes var1);

        default public Builder defaultAttributes(Consumer<MessageTemplateAttributes.Builder> defaultAttributes) {
            return this.defaultAttributes((MessageTemplateAttributes)((MessageTemplateAttributes.Builder)MessageTemplateAttributes.builder().applyMutation(defaultAttributes)).build());
        }

        public Builder attributeTypesWithStrings(Collection<String> var1);

        public Builder attributeTypesWithStrings(String ... var1);

        public Builder attributeTypes(Collection<MessageTemplateAttributeType> var1);

        public Builder attributeTypes(MessageTemplateAttributeType ... var1);

        public Builder messageTemplateContentSha256(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

