/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateVersionSummary;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateVersionSummaryListCopier;
import software.amazon.awssdk.services.qconnect.model.QConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMessageTemplateVersionsResponse
extends QConnectResponse
implements ToCopyableBuilder<Builder, ListMessageTemplateVersionsResponse> {
    private static final SdkField<List<MessageTemplateVersionSummary>> MESSAGE_TEMPLATE_VERSION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("messageTemplateVersionSummaries").getter(ListMessageTemplateVersionsResponse.getter(ListMessageTemplateVersionsResponse::messageTemplateVersionSummaries)).setter(ListMessageTemplateVersionsResponse.setter(Builder::messageTemplateVersionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageTemplateVersionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageTemplateVersionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListMessageTemplateVersionsResponse.getter(ListMessageTemplateVersionsResponse::nextToken)).setter(ListMessageTemplateVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_TEMPLATE_VERSION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListMessageTemplateVersionsResponse.memberNameToFieldInitializer();
    private final List<MessageTemplateVersionSummary> messageTemplateVersionSummaries;
    private final String nextToken;

    private ListMessageTemplateVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.messageTemplateVersionSummaries = builder.messageTemplateVersionSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMessageTemplateVersionSummaries() {
        return this.messageTemplateVersionSummaries != null && !(this.messageTemplateVersionSummaries instanceof SdkAutoConstructList);
    }

    public final List<MessageTemplateVersionSummary> messageTemplateVersionSummaries() {
        return this.messageTemplateVersionSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessageTemplateVersionSummaries() ? this.messageTemplateVersionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMessageTemplateVersionsResponse)) {
            return false;
        }
        ListMessageTemplateVersionsResponse other = (ListMessageTemplateVersionsResponse)((Object)obj);
        return this.hasMessageTemplateVersionSummaries() == other.hasMessageTemplateVersionSummaries() && Objects.equals(this.messageTemplateVersionSummaries(), other.messageTemplateVersionSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListMessageTemplateVersionsResponse").add("MessageTemplateVersionSummaries", this.hasMessageTemplateVersionSummaries() ? this.messageTemplateVersionSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "messageTemplateVersionSummaries": {
                return Optional.ofNullable(clazz.cast(this.messageTemplateVersionSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("messageTemplateVersionSummaries", MESSAGE_TEMPLATE_VERSION_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMessageTemplateVersionsResponse, T> g) {
        return obj -> g.apply((ListMessageTemplateVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectResponse.BuilderImpl
    implements Builder {
        private List<MessageTemplateVersionSummary> messageTemplateVersionSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMessageTemplateVersionsResponse model) {
            super(model);
            this.messageTemplateVersionSummaries(model.messageTemplateVersionSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<MessageTemplateVersionSummary.Builder> getMessageTemplateVersionSummaries() {
            List<MessageTemplateVersionSummary.Builder> result = MessageTemplateVersionSummaryListCopier.copyToBuilder(this.messageTemplateVersionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessageTemplateVersionSummaries(Collection<MessageTemplateVersionSummary.BuilderImpl> messageTemplateVersionSummaries) {
            this.messageTemplateVersionSummaries = MessageTemplateVersionSummaryListCopier.copyFromBuilder(messageTemplateVersionSummaries);
        }

        @Override
        public final Builder messageTemplateVersionSummaries(Collection<MessageTemplateVersionSummary> messageTemplateVersionSummaries) {
            this.messageTemplateVersionSummaries = MessageTemplateVersionSummaryListCopier.copy(messageTemplateVersionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageTemplateVersionSummaries(MessageTemplateVersionSummary ... messageTemplateVersionSummaries) {
            this.messageTemplateVersionSummaries(Arrays.asList(messageTemplateVersionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageTemplateVersionSummaries(Consumer<MessageTemplateVersionSummary.Builder> ... messageTemplateVersionSummaries) {
            this.messageTemplateVersionSummaries(Stream.of(messageTemplateVersionSummaries).map(c -> (MessageTemplateVersionSummary)((MessageTemplateVersionSummary.Builder)MessageTemplateVersionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMessageTemplateVersionsResponse build() {
            return new ListMessageTemplateVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMessageTemplateVersionsResponse> {
        public Builder messageTemplateVersionSummaries(Collection<MessageTemplateVersionSummary> var1);

        public Builder messageTemplateVersionSummaries(MessageTemplateVersionSummary ... var1);

        public Builder messageTemplateVersionSummaries(Consumer<MessageTemplateVersionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

