/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.AssistantAssociationSummary;
import software.amazon.awssdk.services.qconnect.model.AssistantAssociationSummaryListCopier;
import software.amazon.awssdk.services.qconnect.model.QConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssistantAssociationsResponse
extends QConnectResponse
implements ToCopyableBuilder<Builder, ListAssistantAssociationsResponse> {
    private static final SdkField<List<AssistantAssociationSummary>> ASSISTANT_ASSOCIATION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assistantAssociationSummaries").getter(ListAssistantAssociationsResponse.getter(ListAssistantAssociationsResponse::assistantAssociationSummaries)).setter(ListAssistantAssociationsResponse.setter(Builder::assistantAssociationSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantAssociationSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssistantAssociationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAssistantAssociationsResponse.getter(ListAssistantAssociationsResponse::nextToken)).setter(ListAssistantAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_ASSOCIATION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAssistantAssociationsResponse.memberNameToFieldInitializer();
    private final List<AssistantAssociationSummary> assistantAssociationSummaries;
    private final String nextToken;

    private ListAssistantAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.assistantAssociationSummaries = builder.assistantAssociationSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAssistantAssociationSummaries() {
        return this.assistantAssociationSummaries != null && !(this.assistantAssociationSummaries instanceof SdkAutoConstructList);
    }

    public final List<AssistantAssociationSummary> assistantAssociationSummaries() {
        return this.assistantAssociationSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssistantAssociationSummaries() ? this.assistantAssociationSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssistantAssociationsResponse)) {
            return false;
        }
        ListAssistantAssociationsResponse other = (ListAssistantAssociationsResponse)((Object)obj);
        return this.hasAssistantAssociationSummaries() == other.hasAssistantAssociationSummaries() && Objects.equals(this.assistantAssociationSummaries(), other.assistantAssociationSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAssistantAssociationsResponse").add("AssistantAssociationSummaries", this.hasAssistantAssociationSummaries() ? this.assistantAssociationSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assistantAssociationSummaries": {
                return Optional.ofNullable(clazz.cast(this.assistantAssociationSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assistantAssociationSummaries", ASSISTANT_ASSOCIATION_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAssistantAssociationsResponse, T> g) {
        return obj -> g.apply((ListAssistantAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectResponse.BuilderImpl
    implements Builder {
        private List<AssistantAssociationSummary> assistantAssociationSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssistantAssociationsResponse model) {
            super(model);
            this.assistantAssociationSummaries(model.assistantAssociationSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<AssistantAssociationSummary.Builder> getAssistantAssociationSummaries() {
            List<AssistantAssociationSummary.Builder> result = AssistantAssociationSummaryListCopier.copyToBuilder(this.assistantAssociationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssistantAssociationSummaries(Collection<AssistantAssociationSummary.BuilderImpl> assistantAssociationSummaries) {
            this.assistantAssociationSummaries = AssistantAssociationSummaryListCopier.copyFromBuilder(assistantAssociationSummaries);
        }

        @Override
        public final Builder assistantAssociationSummaries(Collection<AssistantAssociationSummary> assistantAssociationSummaries) {
            this.assistantAssociationSummaries = AssistantAssociationSummaryListCopier.copy(assistantAssociationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assistantAssociationSummaries(AssistantAssociationSummary ... assistantAssociationSummaries) {
            this.assistantAssociationSummaries(Arrays.asList(assistantAssociationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assistantAssociationSummaries(Consumer<AssistantAssociationSummary.Builder> ... assistantAssociationSummaries) {
            this.assistantAssociationSummaries(Stream.of(assistantAssociationSummaries).map(c -> (AssistantAssociationSummary)((AssistantAssociationSummary.Builder)AssistantAssociationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAssistantAssociationsResponse build() {
            return new ListAssistantAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssistantAssociationsResponse> {
        public Builder assistantAssociationSummaries(Collection<AssistantAssociationSummary> var1);

        public Builder assistantAssociationSummaries(AssistantAssociationSummary ... var1);

        public Builder assistantAssociationSummaries(Consumer<AssistantAssociationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

