/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qconnect.model.AndConditionsCopier;
import software.amazon.awssdk.services.qconnect.model.TagCondition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrCondition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrCondition> {
    private static final SdkField<List<TagCondition>> AND_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("andConditions").getter(OrCondition.getter(OrCondition::andConditions)).setter(OrCondition.setter(Builder::andConditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("andConditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TagCondition> TAG_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tagCondition").getter(OrCondition.getter(OrCondition::tagCondition)).setter(OrCondition.setter(Builder::tagCondition)).constructor(TagCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagCondition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AND_CONDITIONS_FIELD, TAG_CONDITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("andConditions", AND_CONDITIONS_FIELD);
            this.put("tagCondition", TAG_CONDITION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<TagCondition> andConditions;
    private final TagCondition tagCondition;
    private final Type type;

    private OrCondition(BuilderImpl builder) {
        this.andConditions = builder.andConditions;
        this.tagCondition = builder.tagCondition;
        this.type = builder.type;
    }

    public final boolean hasAndConditions() {
        return this.andConditions != null && !(this.andConditions instanceof SdkAutoConstructList);
    }

    public final List<TagCondition> andConditions() {
        return this.andConditions;
    }

    public final TagCondition tagCondition() {
        return this.tagCondition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAndConditions() ? this.andConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tagCondition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrCondition)) {
            return false;
        }
        OrCondition other = (OrCondition)obj;
        return this.hasAndConditions() == other.hasAndConditions() && Objects.equals(this.andConditions(), other.andConditions()) && Objects.equals(this.tagCondition(), other.tagCondition());
    }

    public final String toString() {
        return ToString.builder((String)"OrCondition").add("AndConditions", this.hasAndConditions() ? this.andConditions() : null).add("TagCondition", (Object)this.tagCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "andConditions": {
                return Optional.ofNullable(clazz.cast(this.andConditions()));
            }
            case "tagCondition": {
                return Optional.ofNullable(clazz.cast(this.tagCondition()));
            }
        }
        return Optional.empty();
    }

    public static OrCondition fromAndConditions(List<TagCondition> andConditions) {
        return (OrCondition)OrCondition.builder().andConditions(andConditions).build();
    }

    public static OrCondition fromTagCondition(TagCondition tagCondition) {
        return (OrCondition)OrCondition.builder().tagCondition(tagCondition).build();
    }

    public static OrCondition fromTagCondition(Consumer<TagCondition.Builder> tagCondition) {
        TagCondition.Builder builder = TagCondition.builder();
        tagCondition.accept(builder);
        return OrCondition.fromTagCondition((TagCondition)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OrCondition, T> g) {
        return obj -> g.apply((OrCondition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        AND_CONDITIONS,
        TAG_CONDITION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<TagCondition> andConditions = DefaultSdkAutoConstructList.getInstance();
        private TagCondition tagCondition;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(OrCondition model) {
            this.andConditions(model.andConditions);
            this.tagCondition(model.tagCondition);
        }

        public final List<TagCondition.Builder> getAndConditions() {
            List<TagCondition.Builder> result = AndConditionsCopier.copyToBuilder(this.andConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAndConditions(Collection<TagCondition.BuilderImpl> andConditions) {
            List<TagCondition> oldValue = this.andConditions;
            this.andConditions = AndConditionsCopier.copyFromBuilder(andConditions);
            this.handleUnionValueChange(Type.AND_CONDITIONS, oldValue, this.andConditions);
        }

        @Override
        public final Builder andConditions(Collection<TagCondition> andConditions) {
            List<TagCondition> oldValue = this.andConditions;
            this.andConditions = AndConditionsCopier.copy(andConditions);
            this.handleUnionValueChange(Type.AND_CONDITIONS, oldValue, this.andConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andConditions(TagCondition ... andConditions) {
            this.andConditions(Arrays.asList(andConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andConditions(Consumer<TagCondition.Builder> ... andConditions) {
            this.andConditions(Stream.of(andConditions).map(c -> (TagCondition)((TagCondition.Builder)TagCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TagCondition.Builder getTagCondition() {
            return this.tagCondition != null ? this.tagCondition.toBuilder() : null;
        }

        public final void setTagCondition(TagCondition.BuilderImpl tagCondition) {
            TagCondition oldValue = this.tagCondition;
            this.tagCondition = tagCondition != null ? tagCondition.build() : null;
            this.handleUnionValueChange(Type.TAG_CONDITION, oldValue, this.tagCondition);
        }

        @Override
        public final Builder tagCondition(TagCondition tagCondition) {
            TagCondition oldValue = this.tagCondition;
            this.tagCondition = tagCondition;
            this.handleUnionValueChange(Type.TAG_CONDITION, oldValue, this.tagCondition);
            return this;
        }

        public OrCondition build() {
            return new OrCondition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrCondition> {
        public Builder andConditions(Collection<TagCondition> var1);

        public Builder andConditions(TagCondition ... var1);

        public Builder andConditions(Consumer<TagCondition.Builder> ... var1);

        public Builder tagCondition(TagCondition var1);

        default public Builder tagCondition(Consumer<TagCondition.Builder> tagCondition) {
            return this.tagCondition((TagCondition)((TagCondition.Builder)TagCondition.builder().applyMutation(tagCondition)).build());
        }
    }
}

