/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.AIPromptTemplateConfiguration;
import software.amazon.awssdk.services.qconnect.model.QConnectRequest;
import software.amazon.awssdk.services.qconnect.model.VisibilityStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAiPromptRequest
extends QConnectRequest
implements ToCopyableBuilder<Builder, UpdateAiPromptRequest> {
    private static final SdkField<String> AI_PROMPT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aiPromptId").getter(UpdateAiPromptRequest.getter(UpdateAiPromptRequest::aiPromptId)).setter(UpdateAiPromptRequest.setter(Builder::aiPromptId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("aiPromptId").build()}).build();
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantId").getter(UpdateAiPromptRequest.getter(UpdateAiPromptRequest::assistantId)).setter(UpdateAiPromptRequest.setter(Builder::assistantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateAiPromptRequest.getter(UpdateAiPromptRequest::clientToken)).setter(UpdateAiPromptRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateAiPromptRequest.getter(UpdateAiPromptRequest::description)).setter(UpdateAiPromptRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<AIPromptTemplateConfiguration> TEMPLATE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("templateConfiguration").getter(UpdateAiPromptRequest.getter(UpdateAiPromptRequest::templateConfiguration)).setter(UpdateAiPromptRequest.setter(Builder::templateConfiguration)).constructor(AIPromptTemplateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateConfiguration").build()}).build();
    private static final SdkField<String> VISIBILITY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("visibilityStatus").getter(UpdateAiPromptRequest.getter(UpdateAiPromptRequest::visibilityStatusAsString)).setter(UpdateAiPromptRequest.setter(Builder::visibilityStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("visibilityStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AI_PROMPT_ID_FIELD, ASSISTANT_ID_FIELD, CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, TEMPLATE_CONFIGURATION_FIELD, VISIBILITY_STATUS_FIELD));
    private final String aiPromptId;
    private final String assistantId;
    private final String clientToken;
    private final String description;
    private final AIPromptTemplateConfiguration templateConfiguration;
    private final String visibilityStatus;

    private UpdateAiPromptRequest(BuilderImpl builder) {
        super(builder);
        this.aiPromptId = builder.aiPromptId;
        this.assistantId = builder.assistantId;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.templateConfiguration = builder.templateConfiguration;
        this.visibilityStatus = builder.visibilityStatus;
    }

    public final String aiPromptId() {
        return this.aiPromptId;
    }

    public final String assistantId() {
        return this.assistantId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final AIPromptTemplateConfiguration templateConfiguration() {
        return this.templateConfiguration;
    }

    public final VisibilityStatus visibilityStatus() {
        return VisibilityStatus.fromValue(this.visibilityStatus);
    }

    public final String visibilityStatusAsString() {
        return this.visibilityStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.aiPromptId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAiPromptRequest)) {
            return false;
        }
        UpdateAiPromptRequest other = (UpdateAiPromptRequest)((Object)obj);
        return Objects.equals(this.aiPromptId(), other.aiPromptId()) && Objects.equals(this.assistantId(), other.assistantId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.templateConfiguration(), other.templateConfiguration()) && Objects.equals(this.visibilityStatusAsString(), other.visibilityStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAiPromptRequest").add("AiPromptId", (Object)this.aiPromptId()).add("AssistantId", (Object)this.assistantId()).add("ClientToken", (Object)this.clientToken()).add("Description", (Object)this.description()).add("TemplateConfiguration", (Object)this.templateConfiguration()).add("VisibilityStatus", (Object)this.visibilityStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "aiPromptId": {
                return Optional.ofNullable(clazz.cast(this.aiPromptId()));
            }
            case "assistantId": {
                return Optional.ofNullable(clazz.cast(this.assistantId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "templateConfiguration": {
                return Optional.ofNullable(clazz.cast(this.templateConfiguration()));
            }
            case "visibilityStatus": {
                return Optional.ofNullable(clazz.cast(this.visibilityStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAiPromptRequest, T> g) {
        return obj -> g.apply((UpdateAiPromptRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectRequest.BuilderImpl
    implements Builder {
        private String aiPromptId;
        private String assistantId;
        private String clientToken;
        private String description;
        private AIPromptTemplateConfiguration templateConfiguration;
        private String visibilityStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAiPromptRequest model) {
            super(model);
            this.aiPromptId(model.aiPromptId);
            this.assistantId(model.assistantId);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.templateConfiguration(model.templateConfiguration);
            this.visibilityStatus(model.visibilityStatus);
        }

        public final String getAiPromptId() {
            return this.aiPromptId;
        }

        public final void setAiPromptId(String aiPromptId) {
            this.aiPromptId = aiPromptId;
        }

        @Override
        public final Builder aiPromptId(String aiPromptId) {
            this.aiPromptId = aiPromptId;
            return this;
        }

        public final String getAssistantId() {
            return this.assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final AIPromptTemplateConfiguration.Builder getTemplateConfiguration() {
            return this.templateConfiguration != null ? this.templateConfiguration.toBuilder() : null;
        }

        public final void setTemplateConfiguration(AIPromptTemplateConfiguration.BuilderImpl templateConfiguration) {
            this.templateConfiguration = templateConfiguration != null ? templateConfiguration.build() : null;
        }

        @Override
        public final Builder templateConfiguration(AIPromptTemplateConfiguration templateConfiguration) {
            this.templateConfiguration = templateConfiguration;
            return this;
        }

        public final String getVisibilityStatus() {
            return this.visibilityStatus;
        }

        public final void setVisibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
        }

        @Override
        public final Builder visibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
            return this;
        }

        @Override
        public final Builder visibilityStatus(VisibilityStatus visibilityStatus) {
            this.visibilityStatus(visibilityStatus == null ? null : visibilityStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAiPromptRequest build() {
            return new UpdateAiPromptRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAiPromptRequest> {
        public Builder aiPromptId(String var1);

        public Builder assistantId(String var1);

        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder templateConfiguration(AIPromptTemplateConfiguration var1);

        default public Builder templateConfiguration(Consumer<AIPromptTemplateConfiguration.Builder> templateConfiguration) {
            return this.templateConfiguration((AIPromptTemplateConfiguration)((AIPromptTemplateConfiguration.Builder)AIPromptTemplateConfiguration.builder().applyMutation(templateConfiguration)).build());
        }

        public Builder visibilityStatus(String var1);

        public Builder visibilityStatus(VisibilityStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

