/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.AIPromptVersionSummariesListCopier;
import software.amazon.awssdk.services.qconnect.model.AIPromptVersionSummary;
import software.amazon.awssdk.services.qconnect.model.QConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAiPromptVersionsResponse
extends QConnectResponse
implements ToCopyableBuilder<Builder, ListAiPromptVersionsResponse> {
    private static final SdkField<List<AIPromptVersionSummary>> AI_PROMPT_VERSION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("aiPromptVersionSummaries").getter(ListAiPromptVersionsResponse.getter(ListAiPromptVersionsResponse::aiPromptVersionSummaries)).setter(ListAiPromptVersionsResponse.setter(Builder::aiPromptVersionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiPromptVersionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AIPromptVersionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAiPromptVersionsResponse.getter(ListAiPromptVersionsResponse::nextToken)).setter(ListAiPromptVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AI_PROMPT_VERSION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<AIPromptVersionSummary> aiPromptVersionSummaries;
    private final String nextToken;

    private ListAiPromptVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.aiPromptVersionSummaries = builder.aiPromptVersionSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAiPromptVersionSummaries() {
        return this.aiPromptVersionSummaries != null && !(this.aiPromptVersionSummaries instanceof SdkAutoConstructList);
    }

    public final List<AIPromptVersionSummary> aiPromptVersionSummaries() {
        return this.aiPromptVersionSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAiPromptVersionSummaries() ? this.aiPromptVersionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAiPromptVersionsResponse)) {
            return false;
        }
        ListAiPromptVersionsResponse other = (ListAiPromptVersionsResponse)((Object)obj);
        return this.hasAiPromptVersionSummaries() == other.hasAiPromptVersionSummaries() && Objects.equals(this.aiPromptVersionSummaries(), other.aiPromptVersionSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAiPromptVersionsResponse").add("AiPromptVersionSummaries", this.hasAiPromptVersionSummaries() ? this.aiPromptVersionSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "aiPromptVersionSummaries": {
                return Optional.ofNullable(clazz.cast(this.aiPromptVersionSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAiPromptVersionsResponse, T> g) {
        return obj -> g.apply((ListAiPromptVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectResponse.BuilderImpl
    implements Builder {
        private List<AIPromptVersionSummary> aiPromptVersionSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAiPromptVersionsResponse model) {
            super(model);
            this.aiPromptVersionSummaries(model.aiPromptVersionSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<AIPromptVersionSummary.Builder> getAiPromptVersionSummaries() {
            List<AIPromptVersionSummary.Builder> result = AIPromptVersionSummariesListCopier.copyToBuilder(this.aiPromptVersionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAiPromptVersionSummaries(Collection<AIPromptVersionSummary.BuilderImpl> aiPromptVersionSummaries) {
            this.aiPromptVersionSummaries = AIPromptVersionSummariesListCopier.copyFromBuilder(aiPromptVersionSummaries);
        }

        @Override
        public final Builder aiPromptVersionSummaries(Collection<AIPromptVersionSummary> aiPromptVersionSummaries) {
            this.aiPromptVersionSummaries = AIPromptVersionSummariesListCopier.copy(aiPromptVersionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aiPromptVersionSummaries(AIPromptVersionSummary ... aiPromptVersionSummaries) {
            this.aiPromptVersionSummaries(Arrays.asList(aiPromptVersionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aiPromptVersionSummaries(Consumer<AIPromptVersionSummary.Builder> ... aiPromptVersionSummaries) {
            this.aiPromptVersionSummaries(Stream.of(aiPromptVersionSummaries).map(c -> (AIPromptVersionSummary)((AIPromptVersionSummary.Builder)AIPromptVersionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAiPromptVersionsResponse build() {
            return new ListAiPromptVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAiPromptVersionsResponse> {
        public Builder aiPromptVersionSummaries(Collection<AIPromptVersionSummary> var1);

        public Builder aiPromptVersionSummaries(AIPromptVersionSummary ... var1);

        public Builder aiPromptVersionSummaries(Consumer<AIPromptVersionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

