/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.AIAgentData;
import software.amazon.awssdk.services.qconnect.model.QConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAiAgentResponse
extends QConnectResponse
implements ToCopyableBuilder<Builder, GetAiAgentResponse> {
    private static final SdkField<AIAgentData> AI_AGENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("aiAgent").getter(GetAiAgentResponse.getter(GetAiAgentResponse::aiAgent)).setter(GetAiAgentResponse.setter(Builder::aiAgent)).constructor(AIAgentData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgent").build()}).build();
    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("versionNumber").getter(GetAiAgentResponse.getter(GetAiAgentResponse::versionNumber)).setter(GetAiAgentResponse.setter(Builder::versionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AI_AGENT_FIELD, VERSION_NUMBER_FIELD));
    private final AIAgentData aiAgent;
    private final Long versionNumber;

    private GetAiAgentResponse(BuilderImpl builder) {
        super(builder);
        this.aiAgent = builder.aiAgent;
        this.versionNumber = builder.versionNumber;
    }

    public final AIAgentData aiAgent() {
        return this.aiAgent;
    }

    public final Long versionNumber() {
        return this.versionNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.aiAgent());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAiAgentResponse)) {
            return false;
        }
        GetAiAgentResponse other = (GetAiAgentResponse)((Object)obj);
        return Objects.equals(this.aiAgent(), other.aiAgent()) && Objects.equals(this.versionNumber(), other.versionNumber());
    }

    public final String toString() {
        return ToString.builder((String)"GetAiAgentResponse").add("AiAgent", (Object)this.aiAgent()).add("VersionNumber", (Object)this.versionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "aiAgent": {
                return Optional.ofNullable(clazz.cast(this.aiAgent()));
            }
            case "versionNumber": {
                return Optional.ofNullable(clazz.cast(this.versionNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAiAgentResponse, T> g) {
        return obj -> g.apply((GetAiAgentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectResponse.BuilderImpl
    implements Builder {
        private AIAgentData aiAgent;
        private Long versionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAiAgentResponse model) {
            super(model);
            this.aiAgent(model.aiAgent);
            this.versionNumber(model.versionNumber);
        }

        public final AIAgentData.Builder getAiAgent() {
            return this.aiAgent != null ? this.aiAgent.toBuilder() : null;
        }

        public final void setAiAgent(AIAgentData.BuilderImpl aiAgent) {
            this.aiAgent = aiAgent != null ? aiAgent.build() : null;
        }

        @Override
        public final Builder aiAgent(AIAgentData aiAgent) {
            this.aiAgent = aiAgent;
            return this;
        }

        public final Long getVersionNumber() {
            return this.versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        @Override
        public GetAiAgentResponse build() {
            return new GetAiAgentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAiAgentResponse> {
        public Builder aiAgent(AIAgentData var1);

        default public Builder aiAgent(Consumer<AIAgentData.Builder> aiAgent) {
            return this.aiAgent((AIAgentData)((AIAgentData.Builder)AIAgentData.builder().applyMutation(aiAgent)).build());
        }

        public Builder versionNumber(Long var1);
    }
}

