/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qconnect.model.ContentAssociationContents;
import software.amazon.awssdk.services.qconnect.model.ContentAssociationType;
import software.amazon.awssdk.services.qconnect.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContentAssociationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContentAssociationSummary> {
    private static final SdkField<ContentAssociationContents> ASSOCIATION_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("associationData").getter(ContentAssociationSummary.getter(ContentAssociationSummary::associationData)).setter(ContentAssociationSummary.setter(Builder::associationData)).constructor(ContentAssociationContents::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationData").build()}).build();
    private static final SdkField<String> ASSOCIATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associationType").getter(ContentAssociationSummary.getter(ContentAssociationSummary::associationTypeAsString)).setter(ContentAssociationSummary.setter(Builder::associationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationType").build()}).build();
    private static final SdkField<String> CONTENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentArn").getter(ContentAssociationSummary.getter(ContentAssociationSummary::contentArn)).setter(ContentAssociationSummary.setter(Builder::contentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentArn").build()}).build();
    private static final SdkField<String> CONTENT_ASSOCIATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentAssociationArn").getter(ContentAssociationSummary.getter(ContentAssociationSummary::contentAssociationArn)).setter(ContentAssociationSummary.setter(Builder::contentAssociationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentAssociationArn").build()}).build();
    private static final SdkField<String> CONTENT_ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentAssociationId").getter(ContentAssociationSummary.getter(ContentAssociationSummary::contentAssociationId)).setter(ContentAssociationSummary.setter(Builder::contentAssociationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentAssociationId").build()}).build();
    private static final SdkField<String> CONTENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentId").getter(ContentAssociationSummary.getter(ContentAssociationSummary::contentId)).setter(ContentAssociationSummary.setter(Builder::contentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentId").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseArn").getter(ContentAssociationSummary.getter(ContentAssociationSummary::knowledgeBaseArn)).setter(ContentAssociationSummary.setter(Builder::knowledgeBaseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseArn").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(ContentAssociationSummary.getter(ContentAssociationSummary::knowledgeBaseId)).setter(ContentAssociationSummary.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(ContentAssociationSummary.getter(ContentAssociationSummary::tags)).setter(ContentAssociationSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_DATA_FIELD, ASSOCIATION_TYPE_FIELD, CONTENT_ARN_FIELD, CONTENT_ASSOCIATION_ARN_FIELD, CONTENT_ASSOCIATION_ID_FIELD, CONTENT_ID_FIELD, KNOWLEDGE_BASE_ARN_FIELD, KNOWLEDGE_BASE_ID_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final ContentAssociationContents associationData;
    private final String associationType;
    private final String contentArn;
    private final String contentAssociationArn;
    private final String contentAssociationId;
    private final String contentId;
    private final String knowledgeBaseArn;
    private final String knowledgeBaseId;
    private final Map<String, String> tags;

    private ContentAssociationSummary(BuilderImpl builder) {
        this.associationData = builder.associationData;
        this.associationType = builder.associationType;
        this.contentArn = builder.contentArn;
        this.contentAssociationArn = builder.contentAssociationArn;
        this.contentAssociationId = builder.contentAssociationId;
        this.contentId = builder.contentId;
        this.knowledgeBaseArn = builder.knowledgeBaseArn;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.tags = builder.tags;
    }

    public final ContentAssociationContents associationData() {
        return this.associationData;
    }

    public final ContentAssociationType associationType() {
        return ContentAssociationType.fromValue(this.associationType);
    }

    public final String associationTypeAsString() {
        return this.associationType;
    }

    public final String contentArn() {
        return this.contentArn;
    }

    public final String contentAssociationArn() {
        return this.contentAssociationArn;
    }

    public final String contentAssociationId() {
        return this.contentAssociationId;
    }

    public final String contentId() {
        return this.contentId;
    }

    public final String knowledgeBaseArn() {
        return this.knowledgeBaseArn;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associationData());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentAssociationSummary)) {
            return false;
        }
        ContentAssociationSummary other = (ContentAssociationSummary)obj;
        return Objects.equals(this.associationData(), other.associationData()) && Objects.equals(this.associationTypeAsString(), other.associationTypeAsString()) && Objects.equals(this.contentArn(), other.contentArn()) && Objects.equals(this.contentAssociationArn(), other.contentAssociationArn()) && Objects.equals(this.contentAssociationId(), other.contentAssociationId()) && Objects.equals(this.contentId(), other.contentId()) && Objects.equals(this.knowledgeBaseArn(), other.knowledgeBaseArn()) && Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"ContentAssociationSummary").add("AssociationData", (Object)this.associationData()).add("AssociationType", (Object)this.associationTypeAsString()).add("ContentArn", (Object)this.contentArn()).add("ContentAssociationArn", (Object)this.contentAssociationArn()).add("ContentAssociationId", (Object)this.contentAssociationId()).add("ContentId", (Object)this.contentId()).add("KnowledgeBaseArn", (Object)this.knowledgeBaseArn()).add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "associationData": {
                return Optional.ofNullable(clazz.cast(this.associationData()));
            }
            case "associationType": {
                return Optional.ofNullable(clazz.cast(this.associationTypeAsString()));
            }
            case "contentArn": {
                return Optional.ofNullable(clazz.cast(this.contentArn()));
            }
            case "contentAssociationArn": {
                return Optional.ofNullable(clazz.cast(this.contentAssociationArn()));
            }
            case "contentAssociationId": {
                return Optional.ofNullable(clazz.cast(this.contentAssociationId()));
            }
            case "contentId": {
                return Optional.ofNullable(clazz.cast(this.contentId()));
            }
            case "knowledgeBaseArn": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseArn()));
            }
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContentAssociationSummary, T> g) {
        return obj -> g.apply((ContentAssociationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ContentAssociationContents associationData;
        private String associationType;
        private String contentArn;
        private String contentAssociationArn;
        private String contentAssociationId;
        private String contentId;
        private String knowledgeBaseArn;
        private String knowledgeBaseId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContentAssociationSummary model) {
            this.associationData(model.associationData);
            this.associationType(model.associationType);
            this.contentArn(model.contentArn);
            this.contentAssociationArn(model.contentAssociationArn);
            this.contentAssociationId(model.contentAssociationId);
            this.contentId(model.contentId);
            this.knowledgeBaseArn(model.knowledgeBaseArn);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.tags(model.tags);
        }

        public final ContentAssociationContents.Builder getAssociationData() {
            return this.associationData != null ? this.associationData.toBuilder() : null;
        }

        public final void setAssociationData(ContentAssociationContents.BuilderImpl associationData) {
            this.associationData = associationData != null ? associationData.build() : null;
        }

        @Override
        public final Builder associationData(ContentAssociationContents associationData) {
            this.associationData = associationData;
            return this;
        }

        public final String getAssociationType() {
            return this.associationType;
        }

        public final void setAssociationType(String associationType) {
            this.associationType = associationType;
        }

        @Override
        public final Builder associationType(String associationType) {
            this.associationType = associationType;
            return this;
        }

        @Override
        public final Builder associationType(ContentAssociationType associationType) {
            this.associationType(associationType == null ? null : associationType.toString());
            return this;
        }

        public final String getContentArn() {
            return this.contentArn;
        }

        public final void setContentArn(String contentArn) {
            this.contentArn = contentArn;
        }

        @Override
        public final Builder contentArn(String contentArn) {
            this.contentArn = contentArn;
            return this;
        }

        public final String getContentAssociationArn() {
            return this.contentAssociationArn;
        }

        public final void setContentAssociationArn(String contentAssociationArn) {
            this.contentAssociationArn = contentAssociationArn;
        }

        @Override
        public final Builder contentAssociationArn(String contentAssociationArn) {
            this.contentAssociationArn = contentAssociationArn;
            return this;
        }

        public final String getContentAssociationId() {
            return this.contentAssociationId;
        }

        public final void setContentAssociationId(String contentAssociationId) {
            this.contentAssociationId = contentAssociationId;
        }

        @Override
        public final Builder contentAssociationId(String contentAssociationId) {
            this.contentAssociationId = contentAssociationId;
            return this;
        }

        public final String getContentId() {
            return this.contentId;
        }

        public final void setContentId(String contentId) {
            this.contentId = contentId;
        }

        @Override
        public final Builder contentId(String contentId) {
            this.contentId = contentId;
            return this;
        }

        public final String getKnowledgeBaseArn() {
            return this.knowledgeBaseArn;
        }

        public final void setKnowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
        }

        @Override
        public final Builder knowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public ContentAssociationSummary build() {
            return new ContentAssociationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContentAssociationSummary> {
        public Builder associationData(ContentAssociationContents var1);

        default public Builder associationData(Consumer<ContentAssociationContents.Builder> associationData) {
            return this.associationData((ContentAssociationContents)((ContentAssociationContents.Builder)ContentAssociationContents.builder().applyMutation(associationData)).build());
        }

        public Builder associationType(String var1);

        public Builder associationType(ContentAssociationType var1);

        public Builder contentArn(String var1);

        public Builder contentAssociationArn(String var1);

        public Builder contentAssociationId(String var1);

        public Builder contentId(String var1);

        public Builder knowledgeBaseArn(String var1);

        public Builder knowledgeBaseId(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

