/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.MessageData;
import software.amazon.awssdk.services.qconnect.model.Participant;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MessageOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MessageOutput> {
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("messageId").getter(MessageOutput.getter(MessageOutput::messageId)).setter(MessageOutput.setter(Builder::messageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageId").build()}).build();
    private static final SdkField<String> PARTICIPANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("participant").getter(MessageOutput.getter(MessageOutput::participantAsString)).setter(MessageOutput.setter(Builder::participant)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participant").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("timestamp").getter(MessageOutput.getter(MessageOutput::timestamp)).setter(MessageOutput.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()}).build();
    private static final SdkField<MessageData> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("value").getter(MessageOutput.getter(MessageOutput::value)).setter(MessageOutput.setter(Builder::value)).constructor(MessageData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_ID_FIELD, PARTICIPANT_FIELD, TIMESTAMP_FIELD, VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MessageOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String messageId;
    private final String participant;
    private final Instant timestamp;
    private final MessageData value;

    private MessageOutput(BuilderImpl builder) {
        this.messageId = builder.messageId;
        this.participant = builder.participant;
        this.timestamp = builder.timestamp;
        this.value = builder.value;
    }

    public final String messageId() {
        return this.messageId;
    }

    public final Participant participant() {
        return Participant.fromValue(this.participant);
    }

    public final String participantAsString() {
        return this.participant;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final MessageData value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.messageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.participantAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageOutput)) {
            return false;
        }
        MessageOutput other = (MessageOutput)obj;
        return Objects.equals(this.messageId(), other.messageId()) && Objects.equals(this.participantAsString(), other.participantAsString()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.value(), other.value());
    }

    public final String toString() {
        return ToString.builder((String)"MessageOutput").add("MessageId", (Object)this.messageId()).add("Participant", (Object)this.participantAsString()).add("Timestamp", (Object)this.timestamp()).add("Value", (Object)this.value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "messageId": {
                return Optional.ofNullable(clazz.cast(this.messageId()));
            }
            case "participant": {
                return Optional.ofNullable(clazz.cast(this.participantAsString()));
            }
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("messageId", MESSAGE_ID_FIELD);
        map.put("participant", PARTICIPANT_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        map.put("value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MessageOutput, T> g) {
        return obj -> g.apply((MessageOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String messageId;
        private String participant;
        private Instant timestamp;
        private MessageData value;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageOutput model) {
            this.messageId(model.messageId);
            this.participant(model.participant);
            this.timestamp(model.timestamp);
            this.value(model.value);
        }

        public final String getMessageId() {
            return this.messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final String getParticipant() {
            return this.participant;
        }

        public final void setParticipant(String participant) {
            this.participant = participant;
        }

        @Override
        public final Builder participant(String participant) {
            this.participant = participant;
            return this;
        }

        @Override
        public final Builder participant(Participant participant) {
            this.participant(participant == null ? null : participant.toString());
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final MessageData.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        public final void setValue(MessageData.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(MessageData value) {
            this.value = value;
            return this;
        }

        public MessageOutput build() {
            return new MessageOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MessageOutput> {
        public Builder messageId(String var1);

        public Builder participant(String var1);

        public Builder participant(Participant var1);

        public Builder timestamp(Instant var1);

        public Builder value(MessageData var1);

        default public Builder value(Consumer<MessageData.Builder> value) {
            return this.value((MessageData)((MessageData.Builder)MessageData.builder().applyMutation(value)).build());
        }
    }
}

