/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BrowserExtension {
    FIREFOX("FIREFOX"),
    CHROME("CHROME"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BrowserExtension> VALUE_MAP;
    private final String value;

    private BrowserExtension(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BrowserExtension fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BrowserExtension> knownValues() {
        EnumSet<BrowserExtension> knownValues = EnumSet.allOf(BrowserExtension.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BrowserExtension.class, BrowserExtension::toString);
    }
}

