/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.APISchema;
import software.amazon.awssdk.services.qbusiness.model.APISchemaType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomPluginConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomPluginConfiguration> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CustomPluginConfiguration.getter(CustomPluginConfiguration::description)).setter(CustomPluginConfiguration.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> API_SCHEMA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("apiSchemaType").getter(CustomPluginConfiguration.getter(CustomPluginConfiguration::apiSchemaTypeAsString)).setter(CustomPluginConfiguration.setter(Builder::apiSchemaType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiSchemaType").build()}).build();
    private static final SdkField<APISchema> API_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("apiSchema").getter(CustomPluginConfiguration.getter(CustomPluginConfiguration::apiSchema)).setter(CustomPluginConfiguration.setter(Builder::apiSchema)).constructor(APISchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiSchema").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, API_SCHEMA_TYPE_FIELD, API_SCHEMA_FIELD));
    private static final long serialVersionUID = 1L;
    private final String description;
    private final String apiSchemaType;
    private final APISchema apiSchema;

    private CustomPluginConfiguration(BuilderImpl builder) {
        this.description = builder.description;
        this.apiSchemaType = builder.apiSchemaType;
        this.apiSchema = builder.apiSchema;
    }

    public final String description() {
        return this.description;
    }

    public final APISchemaType apiSchemaType() {
        return APISchemaType.fromValue(this.apiSchemaType);
    }

    public final String apiSchemaTypeAsString() {
        return this.apiSchemaType;
    }

    public final APISchema apiSchema() {
        return this.apiSchema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiSchemaTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiSchema());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomPluginConfiguration)) {
            return false;
        }
        CustomPluginConfiguration other = (CustomPluginConfiguration)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.apiSchemaTypeAsString(), other.apiSchemaTypeAsString()) && Objects.equals(this.apiSchema(), other.apiSchema());
    }

    public final String toString() {
        return ToString.builder((String)"CustomPluginConfiguration").add("Description", (Object)this.description()).add("ApiSchemaType", (Object)this.apiSchemaTypeAsString()).add("ApiSchema", (Object)this.apiSchema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "apiSchemaType": {
                return Optional.ofNullable(clazz.cast(this.apiSchemaTypeAsString()));
            }
            case "apiSchema": {
                return Optional.ofNullable(clazz.cast(this.apiSchema()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomPluginConfiguration, T> g) {
        return obj -> g.apply((CustomPluginConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String apiSchemaType;
        private APISchema apiSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomPluginConfiguration model) {
            this.description(model.description);
            this.apiSchemaType(model.apiSchemaType);
            this.apiSchema(model.apiSchema);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getApiSchemaType() {
            return this.apiSchemaType;
        }

        public final void setApiSchemaType(String apiSchemaType) {
            this.apiSchemaType = apiSchemaType;
        }

        @Override
        public final Builder apiSchemaType(String apiSchemaType) {
            this.apiSchemaType = apiSchemaType;
            return this;
        }

        @Override
        public final Builder apiSchemaType(APISchemaType apiSchemaType) {
            this.apiSchemaType(apiSchemaType == null ? null : apiSchemaType.toString());
            return this;
        }

        public final APISchema.Builder getApiSchema() {
            return this.apiSchema != null ? this.apiSchema.toBuilder() : null;
        }

        public final void setApiSchema(APISchema.BuilderImpl apiSchema) {
            this.apiSchema = apiSchema != null ? apiSchema.build() : null;
        }

        @Override
        public final Builder apiSchema(APISchema apiSchema) {
            this.apiSchema = apiSchema;
            return this;
        }

        public CustomPluginConfiguration build() {
            return new CustomPluginConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomPluginConfiguration> {
        public Builder description(String var1);

        public Builder apiSchemaType(String var1);

        public Builder apiSchemaType(APISchemaType var1);

        public Builder apiSchema(APISchema var1);

        default public Builder apiSchema(Consumer<APISchema.Builder> apiSchema) {
            return this.apiSchema((APISchema)((APISchema.Builder)APISchema.builder().applyMutation(apiSchema)).build());
        }
    }
}

