/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qbusiness.QBusinessClient;
import software.amazon.awssdk.services.qbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.qbusiness.model.DocumentDetails;
import software.amazon.awssdk.services.qbusiness.model.ListDocumentsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListDocumentsResponse;

public class ListDocumentsIterable
implements SdkIterable<ListDocumentsResponse> {
    private final QBusinessClient client;
    private final ListDocumentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDocumentsIterable(QBusinessClient client, ListDocumentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDocumentsResponseFetcher();
    }

    public Iterator<ListDocumentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DocumentDetails> documentDetailList() {
        Function<ListDocumentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.documentDetailList() != null) {
                return response.documentDetailList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDocumentsResponseFetcher
    implements SyncPageFetcher<ListDocumentsResponse> {
        private ListDocumentsResponseFetcher() {
        }

        public boolean hasNextPage(ListDocumentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDocumentsResponse nextPage(ListDocumentsResponse previousPage) {
            if (previousPage == null) {
                return ListDocumentsIterable.this.client.listDocuments(ListDocumentsIterable.this.firstRequest);
            }
            return ListDocumentsIterable.this.client.listDocuments((ListDocumentsRequest)((Object)ListDocumentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

