/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.qbusiness.model.ActionReviewEvent;
import software.amazon.awssdk.services.qbusiness.model.AuthChallengeRequestEvent;
import software.amazon.awssdk.services.qbusiness.model.ChatOutputStream;
import software.amazon.awssdk.services.qbusiness.model.ChatResponseHandler;
import software.amazon.awssdk.services.qbusiness.model.FailedAttachmentEvent;
import software.amazon.awssdk.services.qbusiness.model.MetadataEvent;
import software.amazon.awssdk.services.qbusiness.model.TextOutputEvent;

@SdkInternalApi
final class DefaultChatVisitorBuilder
implements ChatResponseHandler.Visitor.Builder {
    private Consumer<ChatOutputStream> onDefault;
    private Consumer<TextOutputEvent> onTextEvent;
    private Consumer<MetadataEvent> onMetadataEvent;
    private Consumer<ActionReviewEvent> onActionReviewEvent;
    private Consumer<FailedAttachmentEvent> onFailedAttachmentEvent;
    private Consumer<AuthChallengeRequestEvent> onAuthChallengeRequestEvent;

    DefaultChatVisitorBuilder() {
    }

    @Override
    public ChatResponseHandler.Visitor.Builder onDefault(Consumer<ChatOutputStream> c) {
        this.onDefault = c;
        return this;
    }

    @Override
    public ChatResponseHandler.Visitor build() {
        return new VisitorFromBuilder(this);
    }

    @Override
    public ChatResponseHandler.Visitor.Builder onTextEvent(Consumer<TextOutputEvent> c) {
        this.onTextEvent = c;
        return this;
    }

    @Override
    public ChatResponseHandler.Visitor.Builder onMetadataEvent(Consumer<MetadataEvent> c) {
        this.onMetadataEvent = c;
        return this;
    }

    @Override
    public ChatResponseHandler.Visitor.Builder onActionReviewEvent(Consumer<ActionReviewEvent> c) {
        this.onActionReviewEvent = c;
        return this;
    }

    @Override
    public ChatResponseHandler.Visitor.Builder onFailedAttachmentEvent(Consumer<FailedAttachmentEvent> c) {
        this.onFailedAttachmentEvent = c;
        return this;
    }

    @Override
    public ChatResponseHandler.Visitor.Builder onAuthChallengeRequestEvent(Consumer<AuthChallengeRequestEvent> c) {
        this.onAuthChallengeRequestEvent = c;
        return this;
    }

    static class VisitorFromBuilder
    implements ChatResponseHandler.Visitor {
        private final Consumer<ChatOutputStream> onDefault;
        private final Consumer<TextOutputEvent> onTextEvent;
        private final Consumer<MetadataEvent> onMetadataEvent;
        private final Consumer<ActionReviewEvent> onActionReviewEvent;
        private final Consumer<FailedAttachmentEvent> onFailedAttachmentEvent;
        private final Consumer<AuthChallengeRequestEvent> onAuthChallengeRequestEvent;

        VisitorFromBuilder(DefaultChatVisitorBuilder builder) {
            this.onDefault = builder.onDefault != null ? builder.onDefault : x$0 -> ChatResponseHandler.Visitor.super.visitDefault((ChatOutputStream)x$0);
            this.onTextEvent = builder.onTextEvent != null ? builder.onTextEvent : x$0 -> ChatResponseHandler.Visitor.super.visitTextEvent((TextOutputEvent)x$0);
            this.onMetadataEvent = builder.onMetadataEvent != null ? builder.onMetadataEvent : x$0 -> ChatResponseHandler.Visitor.super.visitMetadataEvent((MetadataEvent)x$0);
            this.onActionReviewEvent = builder.onActionReviewEvent != null ? builder.onActionReviewEvent : x$0 -> ChatResponseHandler.Visitor.super.visitActionReviewEvent((ActionReviewEvent)x$0);
            this.onFailedAttachmentEvent = builder.onFailedAttachmentEvent != null ? builder.onFailedAttachmentEvent : x$0 -> ChatResponseHandler.Visitor.super.visitFailedAttachmentEvent((FailedAttachmentEvent)x$0);
            this.onAuthChallengeRequestEvent = builder.onAuthChallengeRequestEvent != null ? builder.onAuthChallengeRequestEvent : x$0 -> ChatResponseHandler.Visitor.super.visitAuthChallengeRequestEvent((AuthChallengeRequestEvent)x$0);
        }

        @Override
        public void visitDefault(ChatOutputStream event) {
            this.onDefault.accept(event);
        }

        @Override
        public void visitTextEvent(TextOutputEvent event) {
            this.onTextEvent.accept(event);
        }

        @Override
        public void visitMetadataEvent(MetadataEvent event) {
            this.onMetadataEvent.accept(event);
        }

        @Override
        public void visitActionReviewEvent(ActionReviewEvent event) {
            this.onActionReviewEvent.accept(event);
        }

        @Override
        public void visitFailedAttachmentEvent(FailedAttachmentEvent event) {
            this.onFailedAttachmentEvent.accept(event);
        }

        @Override
        public void visitAuthChallengeRequestEvent(AuthChallengeRequestEvent event) {
            this.onAuthChallengeRequestEvent.accept(event);
        }
    }
}

