/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.services.qbusiness.model.ActionExecutionEvent;
import software.amazon.awssdk.services.qbusiness.model.AttachmentInputEvent;
import software.amazon.awssdk.services.qbusiness.model.AuthChallengeResponseEvent;
import software.amazon.awssdk.services.qbusiness.model.ConfigurationEvent;
import software.amazon.awssdk.services.qbusiness.model.EndOfInputEvent;
import software.amazon.awssdk.services.qbusiness.model.TextInputEvent;
import software.amazon.awssdk.services.qbusiness.model.chatinputstream.DefaultActionExecutionEvent;
import software.amazon.awssdk.services.qbusiness.model.chatinputstream.DefaultAttachmentEvent;
import software.amazon.awssdk.services.qbusiness.model.chatinputstream.DefaultAuthChallengeResponseEvent;
import software.amazon.awssdk.services.qbusiness.model.chatinputstream.DefaultConfigurationEvent;
import software.amazon.awssdk.services.qbusiness.model.chatinputstream.DefaultEndOfInputEvent;
import software.amazon.awssdk.services.qbusiness.model.chatinputstream.DefaultTextEvent;
import software.amazon.awssdk.utils.internal.EnumUtils;

@SdkPublicApi
public interface ChatInputStream {
    public static ConfigurationEvent.Builder configurationEventBuilder() {
        return DefaultConfigurationEvent.builder();
    }

    public static TextInputEvent.Builder textEventBuilder() {
        return DefaultTextEvent.builder();
    }

    public static AttachmentInputEvent.Builder attachmentEventBuilder() {
        return DefaultAttachmentEvent.builder();
    }

    public static ActionExecutionEvent.Builder actionExecutionEventBuilder() {
        return DefaultActionExecutionEvent.builder();
    }

    public static EndOfInputEvent.Builder endOfInputEventBuilder() {
        return DefaultEndOfInputEvent.builder();
    }

    public static AuthChallengeResponseEvent.Builder authChallengeResponseEventBuilder() {
        return DefaultAuthChallengeResponseEvent.builder();
    }

    default public EventType sdkEventType() {
        return EventType.UNKNOWN_TO_SDK_VERSION;
    }

    public static enum EventType {
        CONFIGURATION_EVENT("configurationEvent"),
        TEXT_EVENT("textEvent"),
        ATTACHMENT_EVENT("attachmentEvent"),
        ACTION_EXECUTION_EVENT("actionExecutionEvent"),
        END_OF_INPUT_EVENT("endOfInputEvent"),
        AUTH_CHALLENGE_RESPONSE_EVENT("authChallengeResponseEvent"),
        UNKNOWN_TO_SDK_VERSION(null);

        private static final Map<String, EventType> VALUE_MAP;
        private final String value;

        private EventType(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static EventType fromValue(String value) {
            if (value == null) {
                return null;
            }
            return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
        }

        public static Set<EventType> knownValues() {
            EnumSet<EventType> knownValues = EnumSet.allOf(EventType.class);
            knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
            return knownValues;
        }

        static {
            VALUE_MAP = EnumUtils.uniqueIndex(EventType.class, EventType::toString);
        }
    }
}

