/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum APISchemaType {
    OPEN_API_V3("OPEN_API_V3"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, APISchemaType> VALUE_MAP;
    private final String value;

    private APISchemaType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static APISchemaType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<APISchemaType> knownValues() {
        EnumSet<APISchemaType> knownValues = EnumSet.allOf(APISchemaType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(APISchemaType.class, APISchemaType::toString);
    }
}

