/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Amazon Q App associated with a user, either owned by the user or favorited.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserAppItem implements SdkPojo, Serializable, ToCopyableBuilder<UserAppItem.Builder, UserAppItem> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appId")
            .getter(getter(UserAppItem::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()).build();

    private static final SdkField<String> APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appArn")
            .getter(getter(UserAppItem::appArn)).setter(setter(Builder::appArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(UserAppItem::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UserAppItem::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(UserAppItem::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Boolean> CAN_EDIT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("canEdit").getter(getter(UserAppItem::canEdit)).setter(setter(Builder::canEdit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canEdit").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(UserAppItem::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Boolean> IS_VERIFIED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isVerified").getter(getter(UserAppItem::isVerified)).setter(setter(Builder::isVerified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isVerified").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, APP_ARN_FIELD,
            TITLE_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, CAN_EDIT_FIELD, STATUS_FIELD, IS_VERIFIED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String appId;

    private final String appArn;

    private final String title;

    private final String description;

    private final Instant createdAt;

    private final Boolean canEdit;

    private final String status;

    private final Boolean isVerified;

    private UserAppItem(BuilderImpl builder) {
        this.appId = builder.appId;
        this.appArn = builder.appArn;
        this.title = builder.title;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.canEdit = builder.canEdit;
        this.status = builder.status;
        this.isVerified = builder.isVerified;
    }

    /**
     * <p>
     * The unique identifier of the Q App.
     * </p>
     * 
     * @return The unique identifier of the Q App.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Q App.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Q App.
     */
    public final String appArn() {
        return appArn;
    }

    /**
     * <p>
     * The title of the Q App.
     * </p>
     * 
     * @return The title of the Q App.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The description of the Q App.
     * </p>
     * 
     * @return The description of the Q App.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The date and time the user's association with the Q App was created.
     * </p>
     * 
     * @return The date and time the user's association with the Q App was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * A flag indicating whether the user can edit the Q App.
     * </p>
     * 
     * @return A flag indicating whether the user can edit the Q App.
     */
    public final Boolean canEdit() {
        return canEdit;
    }

    /**
     * <p>
     * The status of the user's association with the Q App.
     * </p>
     * 
     * @return The status of the user's association with the Q App.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * Indicates whether the Q App has been verified.
     * </p>
     * 
     * @return Indicates whether the Q App has been verified.
     */
    public final Boolean isVerified() {
        return isVerified;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(canEdit());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(isVerified());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserAppItem)) {
            return false;
        }
        UserAppItem other = (UserAppItem) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(appArn(), other.appArn())
                && Objects.equals(title(), other.title()) && Objects.equals(description(), other.description())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(canEdit(), other.canEdit())
                && Objects.equals(status(), other.status()) && Objects.equals(isVerified(), other.isVerified());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserAppItem").add("AppId", appId()).add("AppArn", appArn()).add("Title", title())
                .add("Description", description()).add("CreatedAt", createdAt()).add("CanEdit", canEdit())
                .add("Status", status()).add("IsVerified", isVerified()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "appArn":
            return Optional.ofNullable(clazz.cast(appArn()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "canEdit":
            return Optional.ofNullable(clazz.cast(canEdit()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "isVerified":
            return Optional.ofNullable(clazz.cast(isVerified()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appId", APP_ID_FIELD);
        map.put("appArn", APP_ARN_FIELD);
        map.put("title", TITLE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("canEdit", CAN_EDIT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("isVerified", IS_VERIFIED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserAppItem, T> g) {
        return obj -> g.apply((UserAppItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserAppItem> {
        /**
         * <p>
         * The unique identifier of the Q App.
         * </p>
         * 
         * @param appId
         *        The unique identifier of the Q App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Q App.
         * </p>
         * 
         * @param appArn
         *        The Amazon Resource Name (ARN) of the Q App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * The title of the Q App.
         * </p>
         * 
         * @param title
         *        The title of the Q App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The description of the Q App.
         * </p>
         * 
         * @param description
         *        The description of the Q App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date and time the user's association with the Q App was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time the user's association with the Q App was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * A flag indicating whether the user can edit the Q App.
         * </p>
         * 
         * @param canEdit
         *        A flag indicating whether the user can edit the Q App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canEdit(Boolean canEdit);

        /**
         * <p>
         * The status of the user's association with the Q App.
         * </p>
         * 
         * @param status
         *        The status of the user's association with the Q App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates whether the Q App has been verified.
         * </p>
         * 
         * @param isVerified
         *        Indicates whether the Q App has been verified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isVerified(Boolean isVerified);
    }

    static final class BuilderImpl implements Builder {
        private String appId;

        private String appArn;

        private String title;

        private String description;

        private Instant createdAt;

        private Boolean canEdit;

        private String status;

        private Boolean isVerified;

        private BuilderImpl() {
        }

        private BuilderImpl(UserAppItem model) {
            appId(model.appId);
            appArn(model.appArn);
            title(model.title);
            description(model.description);
            createdAt(model.createdAt);
            canEdit(model.canEdit);
            status(model.status);
            isVerified(model.isVerified);
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getAppArn() {
            return appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Boolean getCanEdit() {
            return canEdit;
        }

        public final void setCanEdit(Boolean canEdit) {
            this.canEdit = canEdit;
        }

        @Override
        public final Builder canEdit(Boolean canEdit) {
            this.canEdit = canEdit;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Boolean getIsVerified() {
            return isVerified;
        }

        public final void setIsVerified(Boolean isVerified) {
            this.isVerified = isVerified;
        }

        @Override
        public final Builder isVerified(Boolean isVerified) {
            this.isVerified = isVerified;
            return this;
        }

        @Override
        public UserAppItem build() {
            return new UserAppItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
