/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input options for generating an Q App definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PredictQAppInputOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<PredictQAppInputOptions.Builder, PredictQAppInputOptions> {
    private static final SdkField<List<ConversationMessage>> CONVERSATION_FIELD = SdkField
            .<List<ConversationMessage>> builder(MarshallingType.LIST)
            .memberName("conversation")
            .getter(getter(PredictQAppInputOptions::conversation))
            .setter(setter(Builder::conversation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversation").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConversationMessage> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConversationMessage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PROBLEM_STATEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("problemStatement").getter(getter(PredictQAppInputOptions::problemStatement))
            .setter(setter(Builder::problemStatement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("problemStatement").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERSATION_FIELD,
            PROBLEM_STATEMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ConversationMessage> conversation;

    private final String problemStatement;

    private final Type type;

    private PredictQAppInputOptions(BuilderImpl builder) {
        this.conversation = builder.conversation;
        this.problemStatement = builder.problemStatement;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Conversation property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConversation() {
        return conversation != null && !(conversation instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A conversation to use as input for generating the Q App definition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConversation} method.
     * </p>
     * 
     * @return A conversation to use as input for generating the Q App definition.
     */
    public final List<ConversationMessage> conversation() {
        return conversation;
    }

    /**
     * <p>
     * A problem statement to use as input for generating the Q App definition.
     * </p>
     * 
     * @return A problem statement to use as input for generating the Q App definition.
     */
    public final String problemStatement() {
        return problemStatement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasConversation() ? conversation() : null);
        hashCode = 31 * hashCode + Objects.hashCode(problemStatement());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictQAppInputOptions)) {
            return false;
        }
        PredictQAppInputOptions other = (PredictQAppInputOptions) obj;
        return hasConversation() == other.hasConversation() && Objects.equals(conversation(), other.conversation())
                && Objects.equals(problemStatement(), other.problemStatement());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PredictQAppInputOptions").add("Conversation", hasConversation() ? conversation() : null)
                .add("ProblemStatement", problemStatement()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "conversation":
            return Optional.ofNullable(clazz.cast(conversation()));
        case "problemStatement":
            return Optional.ofNullable(clazz.cast(problemStatement()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #conversation()} initialized to the given value.
     *
     * <p>
     * A conversation to use as input for generating the Q App definition.
     * </p>
     * 
     * @param conversation
     *        A conversation to use as input for generating the Q App definition.
     */
    public static PredictQAppInputOptions fromConversation(List<ConversationMessage> conversation) {
        return builder().conversation(conversation).build();
    }

    /**
     * Create an instance of this class with {@link #problemStatement()} initialized to the given value.
     *
     * <p>
     * A problem statement to use as input for generating the Q App definition.
     * </p>
     * 
     * @param problemStatement
     *        A problem statement to use as input for generating the Q App definition.
     */
    public static PredictQAppInputOptions fromProblemStatement(String problemStatement) {
        return builder().problemStatement(problemStatement).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("conversation", CONVERSATION_FIELD);
        map.put("problemStatement", PROBLEM_STATEMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PredictQAppInputOptions, T> g) {
        return obj -> g.apply((PredictQAppInputOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PredictQAppInputOptions> {
        /**
         * <p>
         * A conversation to use as input for generating the Q App definition.
         * </p>
         * 
         * @param conversation
         *        A conversation to use as input for generating the Q App definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversation(Collection<ConversationMessage> conversation);

        /**
         * <p>
         * A conversation to use as input for generating the Q App definition.
         * </p>
         * 
         * @param conversation
         *        A conversation to use as input for generating the Q App definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversation(ConversationMessage... conversation);

        /**
         * <p>
         * A conversation to use as input for generating the Q App definition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qapps.model.ConversationMessage.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.qapps.model.ConversationMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qapps.model.ConversationMessage.Builder#build()} is called immediately
         * and its result is passed to {@link #conversation(List<ConversationMessage>)}.
         * 
         * @param conversation
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qapps.model.ConversationMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conversation(java.util.Collection<ConversationMessage>)
         */
        Builder conversation(Consumer<ConversationMessage.Builder>... conversation);

        /**
         * <p>
         * A problem statement to use as input for generating the Q App definition.
         * </p>
         * 
         * @param problemStatement
         *        A problem statement to use as input for generating the Q App definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder problemStatement(String problemStatement);
    }

    static final class BuilderImpl implements Builder {
        private List<ConversationMessage> conversation = DefaultSdkAutoConstructList.getInstance();

        private String problemStatement;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PredictQAppInputOptions model) {
            conversation(model.conversation);
            problemStatement(model.problemStatement);
        }

        public final List<ConversationMessage.Builder> getConversation() {
            List<ConversationMessage.Builder> result = PredictQAppInputOptionsConversationListCopier
                    .copyToBuilder(this.conversation);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConversation(Collection<ConversationMessage.BuilderImpl> conversation) {
            Object oldValue = this.conversation;
            this.conversation = PredictQAppInputOptionsConversationListCopier.copyFromBuilder(conversation);
            handleUnionValueChange(Type.CONVERSATION, oldValue, this.conversation);
        }

        @Override
        public final Builder conversation(Collection<ConversationMessage> conversation) {
            Object oldValue = this.conversation;
            this.conversation = PredictQAppInputOptionsConversationListCopier.copy(conversation);
            handleUnionValueChange(Type.CONVERSATION, oldValue, this.conversation);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conversation(ConversationMessage... conversation) {
            conversation(Arrays.asList(conversation));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conversation(Consumer<ConversationMessage.Builder>... conversation) {
            conversation(Stream.of(conversation).map(c -> ConversationMessage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getProblemStatement() {
            return problemStatement;
        }

        public final void setProblemStatement(String problemStatement) {
            Object oldValue = this.problemStatement;
            this.problemStatement = problemStatement;
            handleUnionValueChange(Type.PROBLEM_STATEMENT, oldValue, this.problemStatement);
        }

        @Override
        public final Builder problemStatement(String problemStatement) {
            Object oldValue = this.problemStatement;
            this.problemStatement = problemStatement;
            handleUnionValueChange(Type.PROBLEM_STATEMENT, oldValue, this.problemStatement);
            return this;
        }

        @Override
        public PredictQAppInputOptions build() {
            return new PredictQAppInputOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see PredictQAppInputOptions#type()
     */
    public enum Type {
        CONVERSATION,

        PROBLEM_STATEMENT,

        UNKNOWN_TO_SDK_VERSION
    }
}
