/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qapps.model.PermissionInput;
import software.amazon.awssdk.services.qapps.model.QAppsRequest;
import software.amazon.awssdk.services.qapps.model.UpdateQAppPermissionsInputGrantPermissionsListCopier;
import software.amazon.awssdk.services.qapps.model.UpdateQAppPermissionsInputRevokePermissionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateQAppPermissionsRequest
extends QAppsRequest
implements ToCopyableBuilder<Builder, UpdateQAppPermissionsRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceId").getter(UpdateQAppPermissionsRequest.getter(UpdateQAppPermissionsRequest::instanceId)).setter(UpdateQAppPermissionsRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("instance-id").build()}).build();
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appId").getter(UpdateQAppPermissionsRequest.getter(UpdateQAppPermissionsRequest::appId)).setter(UpdateQAppPermissionsRequest.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()}).build();
    private static final SdkField<List<PermissionInput>> GRANT_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("grantPermissions").getter(UpdateQAppPermissionsRequest.getter(UpdateQAppPermissionsRequest::grantPermissions)).setter(UpdateQAppPermissionsRequest.setter(Builder::grantPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grantPermissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PermissionInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PermissionInput>> REVOKE_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("revokePermissions").getter(UpdateQAppPermissionsRequest.getter(UpdateQAppPermissionsRequest::revokePermissions)).setter(UpdateQAppPermissionsRequest.setter(Builder::revokePermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revokePermissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PermissionInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, APP_ID_FIELD, GRANT_PERMISSIONS_FIELD, REVOKE_PERMISSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateQAppPermissionsRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String appId;
    private final List<PermissionInput> grantPermissions;
    private final List<PermissionInput> revokePermissions;

    private UpdateQAppPermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.appId = builder.appId;
        this.grantPermissions = builder.grantPermissions;
        this.revokePermissions = builder.revokePermissions;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String appId() {
        return this.appId;
    }

    public final boolean hasGrantPermissions() {
        return this.grantPermissions != null && !(this.grantPermissions instanceof SdkAutoConstructList);
    }

    public final List<PermissionInput> grantPermissions() {
        return this.grantPermissions;
    }

    public final boolean hasRevokePermissions() {
        return this.revokePermissions != null && !(this.revokePermissions instanceof SdkAutoConstructList);
    }

    public final List<PermissionInput> revokePermissions() {
        return this.revokePermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGrantPermissions() ? this.grantPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRevokePermissions() ? this.revokePermissions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateQAppPermissionsRequest)) {
            return false;
        }
        UpdateQAppPermissionsRequest other = (UpdateQAppPermissionsRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.appId(), other.appId()) && this.hasGrantPermissions() == other.hasGrantPermissions() && Objects.equals(this.grantPermissions(), other.grantPermissions()) && this.hasRevokePermissions() == other.hasRevokePermissions() && Objects.equals(this.revokePermissions(), other.revokePermissions());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateQAppPermissionsRequest").add("InstanceId", (Object)this.instanceId()).add("AppId", (Object)this.appId()).add("GrantPermissions", this.hasGrantPermissions() ? this.grantPermissions() : null).add("RevokePermissions", this.hasRevokePermissions() ? this.revokePermissions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "grantPermissions": {
                return Optional.ofNullable(clazz.cast(this.grantPermissions()));
            }
            case "revokePermissions": {
                return Optional.ofNullable(clazz.cast(this.revokePermissions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("instance-id", INSTANCE_ID_FIELD);
        map.put("appId", APP_ID_FIELD);
        map.put("grantPermissions", GRANT_PERMISSIONS_FIELD);
        map.put("revokePermissions", REVOKE_PERMISSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateQAppPermissionsRequest, T> g) {
        return obj -> g.apply((UpdateQAppPermissionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QAppsRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String appId;
        private List<PermissionInput> grantPermissions = DefaultSdkAutoConstructList.getInstance();
        private List<PermissionInput> revokePermissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateQAppPermissionsRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.appId(model.appId);
            this.grantPermissions(model.grantPermissions);
            this.revokePermissions(model.revokePermissions);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getAppId() {
            return this.appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final List<PermissionInput.Builder> getGrantPermissions() {
            List<PermissionInput.Builder> result = UpdateQAppPermissionsInputGrantPermissionsListCopier.copyToBuilder(this.grantPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGrantPermissions(Collection<PermissionInput.BuilderImpl> grantPermissions) {
            this.grantPermissions = UpdateQAppPermissionsInputGrantPermissionsListCopier.copyFromBuilder(grantPermissions);
        }

        @Override
        public final Builder grantPermissions(Collection<PermissionInput> grantPermissions) {
            this.grantPermissions = UpdateQAppPermissionsInputGrantPermissionsListCopier.copy(grantPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantPermissions(PermissionInput ... grantPermissions) {
            this.grantPermissions(Arrays.asList(grantPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantPermissions(Consumer<PermissionInput.Builder> ... grantPermissions) {
            this.grantPermissions(Stream.of(grantPermissions).map(c -> (PermissionInput)((PermissionInput.Builder)PermissionInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PermissionInput.Builder> getRevokePermissions() {
            List<PermissionInput.Builder> result = UpdateQAppPermissionsInputRevokePermissionsListCopier.copyToBuilder(this.revokePermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRevokePermissions(Collection<PermissionInput.BuilderImpl> revokePermissions) {
            this.revokePermissions = UpdateQAppPermissionsInputRevokePermissionsListCopier.copyFromBuilder(revokePermissions);
        }

        @Override
        public final Builder revokePermissions(Collection<PermissionInput> revokePermissions) {
            this.revokePermissions = UpdateQAppPermissionsInputRevokePermissionsListCopier.copy(revokePermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revokePermissions(PermissionInput ... revokePermissions) {
            this.revokePermissions(Arrays.asList(revokePermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revokePermissions(Consumer<PermissionInput.Builder> ... revokePermissions) {
            this.revokePermissions(Stream.of(revokePermissions).map(c -> (PermissionInput)((PermissionInput.Builder)PermissionInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateQAppPermissionsRequest build() {
            return new UpdateQAppPermissionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QAppsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateQAppPermissionsRequest> {
        public Builder instanceId(String var1);

        public Builder appId(String var1);

        public Builder grantPermissions(Collection<PermissionInput> var1);

        public Builder grantPermissions(PermissionInput ... var1);

        public Builder grantPermissions(Consumer<PermissionInput.Builder> ... var1);

        public Builder revokePermissions(Collection<PermissionInput> var1);

        public Builder revokePermissions(PermissionInput ... var1);

        public Builder revokePermissions(Consumer<PermissionInput.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

