/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserAppItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserAppItem> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appId").getter(UserAppItem.getter(UserAppItem::appId)).setter(UserAppItem.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()}).build();
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(UserAppItem.getter(UserAppItem::appArn)).setter(UserAppItem.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(UserAppItem.getter(UserAppItem::title)).setter(UserAppItem.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UserAppItem.getter(UserAppItem::description)).setter(UserAppItem.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(UserAppItem.getter(UserAppItem::createdAt)).setter(UserAppItem.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Boolean> CAN_EDIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("canEdit").getter(UserAppItem.getter(UserAppItem::canEdit)).setter(UserAppItem.setter(Builder::canEdit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canEdit").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UserAppItem.getter(UserAppItem::status)).setter(UserAppItem.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Boolean> IS_VERIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isVerified").getter(UserAppItem.getter(UserAppItem::isVerified)).setter(UserAppItem.setter(Builder::isVerified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isVerified").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, APP_ARN_FIELD, TITLE_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, CAN_EDIT_FIELD, STATUS_FIELD, IS_VERIFIED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String appId;
    private final String appArn;
    private final String title;
    private final String description;
    private final Instant createdAt;
    private final Boolean canEdit;
    private final String status;
    private final Boolean isVerified;

    private UserAppItem(BuilderImpl builder) {
        this.appId = builder.appId;
        this.appArn = builder.appArn;
        this.title = builder.title;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.canEdit = builder.canEdit;
        this.status = builder.status;
        this.isVerified = builder.isVerified;
    }

    public final String appId() {
        return this.appId;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final String title() {
        return this.title;
    }

    public final String description() {
        return this.description;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Boolean canEdit() {
        return this.canEdit;
    }

    public final String status() {
        return this.status;
    }

    public final Boolean isVerified() {
        return this.isVerified;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.canEdit());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.isVerified());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserAppItem)) {
            return false;
        }
        UserAppItem other = (UserAppItem)obj;
        return Objects.equals(this.appId(), other.appId()) && Objects.equals(this.appArn(), other.appArn()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.canEdit(), other.canEdit()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.isVerified(), other.isVerified());
    }

    public final String toString() {
        return ToString.builder((String)"UserAppItem").add("AppId", (Object)this.appId()).add("AppArn", (Object)this.appArn()).add("Title", (Object)this.title()).add("Description", (Object)this.description()).add("CreatedAt", (Object)this.createdAt()).add("CanEdit", (Object)this.canEdit()).add("Status", (Object)this.status()).add("IsVerified", (Object)this.isVerified()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "canEdit": {
                return Optional.ofNullable(clazz.cast(this.canEdit()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "isVerified": {
                return Optional.ofNullable(clazz.cast(this.isVerified()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserAppItem, T> g) {
        return obj -> g.apply((UserAppItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appId;
        private String appArn;
        private String title;
        private String description;
        private Instant createdAt;
        private Boolean canEdit;
        private String status;
        private Boolean isVerified;

        private BuilderImpl() {
        }

        private BuilderImpl(UserAppItem model) {
            this.appId(model.appId);
            this.appArn(model.appArn);
            this.title(model.title);
            this.description(model.description);
            this.createdAt(model.createdAt);
            this.canEdit(model.canEdit);
            this.status(model.status);
            this.isVerified(model.isVerified);
        }

        public final String getAppId() {
            return this.appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Boolean getCanEdit() {
            return this.canEdit;
        }

        public final void setCanEdit(Boolean canEdit) {
            this.canEdit = canEdit;
        }

        @Override
        public final Builder canEdit(Boolean canEdit) {
            this.canEdit = canEdit;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Boolean getIsVerified() {
            return this.isVerified;
        }

        public final void setIsVerified(Boolean isVerified) {
            this.isVerified = isVerified;
        }

        @Override
        public final Builder isVerified(Boolean isVerified) {
            this.isVerified = isVerified;
            return this;
        }

        public UserAppItem build() {
            return new UserAppItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserAppItem> {
        public Builder appId(String var1);

        public Builder appArn(String var1);

        public Builder title(String var1);

        public Builder description(String var1);

        public Builder createdAt(Instant var1);

        public Builder canEdit(Boolean var1);

        public Builder status(String var1);

        public Builder isVerified(Boolean var1);
    }
}

