/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServiceTemplateVersionsRequest extends ProtonRequest implements
        ToCopyableBuilder<ListServiceTemplateVersionsRequest.Builder, ListServiceTemplateVersionsRequest> {
    private static final SdkField<String> MAJOR_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("majorVersion").getter(getter(ListServiceTemplateVersionsRequest::majorVersion))
            .setter(setter(Builder::majorVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("majorVersion").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListServiceTemplateVersionsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListServiceTemplateVersionsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateName").getter(getter(ListServiceTemplateVersionsRequest::templateName))
            .setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAJOR_VERSION_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, TEMPLATE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String majorVersion;

    private final Integer maxResults;

    private final String nextToken;

    private final String templateName;

    private ListServiceTemplateVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.majorVersion = builder.majorVersion;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.templateName = builder.templateName;
    }

    /**
     * <p>
     * To view a list of minor of versions under a major version of a service template, include
     * <code>major Version</code>.
     * </p>
     * <p>
     * To view a list of major versions of a service template, <i>exclude</i> <code>major Version</code>.
     * </p>
     * 
     * @return To view a list of minor of versions under a major version of a service template, include
     *         <code>major Version</code>.</p>
     *         <p>
     *         To view a list of major versions of a service template, <i>exclude</i> <code>major Version</code>.
     */
    public final String majorVersion() {
        return majorVersion;
    }

    /**
     * <p>
     * The maximum number of major or minor versions of a service template to list.
     * </p>
     * 
     * @return The maximum number of major or minor versions of a service template to list.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token that indicates the location of the next major or minor version in the array of major or minor versions of
     * a service template, after the list of major or minor versions that was previously requested.
     * </p>
     * 
     * @return A token that indicates the location of the next major or minor version in the array of major or minor
     *         versions of a service template, after the list of major or minor versions that was previously requested.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The name of the service template.
     * </p>
     * 
     * @return The name of the service template.
     */
    public final String templateName() {
        return templateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(majorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceTemplateVersionsRequest)) {
            return false;
        }
        ListServiceTemplateVersionsRequest other = (ListServiceTemplateVersionsRequest) obj;
        return Objects.equals(majorVersion(), other.majorVersion()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(templateName(), other.templateName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListServiceTemplateVersionsRequest").add("MajorVersion", majorVersion())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("TemplateName", templateName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "majorVersion":
            return Optional.ofNullable(clazz.cast(majorVersion()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "templateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("majorVersion", MAJOR_VERSION_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("templateName", TEMPLATE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListServiceTemplateVersionsRequest, T> g) {
        return obj -> g.apply((ListServiceTemplateVersionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ProtonRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListServiceTemplateVersionsRequest> {
        /**
         * <p>
         * To view a list of minor of versions under a major version of a service template, include
         * <code>major Version</code>.
         * </p>
         * <p>
         * To view a list of major versions of a service template, <i>exclude</i> <code>major Version</code>.
         * </p>
         * 
         * @param majorVersion
         *        To view a list of minor of versions under a major version of a service template, include
         *        <code>major Version</code>.</p>
         *        <p>
         *        To view a list of major versions of a service template, <i>exclude</i> <code>major Version</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder majorVersion(String majorVersion);

        /**
         * <p>
         * The maximum number of major or minor versions of a service template to list.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of major or minor versions of a service template to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token that indicates the location of the next major or minor version in the array of major or minor
         * versions of a service template, after the list of major or minor versions that was previously requested.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates the location of the next major or minor version in the array of major or minor
         *        versions of a service template, after the list of major or minor versions that was previously
         *        requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The name of the service template.
         * </p>
         * 
         * @param templateName
         *        The name of the service template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ProtonRequest.BuilderImpl implements Builder {
        private String majorVersion;

        private Integer maxResults;

        private String nextToken;

        private String templateName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceTemplateVersionsRequest model) {
            super(model);
            majorVersion(model.majorVersion);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            templateName(model.templateName);
        }

        public final String getMajorVersion() {
            return majorVersion;
        }

        public final void setMajorVersion(String majorVersion) {
            this.majorVersion = majorVersion;
        }

        @Override
        public final Builder majorVersion(String majorVersion) {
            this.majorVersion = majorVersion;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListServiceTemplateVersionsRequest build() {
            return new ListServiceTemplateVersionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
