/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListComponentProvisionedResourcesResponse extends ProtonResponse implements
        ToCopyableBuilder<ListComponentProvisionedResourcesResponse.Builder, ListComponentProvisionedResourcesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListComponentProvisionedResourcesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<ProvisionedResource>> PROVISIONED_RESOURCES_FIELD = SdkField
            .<List<ProvisionedResource>> builder(MarshallingType.LIST)
            .memberName("provisionedResources")
            .getter(getter(ListComponentProvisionedResourcesResponse::provisionedResources))
            .setter(setter(Builder::provisionedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProvisionedResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProvisionedResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            PROVISIONED_RESOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<ProvisionedResource> provisionedResources;

    private ListComponentProvisionedResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.provisionedResources = builder.provisionedResources;
    }

    /**
     * <p>
     * A token that indicates the location of the next provisioned resource in the array of provisioned resources, after
     * the current requested list of provisioned resources.
     * </p>
     * 
     * @return A token that indicates the location of the next provisioned resource in the array of provisioned
     *         resources, after the current requested list of provisioned resources.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProvisionedResources property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProvisionedResources() {
        return provisionedResources != null && !(provisionedResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of provisioned resources for a component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProvisionedResources} method.
     * </p>
     * 
     * @return An array of provisioned resources for a component.
     */
    public final List<ProvisionedResource> provisionedResources() {
        return provisionedResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasProvisionedResources() ? provisionedResources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComponentProvisionedResourcesResponse)) {
            return false;
        }
        ListComponentProvisionedResourcesResponse other = (ListComponentProvisionedResourcesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasProvisionedResources() == other.hasProvisionedResources()
                && Objects.equals(provisionedResources(), other.provisionedResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListComponentProvisionedResourcesResponse").add("NextToken", nextToken())
                .add("ProvisionedResources", hasProvisionedResources() ? provisionedResources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "provisionedResources":
            return Optional.ofNullable(clazz.cast(provisionedResources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("provisionedResources", PROVISIONED_RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListComponentProvisionedResourcesResponse, T> g) {
        return obj -> g.apply((ListComponentProvisionedResourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ProtonResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListComponentProvisionedResourcesResponse> {
        /**
         * <p>
         * A token that indicates the location of the next provisioned resource in the array of provisioned resources,
         * after the current requested list of provisioned resources.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates the location of the next provisioned resource in the array of provisioned
         *        resources, after the current requested list of provisioned resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of provisioned resources for a component.
         * </p>
         * 
         * @param provisionedResources
         *        An array of provisioned resources for a component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedResources(Collection<ProvisionedResource> provisionedResources);

        /**
         * <p>
         * An array of provisioned resources for a component.
         * </p>
         * 
         * @param provisionedResources
         *        An array of provisioned resources for a component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedResources(ProvisionedResource... provisionedResources);

        /**
         * <p>
         * An array of provisioned resources for a component.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.proton.model.ProvisionedResource.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.proton.model.ProvisionedResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.proton.model.ProvisionedResource.Builder#build()} is called
         * immediately and its result is passed to {@link #provisionedResources(List<ProvisionedResource>)}.
         * 
         * @param provisionedResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.proton.model.ProvisionedResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedResources(java.util.Collection<ProvisionedResource>)
         */
        Builder provisionedResources(Consumer<ProvisionedResource.Builder>... provisionedResources);
    }

    static final class BuilderImpl extends ProtonResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ProvisionedResource> provisionedResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListComponentProvisionedResourcesResponse model) {
            super(model);
            nextToken(model.nextToken);
            provisionedResources(model.provisionedResources);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ProvisionedResource.Builder> getProvisionedResources() {
            List<ProvisionedResource.Builder> result = ProvisionedResourceListCopier.copyToBuilder(this.provisionedResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProvisionedResources(Collection<ProvisionedResource.BuilderImpl> provisionedResources) {
            this.provisionedResources = ProvisionedResourceListCopier.copyFromBuilder(provisionedResources);
        }

        @Override
        public final Builder provisionedResources(Collection<ProvisionedResource> provisionedResources) {
            this.provisionedResources = ProvisionedResourceListCopier.copy(provisionedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedResources(ProvisionedResource... provisionedResources) {
            provisionedResources(Arrays.asList(provisionedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedResources(Consumer<ProvisionedResource.Builder>... provisionedResources) {
            provisionedResources(Stream.of(provisionedResources).map(c -> ProvisionedResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListComponentProvisionedResourcesResponse build() {
            return new ListComponentProvisionedResourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
