/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.proton.model.ProtonResponse;
import software.amazon.awssdk.services.proton.model.ServiceTemplateSummary;
import software.amazon.awssdk.services.proton.model.ServiceTemplateSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServiceTemplatesResponse
extends ProtonResponse
implements ToCopyableBuilder<Builder, ListServiceTemplatesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListServiceTemplatesResponse.getter(ListServiceTemplatesResponse::nextToken)).setter(ListServiceTemplatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ServiceTemplateSummary>> TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("templates").getter(ListServiceTemplatesResponse.getter(ListServiceTemplatesResponse::templates)).setter(ListServiceTemplatesResponse.setter(Builder::templates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceTemplateSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, TEMPLATES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListServiceTemplatesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ServiceTemplateSummary> templates;

    private ListServiceTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.templates = builder.templates;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasTemplates() {
        return this.templates != null && !(this.templates instanceof SdkAutoConstructList);
    }

    public final List<ServiceTemplateSummary> templates() {
        return this.templates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTemplates() ? this.templates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceTemplatesResponse)) {
            return false;
        }
        ListServiceTemplatesResponse other = (ListServiceTemplatesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasTemplates() == other.hasTemplates() && Objects.equals(this.templates(), other.templates());
    }

    public final String toString() {
        return ToString.builder((String)"ListServiceTemplatesResponse").add("NextToken", (Object)this.nextToken()).add("Templates", this.hasTemplates() ? this.templates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "templates": {
                return Optional.ofNullable(clazz.cast(this.templates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("templates", TEMPLATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListServiceTemplatesResponse, T> g) {
        return obj -> g.apply((ListServiceTemplatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ProtonResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ServiceTemplateSummary> templates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceTemplatesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.templates(model.templates);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ServiceTemplateSummary.Builder> getTemplates() {
            List<ServiceTemplateSummary.Builder> result = ServiceTemplateSummaryListCopier.copyToBuilder(this.templates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTemplates(Collection<ServiceTemplateSummary.BuilderImpl> templates) {
            this.templates = ServiceTemplateSummaryListCopier.copyFromBuilder(templates);
        }

        @Override
        public final Builder templates(Collection<ServiceTemplateSummary> templates) {
            this.templates = ServiceTemplateSummaryListCopier.copy(templates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templates(ServiceTemplateSummary ... templates) {
            this.templates(Arrays.asList(templates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templates(Consumer<ServiceTemplateSummary.Builder> ... templates) {
            this.templates(Stream.of(templates).map(c -> (ServiceTemplateSummary)((ServiceTemplateSummary.Builder)ServiceTemplateSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListServiceTemplatesResponse build() {
            return new ListServiceTemplatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ProtonResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListServiceTemplatesResponse> {
        public Builder nextToken(String var1);

        public Builder templates(Collection<ServiceTemplateSummary> var1);

        public Builder templates(ServiceTemplateSummary ... var1);

        public Builder templates(Consumer<ServiceTemplateSummary.Builder> ... var1);
    }
}

