/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.proton.model.ComponentState;
import software.amazon.awssdk.services.proton.model.EnvironmentState;
import software.amazon.awssdk.services.proton.model.ServiceInstanceState;
import software.amazon.awssdk.services.proton.model.ServicePipelineState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentState> {
    private static final SdkField<ComponentState> COMPONENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("component").getter(DeploymentState.getter(DeploymentState::component)).setter(DeploymentState.setter(Builder::component)).constructor(ComponentState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("component").build()}).build();
    private static final SdkField<EnvironmentState> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("environment").getter(DeploymentState.getter(DeploymentState::environment)).setter(DeploymentState.setter(Builder::environment)).constructor(EnvironmentState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environment").build()}).build();
    private static final SdkField<ServiceInstanceState> SERVICE_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serviceInstance").getter(DeploymentState.getter(DeploymentState::serviceInstance)).setter(DeploymentState.setter(Builder::serviceInstance)).constructor(ServiceInstanceState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceInstance").build()}).build();
    private static final SdkField<ServicePipelineState> SERVICE_PIPELINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("servicePipeline").getter(DeploymentState.getter(DeploymentState::servicePipeline)).setter(DeploymentState.setter(Builder::servicePipeline)).constructor(ServicePipelineState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("servicePipeline").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_FIELD, ENVIRONMENT_FIELD, SERVICE_INSTANCE_FIELD, SERVICE_PIPELINE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeploymentState.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ComponentState component;
    private final EnvironmentState environment;
    private final ServiceInstanceState serviceInstance;
    private final ServicePipelineState servicePipeline;
    private final Type type;

    private DeploymentState(BuilderImpl builder) {
        this.component = builder.component;
        this.environment = builder.environment;
        this.serviceInstance = builder.serviceInstance;
        this.servicePipeline = builder.servicePipeline;
        this.type = builder.type;
    }

    public final ComponentState component() {
        return this.component;
    }

    public final EnvironmentState environment() {
        return this.environment;
    }

    public final ServiceInstanceState serviceInstance() {
        return this.serviceInstance;
    }

    public final ServicePipelineState servicePipeline() {
        return this.servicePipeline;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.component());
        hashCode = 31 * hashCode + Objects.hashCode(this.environment());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceInstance());
        hashCode = 31 * hashCode + Objects.hashCode(this.servicePipeline());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentState)) {
            return false;
        }
        DeploymentState other = (DeploymentState)obj;
        return Objects.equals(this.component(), other.component()) && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.serviceInstance(), other.serviceInstance()) && Objects.equals(this.servicePipeline(), other.servicePipeline());
    }

    public final String toString() {
        return ToString.builder((String)"DeploymentState").add("Component", (Object)this.component()).add("Environment", (Object)this.environment()).add("ServiceInstance", (Object)this.serviceInstance()).add("ServicePipeline", (Object)this.servicePipeline()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "component": {
                return Optional.ofNullable(clazz.cast(this.component()));
            }
            case "environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "serviceInstance": {
                return Optional.ofNullable(clazz.cast(this.serviceInstance()));
            }
            case "servicePipeline": {
                return Optional.ofNullable(clazz.cast(this.servicePipeline()));
            }
        }
        return Optional.empty();
    }

    public static DeploymentState fromComponent(ComponentState component) {
        return (DeploymentState)DeploymentState.builder().component(component).build();
    }

    public static DeploymentState fromComponent(Consumer<ComponentState.Builder> component) {
        ComponentState.Builder builder = ComponentState.builder();
        component.accept(builder);
        return DeploymentState.fromComponent((ComponentState)builder.build());
    }

    public static DeploymentState fromEnvironment(EnvironmentState environment) {
        return (DeploymentState)DeploymentState.builder().environment(environment).build();
    }

    public static DeploymentState fromEnvironment(Consumer<EnvironmentState.Builder> environment) {
        EnvironmentState.Builder builder = EnvironmentState.builder();
        environment.accept(builder);
        return DeploymentState.fromEnvironment((EnvironmentState)builder.build());
    }

    public static DeploymentState fromServiceInstance(ServiceInstanceState serviceInstance) {
        return (DeploymentState)DeploymentState.builder().serviceInstance(serviceInstance).build();
    }

    public static DeploymentState fromServiceInstance(Consumer<ServiceInstanceState.Builder> serviceInstance) {
        ServiceInstanceState.Builder builder = ServiceInstanceState.builder();
        serviceInstance.accept(builder);
        return DeploymentState.fromServiceInstance((ServiceInstanceState)builder.build());
    }

    public static DeploymentState fromServicePipeline(ServicePipelineState servicePipeline) {
        return (DeploymentState)DeploymentState.builder().servicePipeline(servicePipeline).build();
    }

    public static DeploymentState fromServicePipeline(Consumer<ServicePipelineState.Builder> servicePipeline) {
        ServicePipelineState.Builder builder = ServicePipelineState.builder();
        servicePipeline.accept(builder);
        return DeploymentState.fromServicePipeline((ServicePipelineState)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("component", COMPONENT_FIELD);
        map.put("environment", ENVIRONMENT_FIELD);
        map.put("serviceInstance", SERVICE_INSTANCE_FIELD);
        map.put("servicePipeline", SERVICE_PIPELINE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeploymentState, T> g) {
        return obj -> g.apply((DeploymentState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        COMPONENT,
        ENVIRONMENT,
        SERVICE_INSTANCE,
        SERVICE_PIPELINE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ComponentState component;
        private EnvironmentState environment;
        private ServiceInstanceState serviceInstance;
        private ServicePipelineState servicePipeline;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentState model) {
            this.component(model.component);
            this.environment(model.environment);
            this.serviceInstance(model.serviceInstance);
            this.servicePipeline(model.servicePipeline);
        }

        public final ComponentState.Builder getComponent() {
            return this.component != null ? this.component.toBuilder() : null;
        }

        public final void setComponent(ComponentState.BuilderImpl component) {
            ComponentState oldValue = this.component;
            this.component = component != null ? component.build() : null;
            this.handleUnionValueChange(Type.COMPONENT, oldValue, this.component);
        }

        @Override
        public final Builder component(ComponentState component) {
            ComponentState oldValue = this.component;
            this.component = component;
            this.handleUnionValueChange(Type.COMPONENT, oldValue, this.component);
            return this;
        }

        public final EnvironmentState.Builder getEnvironment() {
            return this.environment != null ? this.environment.toBuilder() : null;
        }

        public final void setEnvironment(EnvironmentState.BuilderImpl environment) {
            EnvironmentState oldValue = this.environment;
            this.environment = environment != null ? environment.build() : null;
            this.handleUnionValueChange(Type.ENVIRONMENT, oldValue, this.environment);
        }

        @Override
        public final Builder environment(EnvironmentState environment) {
            EnvironmentState oldValue = this.environment;
            this.environment = environment;
            this.handleUnionValueChange(Type.ENVIRONMENT, oldValue, this.environment);
            return this;
        }

        public final ServiceInstanceState.Builder getServiceInstance() {
            return this.serviceInstance != null ? this.serviceInstance.toBuilder() : null;
        }

        public final void setServiceInstance(ServiceInstanceState.BuilderImpl serviceInstance) {
            ServiceInstanceState oldValue = this.serviceInstance;
            this.serviceInstance = serviceInstance != null ? serviceInstance.build() : null;
            this.handleUnionValueChange(Type.SERVICE_INSTANCE, oldValue, this.serviceInstance);
        }

        @Override
        public final Builder serviceInstance(ServiceInstanceState serviceInstance) {
            ServiceInstanceState oldValue = this.serviceInstance;
            this.serviceInstance = serviceInstance;
            this.handleUnionValueChange(Type.SERVICE_INSTANCE, oldValue, this.serviceInstance);
            return this;
        }

        public final ServicePipelineState.Builder getServicePipeline() {
            return this.servicePipeline != null ? this.servicePipeline.toBuilder() : null;
        }

        public final void setServicePipeline(ServicePipelineState.BuilderImpl servicePipeline) {
            ServicePipelineState oldValue = this.servicePipeline;
            this.servicePipeline = servicePipeline != null ? servicePipeline.build() : null;
            this.handleUnionValueChange(Type.SERVICE_PIPELINE, oldValue, this.servicePipeline);
        }

        @Override
        public final Builder servicePipeline(ServicePipelineState servicePipeline) {
            ServicePipelineState oldValue = this.servicePipeline;
            this.servicePipeline = servicePipeline;
            this.handleUnionValueChange(Type.SERVICE_PIPELINE, oldValue, this.servicePipeline);
            return this;
        }

        public DeploymentState build() {
            return new DeploymentState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentState> {
        public Builder component(ComponentState var1);

        default public Builder component(Consumer<ComponentState.Builder> component) {
            return this.component((ComponentState)((ComponentState.Builder)ComponentState.builder().applyMutation(component)).build());
        }

        public Builder environment(EnvironmentState var1);

        default public Builder environment(Consumer<EnvironmentState.Builder> environment) {
            return this.environment((EnvironmentState)((EnvironmentState.Builder)EnvironmentState.builder().applyMutation(environment)).build());
        }

        public Builder serviceInstance(ServiceInstanceState var1);

        default public Builder serviceInstance(Consumer<ServiceInstanceState.Builder> serviceInstance) {
            return this.serviceInstance((ServiceInstanceState)((ServiceInstanceState.Builder)ServiceInstanceState.builder().applyMutation(serviceInstance)).build());
        }

        public Builder servicePipeline(ServicePipelineState var1);

        default public Builder servicePipeline(Consumer<ServicePipelineState.Builder> servicePipeline) {
            return this.servicePipeline((ServicePipelineState)((ServicePipelineState.Builder)ServicePipelineState.builder().applyMutation(servicePipeline)).build());
        }
    }
}

