/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Output
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Output> {
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("key").getter(Output.getter(Output::key)).setter(Output.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()}).build();
    private static final SdkField<String> VALUE_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("valueString").getter(Output.getter(Output::valueString)).setter(Output.setter(Builder::valueString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueString").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_STRING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Output.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String key;
    private final String valueString;

    private Output(BuilderImpl builder) {
        this.key = builder.key;
        this.valueString = builder.valueString;
    }

    public final String key() {
        return this.key;
    }

    public final String valueString() {
        return this.valueString;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Output)) {
            return false;
        }
        Output other = (Output)obj;
        return Objects.equals(this.key(), other.key()) && Objects.equals(this.valueString(), other.valueString());
    }

    public final String toString() {
        return ToString.builder((String)"Output").add("Key", (Object)this.key()).add("ValueString", (Object)this.valueString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "valueString": {
                return Optional.ofNullable(clazz.cast(this.valueString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("key", KEY_FIELD);
        map.put("valueString", VALUE_STRING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Output, T> g) {
        return obj -> g.apply((Output)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private String valueString;

        private BuilderImpl() {
        }

        private BuilderImpl(Output model) {
            this.key(model.key);
            this.valueString(model.valueString);
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getValueString() {
            return this.valueString;
        }

        public final void setValueString(String valueString) {
            this.valueString = valueString;
        }

        @Override
        public final Builder valueString(String valueString) {
            this.valueString = valueString;
            return this;
        }

        public Output build() {
            return new Output(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Output> {
        public Builder key(String var1);

        public Builder valueString(String var1);
    }
}

