/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.proton.model.Provisioning;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceTemplateSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceTemplateSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ServiceTemplateSummary.getter(ServiceTemplateSummary::arn)).setter(ServiceTemplateSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(ServiceTemplateSummary.getter(ServiceTemplateSummary::createdAt)).setter(ServiceTemplateSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ServiceTemplateSummary.getter(ServiceTemplateSummary::description)).setter(ServiceTemplateSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(ServiceTemplateSummary.getter(ServiceTemplateSummary::displayName)).setter(ServiceTemplateSummary.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedAt").getter(ServiceTemplateSummary.getter(ServiceTemplateSummary::lastModifiedAt)).setter(ServiceTemplateSummary.setter(Builder::lastModifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedAt").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ServiceTemplateSummary.getter(ServiceTemplateSummary::name)).setter(ServiceTemplateSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PIPELINE_PROVISIONING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineProvisioning").getter(ServiceTemplateSummary.getter(ServiceTemplateSummary::pipelineProvisioningAsString)).setter(ServiceTemplateSummary.setter(Builder::pipelineProvisioning)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineProvisioning").build()}).build();
    private static final SdkField<String> RECOMMENDED_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendedVersion").getter(ServiceTemplateSummary.getter(ServiceTemplateSummary::recommendedVersion)).setter(ServiceTemplateSummary.setter(Builder::recommendedVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, LAST_MODIFIED_AT_FIELD, NAME_FIELD, PIPELINE_PROVISIONING_FIELD, RECOMMENDED_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceTemplateSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Instant createdAt;
    private final String description;
    private final String displayName;
    private final Instant lastModifiedAt;
    private final String name;
    private final String pipelineProvisioning;
    private final String recommendedVersion;

    private ServiceTemplateSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.name = builder.name;
        this.pipelineProvisioning = builder.pipelineProvisioning;
        this.recommendedVersion = builder.recommendedVersion;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String description() {
        return this.description;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final Instant lastModifiedAt() {
        return this.lastModifiedAt;
    }

    public final String name() {
        return this.name;
    }

    public final Provisioning pipelineProvisioning() {
        return Provisioning.fromValue(this.pipelineProvisioning);
    }

    public final String pipelineProvisioningAsString() {
        return this.pipelineProvisioning;
    }

    public final String recommendedVersion() {
        return this.recommendedVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineProvisioningAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendedVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceTemplateSummary)) {
            return false;
        }
        ServiceTemplateSummary other = (ServiceTemplateSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.lastModifiedAt(), other.lastModifiedAt()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.pipelineProvisioningAsString(), other.pipelineProvisioningAsString()) && Objects.equals(this.recommendedVersion(), other.recommendedVersion());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceTemplateSummary").add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DisplayName", (Object)(this.displayName() == null ? null : "*** Sensitive Data Redacted ***")).add("LastModifiedAt", (Object)this.lastModifiedAt()).add("Name", (Object)this.name()).add("PipelineProvisioning", (Object)this.pipelineProvisioningAsString()).add("RecommendedVersion", (Object)this.recommendedVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "lastModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedAt()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "pipelineProvisioning": {
                return Optional.ofNullable(clazz.cast(this.pipelineProvisioningAsString()));
            }
            case "recommendedVersion": {
                return Optional.ofNullable(clazz.cast(this.recommendedVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("lastModifiedAt", LAST_MODIFIED_AT_FIELD);
        map.put("name", NAME_FIELD);
        map.put("pipelineProvisioning", PIPELINE_PROVISIONING_FIELD);
        map.put("recommendedVersion", RECOMMENDED_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceTemplateSummary, T> g) {
        return obj -> g.apply((ServiceTemplateSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Instant createdAt;
        private String description;
        private String displayName;
        private Instant lastModifiedAt;
        private String name;
        private String pipelineProvisioning;
        private String recommendedVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceTemplateSummary model) {
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.displayName(model.displayName);
            this.lastModifiedAt(model.lastModifiedAt);
            this.name(model.name);
            this.pipelineProvisioning(model.pipelineProvisioning);
            this.recommendedVersion(model.recommendedVersion);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return this.lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPipelineProvisioning() {
            return this.pipelineProvisioning;
        }

        public final void setPipelineProvisioning(String pipelineProvisioning) {
            this.pipelineProvisioning = pipelineProvisioning;
        }

        @Override
        public final Builder pipelineProvisioning(String pipelineProvisioning) {
            this.pipelineProvisioning = pipelineProvisioning;
            return this;
        }

        @Override
        public final Builder pipelineProvisioning(Provisioning pipelineProvisioning) {
            this.pipelineProvisioning(pipelineProvisioning == null ? null : pipelineProvisioning.toString());
            return this;
        }

        public final String getRecommendedVersion() {
            return this.recommendedVersion;
        }

        public final void setRecommendedVersion(String recommendedVersion) {
            this.recommendedVersion = recommendedVersion;
        }

        @Override
        public final Builder recommendedVersion(String recommendedVersion) {
            this.recommendedVersion = recommendedVersion;
            return this;
        }

        public ServiceTemplateSummary build() {
            return new ServiceTemplateSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceTemplateSummary> {
        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder lastModifiedAt(Instant var1);

        public Builder name(String var1);

        public Builder pipelineProvisioning(String var1);

        public Builder pipelineProvisioning(Provisioning var1);

        public Builder recommendedVersion(String var1);
    }
}

