/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.proton.model.ProtonResponse;
import software.amazon.awssdk.services.proton.model.RepositorySyncDefinition;
import software.amazon.awssdk.services.proton.model.RepositorySyncDefinitionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRepositorySyncDefinitionsResponse
extends ProtonResponse
implements ToCopyableBuilder<Builder, ListRepositorySyncDefinitionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListRepositorySyncDefinitionsResponse.getter(ListRepositorySyncDefinitionsResponse::nextToken)).setter(ListRepositorySyncDefinitionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<RepositorySyncDefinition>> SYNC_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("syncDefinitions").getter(ListRepositorySyncDefinitionsResponse.getter(ListRepositorySyncDefinitionsResponse::syncDefinitions)).setter(ListRepositorySyncDefinitionsResponse.setter(Builder::syncDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RepositorySyncDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SYNC_DEFINITIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("syncDefinitions", SYNC_DEFINITIONS_FIELD);
        }
    });
    private final String nextToken;
    private final List<RepositorySyncDefinition> syncDefinitions;

    private ListRepositorySyncDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.syncDefinitions = builder.syncDefinitions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSyncDefinitions() {
        return this.syncDefinitions != null && !(this.syncDefinitions instanceof SdkAutoConstructList);
    }

    public final List<RepositorySyncDefinition> syncDefinitions() {
        return this.syncDefinitions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSyncDefinitions() ? this.syncDefinitions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRepositorySyncDefinitionsResponse)) {
            return false;
        }
        ListRepositorySyncDefinitionsResponse other = (ListRepositorySyncDefinitionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSyncDefinitions() == other.hasSyncDefinitions() && Objects.equals(this.syncDefinitions(), other.syncDefinitions());
    }

    public final String toString() {
        return ToString.builder((String)"ListRepositorySyncDefinitionsResponse").add("NextToken", (Object)this.nextToken()).add("SyncDefinitions", this.hasSyncDefinitions() ? this.syncDefinitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "syncDefinitions": {
                return Optional.ofNullable(clazz.cast(this.syncDefinitions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListRepositorySyncDefinitionsResponse, T> g) {
        return obj -> g.apply((ListRepositorySyncDefinitionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ProtonResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<RepositorySyncDefinition> syncDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRepositorySyncDefinitionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.syncDefinitions(model.syncDefinitions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RepositorySyncDefinition.Builder> getSyncDefinitions() {
            List<RepositorySyncDefinition.Builder> result = RepositorySyncDefinitionListCopier.copyToBuilder(this.syncDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSyncDefinitions(Collection<RepositorySyncDefinition.BuilderImpl> syncDefinitions) {
            this.syncDefinitions = RepositorySyncDefinitionListCopier.copyFromBuilder(syncDefinitions);
        }

        @Override
        public final Builder syncDefinitions(Collection<RepositorySyncDefinition> syncDefinitions) {
            this.syncDefinitions = RepositorySyncDefinitionListCopier.copy(syncDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder syncDefinitions(RepositorySyncDefinition ... syncDefinitions) {
            this.syncDefinitions(Arrays.asList(syncDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder syncDefinitions(Consumer<RepositorySyncDefinition.Builder> ... syncDefinitions) {
            this.syncDefinitions(Stream.of(syncDefinitions).map(c -> (RepositorySyncDefinition)((RepositorySyncDefinition.Builder)RepositorySyncDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRepositorySyncDefinitionsResponse build() {
            return new ListRepositorySyncDefinitionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ProtonResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRepositorySyncDefinitionsResponse> {
        public Builder nextToken(String var1);

        public Builder syncDefinitions(Collection<RepositorySyncDefinition> var1);

        public Builder syncDefinitions(RepositorySyncDefinition ... var1);

        public Builder syncDefinitions(Consumer<RepositorySyncDefinition.Builder> ... var1);
    }
}

