/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.proton.model.RepositoryProvider;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RepositoryBranchInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RepositoryBranchInput> {
    private static final SdkField<String> BRANCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("branch").getter(RepositoryBranchInput.getter(RepositoryBranchInput::branch)).setter(RepositoryBranchInput.setter(Builder::branch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branch").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(RepositoryBranchInput.getter(RepositoryBranchInput::name)).setter(RepositoryBranchInput.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("provider").getter(RepositoryBranchInput.getter(RepositoryBranchInput::providerAsString)).setter(RepositoryBranchInput.setter(Builder::provider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCH_FIELD, NAME_FIELD, PROVIDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("branch", BRANCH_FIELD);
            this.put("name", NAME_FIELD);
            this.put("provider", PROVIDER_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String branch;
    private final String name;
    private final String provider;

    private RepositoryBranchInput(BuilderImpl builder) {
        this.branch = builder.branch;
        this.name = builder.name;
        this.provider = builder.provider;
    }

    public final String branch() {
        return this.branch;
    }

    public final String name() {
        return this.name;
    }

    public final RepositoryProvider provider() {
        return RepositoryProvider.fromValue(this.provider);
    }

    public final String providerAsString() {
        return this.provider;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.branch());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryBranchInput)) {
            return false;
        }
        RepositoryBranchInput other = (RepositoryBranchInput)obj;
        return Objects.equals(this.branch(), other.branch()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.providerAsString(), other.providerAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RepositoryBranchInput").add("Branch", (Object)this.branch()).add("Name", (Object)this.name()).add("Provider", (Object)this.providerAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "branch": {
                return Optional.ofNullable(clazz.cast(this.branch()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "provider": {
                return Optional.ofNullable(clazz.cast(this.providerAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RepositoryBranchInput, T> g) {
        return obj -> g.apply((RepositoryBranchInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String branch;
        private String name;
        private String provider;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositoryBranchInput model) {
            this.branch(model.branch);
            this.name(model.name);
            this.provider(model.provider);
        }

        public final String getBranch() {
            return this.branch;
        }

        public final void setBranch(String branch) {
            this.branch = branch;
        }

        @Override
        public final Builder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProvider() {
            return this.provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public final Builder provider(RepositoryProvider provider) {
            this.provider(provider == null ? null : provider.toString());
            return this;
        }

        public RepositoryBranchInput build() {
            return new RepositoryBranchInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RepositoryBranchInput> {
        public Builder branch(String var1);

        public Builder name(String var1);

        public Builder provider(String var1);

        public Builder provider(RepositoryProvider var1);
    }
}

